package com.bringspring.system.msgcenter.service.strategy;

import com.bringspring.common.base.UserInfo;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 定义抽象策略基类
 * 将公共方法（如getTaskMsgContent、packThirdReceive）提取到抽象类中，供具体策略复用
 */
public abstract class AbstractMessageSender implements MessageSender {
    @Autowired
    protected McBusinessService mcBusinessService;
    @Autowired
    protected McMsgAccountService mcMsgAccountService;
    @Autowired
    protected SynThirdInfoService synThirdInfoService;
    @Autowired
    protected McTaskMsgReceiveService mcTaskMsgReceiveService;


    @Override
    public void send(boolean isAgain, String toType,
                     McMsgSendTemplateModel sendTemplate,
                     McTaskMsgContentEntity taskMsgContent,
                     List<McTaskMsgReceiveEntity> receiveList,
                     UserInfo currentUserInfo) {

        List<List<McTaskMsgReceiveEntity>> batches = ListUtils.partition(receiveList, getBatchSize());

        if ("4".equals(toType)) {
            // 接收人为非系统用户
            batches.forEach(
                    batch -> sendBatchNonSystemUser(isAgain, sendTemplate, taskMsgContent, batch, currentUserInfo)
            );
        } else {
            batches.forEach(batch -> sendBatch(isAgain, sendTemplate, taskMsgContent, batch, currentUserInfo));
        }
    }

    /**
     * 发送批量消息
     *
     * @param isAgain
     * @param sendTemplate
     * @param taskMsgContent
     * @param receiveList
     * @param currentUserInfo
     */
    protected abstract void sendBatch(boolean isAgain,
                                      McMsgSendTemplateModel sendTemplate,
                                      McTaskMsgContentEntity taskMsgContent,
                                      List<McTaskMsgReceiveEntity> receiveList,
                                      UserInfo currentUserInfo);

    /**
     * 发送批量消息-非系统用户
     *
     * @param isAgain
     * @param sendTemplate
     * @param taskMsgContent
     * @param receiveList
     * @param currentUserInfo
     */
    protected abstract void sendBatchNonSystemUser(boolean isAgain,
                                                   McMsgSendTemplateModel sendTemplate,
                                                   McTaskMsgContentEntity taskMsgContent,
                                                   List<McTaskMsgReceiveEntity> receiveList,
                                                   UserInfo currentUserInfo);

    /**
     * 获取批量发送的大小
     *
     * @return
     */
    protected abstract int getBatchSize();

    /**
     * 获取消息发送渠道类型
     *
     * @return
     */
    public abstract ChannelTypeEnum getChannelType();

}
