package com.bringspring.system.msgcenter.service.strategy;

import com.bringspring.common.base.UserInfo;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;

import java.util.List;

/**
 * 消息发送策略接口
 */
public interface MessageSender {
    /**
     * 发送消息
     *
     * @param isAgain         是否重发
     * @param sendTemplate    发送模板配置
     * @param taskMsgContent  消息内容
     * @param receiveList     接收人列表
     * @param currentUserInfo 当前用户信息
     */
    void send(boolean isAgain, String toType,
              McMsgSendTemplateModel sendTemplate,
              McTaskMsgContentEntity taskMsgContent,
              List<McTaskMsgReceiveEntity> receiveList,
              UserInfo currentUserInfo);
}
