package com.bringspring.system.permission.aop;

import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.constant.PermissionConstant;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.model.authorize.SaveBatchForm;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 分级管理
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 17:12
 */
@Slf4j
@Aspect
@Component
public class PermissionAdminAspect implements PermissionAdminBase{

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeRelationService organizeRelationService;

    /**
     * 分级管理切点
     */
    @Pointcut("@annotation(com.bringspring.common.annotation.OrganizeAdminIsTrator)")
    public void pointcut() {
    }

    /**
     * 分级管理切点
     *
     * @param pjp
     * @return
     * @throws Throwable
     */
    @Around("pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName){
        switch (methodName) {
            case PermissionConstant.METHOD_SAVE:
                if(userProvider.get().getIsAdministrator()){
                    return true;
                }
                String roleId = (String) pjp.getArgs()[0];
                List<String> orgIdList = organizeRelationService.getRelationListByRoleId(roleId).stream().map(OrganizeRelationEntity::getOrganizeId).collect(Collectors.toList());
                StringBuilder orgId = new StringBuilder();
                orgIdList.stream().forEach(t->{
                    orgId.append(t + ",");
                });
                return PermissionAspectUtil.getPermitByOrgIds(
                        // 操作目标对象组织ID集合
                        orgId.toString(),
                        operatorUserId,
                        PermissionConstant.METHOD_UPDATE);
            case PermissionConstant.METHOD_SAVE_BATCH:
                // 修改为只有超管才能操作
                if(userProvider.get().getIsAdministrator()){
                    return true;
                }
                // 得到角色id
                SaveBatchForm saveBatchForm = (SaveBatchForm) pjp.getArgs()[0];
                List<String> list = Arrays.asList(saveBatchForm.getRoleIds());
                if (list.size() == 0) {
                    list.add("");
                }
                // 得到组织id
                List<String> orgIdLists = organizeRelationService.getRelationListByRoleIdList(list).stream().map(OrganizeRelationEntity::getOrganizeId).collect(Collectors.toList());
                StringBuilder orgIds = new StringBuilder();
                orgIdLists.stream().forEach(t->{
                    orgIds.append(t + ",");
                });
                return PermissionAspectUtil.getPermitByOrgIds(
                        // 操作目标对象组织ID集合
                        orgIds.toString(),
                        operatorUserId,
                        PermissionConstant.METHOD_UPDATE);
            case PermissionConstant.METHOD_UPDATE:
                //判断是否有当前组织的修改权限
                String organizeId = String.valueOf(pjp.getArgs()[0]);
                return PermissionAspectUtil.containPermission(organizeId, operatorUserId, methodName);
            default:
                return false;
        }
    }

}
