package com.bringspring.system.permission.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;
import com.bringspring.system.permission.model.organizeadministrator.OrganizeAdminIsTratorCrForm;
import com.bringspring.system.permission.model.organizeadministrator.OrganizeAdminIsTratorInfoVo;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * 机构分级管理员
 *
 * @author jsbos
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021-08-30 10:30:04
 */
@Api(tags = "机构分级管理员", value = "organizeAdminIsTrator")
@Slf4j
@RestController
@RequestMapping("/api/permission/organizeAdminIsTrator")
public class OrganizeAdministratorController {

    @Autowired
    private OrganizeAdministratorService organizeAdminIsTratorService;


    /**
     * @return
     */
    @ApiOperation("拉取机构分级管理")
    @GetMapping("/{organizeId}")
    public ActionResult info(@PathVariable("organizeId") String organizeId) throws DataException {
        OrganizeAdministratorEntity entity = organizeAdminIsTratorService.getInfoByOrganizeId(organizeId);
        if (entity != null) {
            OrganizeAdminIsTratorInfoVo vo = JsonUtilEx.getJsonToBeanEx(entity, OrganizeAdminIsTratorInfoVo.class);
            return ActionResult.success(vo);
        } else {
            return ActionResult.success(entity);
        }
    }

    /**
     * 创建
     *
     * @param organizeAdminIsTratorCrForm
     * @return
     */
    @ApiOperation("新建机构分级管理员")
    @PostMapping
    public ActionResult create(@RequestBody @Valid OrganizeAdminIsTratorCrForm organizeAdminIsTratorCrForm) {
        OrganizeAdministratorEntity entity = JsonUtil.getJsonToBean(organizeAdminIsTratorCrForm,
				OrganizeAdministratorEntity.class);
        entity.setId(RandomUtil.uuId());
        organizeAdminIsTratorService.create(entity);
        return ActionResult.success(MsgCode.SU001.get());
    }

    /**
     * 更新组织
     *
     * @param organizeId                  主键值
     * @param organizeAdminIsTratorCrForm 实体对象
     * @return
     */
    @ApiOperation("更新机构分级管理")
    @PutMapping("/{organizeId}")
    public ActionResult update(@PathVariable("organizeId") String organizeId,
							   @RequestBody @Valid OrganizeAdminIsTratorCrForm organizeAdminIsTratorCrForm) {

        OrganizeAdministratorEntity entity = JsonUtil.getJsonToBean(organizeAdminIsTratorCrForm,
				OrganizeAdministratorEntity.class);

        //查看是否存在
        OrganizeAdministratorEntity getEntity = organizeAdminIsTratorService.getInfoByOrganizeId(organizeId);
        if (getEntity == null) {
            entity.setId(RandomUtil.uuId());
            organizeAdminIsTratorService.create(entity);
            return ActionResult.success(MsgCode.SU004.get());
        }

        boolean flag = organizeAdminIsTratorService.update(organizeId, entity);
        if (flag == false) {
            return ActionResult.fail(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 删除组织
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("删除机构分级管理")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        OrganizeAdministratorEntity organizeAdminIsTratorEntity = organizeAdminIsTratorService.getInfoByOrganizeId(id);
        if (organizeAdminIsTratorEntity != null) {
            organizeAdminIsTratorService.delete(organizeAdminIsTratorEntity);
            return ActionResult.success(MsgCode.SU003.get());
        } else {
            return ActionResult.fail("查无此记录");
        }
    }
}
