package com.bringspring.system.permission.model.user.page;

import com.bringspring.common.base.Pagination;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class PaginationUser extends Pagination {

    @ApiModelProperty(value = "用户ID",example = "1")
    private String organizeId;

    @ApiModelProperty(value = "组织Id集合")
    private List<String> organizeIds;

    @ApiModelProperty(value = "组织标识")
    private String organizeFlag;

    /** 地址 */
    @ApiModelProperty(value = "地址")
    private List<String> address;

    /**
     * 已授权用户
     */
    @ApiModelProperty(value = "已授权用户")
    private String alreadyAuthorize;

    /**
     * 已授权用户类型(销售: Area,实施：ExecuteArea,售后，工程 AfterArea)
     */
    @ApiModelProperty(value = "已授权用户类型")
    private String alreadyAuthorizeType = "Area";

    @ApiModelProperty(value = "角色ID",example = "1")
    private String roleId;

    @ApiModelProperty(value = "菜单ID",example = "1")
    private String menuId;
    @ApiModelProperty(value = "审核状态",example = "1")
    private String audit;

    @ApiModelProperty(value = "关键字",example = "1")
    private String keyword;

    /**
     *  部门
     */
    @ApiModelProperty(value = "部门集合")
    private List<String> departmentList;

}
