package com.bringspring.system.permission.model.user.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class UserListVO implements Serializable {

    @ApiModelProperty(value = "工号")
    private String code;
    @ApiModelProperty(value = "主键")
    private String id;
    @ApiModelProperty(value = "账号")
    private String account;
    @ApiModelProperty(value = "姓名")
    private String realName;
    @ApiModelProperty(value = "性别")
    private String gender;
    @ApiModelProperty(value = "手机")
    private String mobilePhone;
    @ApiModelProperty(value = "部门")
    private String organize;
    @ApiModelProperty(value = "说明")
    private String description;
    @ApiModelProperty(value = "状态")
    private Integer enabledMark;
    @ApiModelProperty(value = "添加时间", example = "1")
    private Long creatorTime;
    @ApiModelProperty(value = "排序")
    private Long sortCode;
    @JsonProperty("addressList")
    private List<String> addressList;
    @JsonProperty("changePasswordDate")
    private Long changePasswordDate;
    @JsonProperty("lastLogTime")
    private Long lastLogTime;

    @JsonProperty("areaManagerFlag")
    private String areaManagerFlag;

    @JsonProperty("companyFlag")
    private String companyFlag;
    private String auditResult;
    private String roleName;
    // 是否显示修改选项（暂时停用）
    // @ApiModelProperty(value = "是否管理员")
    // private Integer isAdministrator;
//    @ApiModelProperty(value = "锁定标志")
//    private Integer lockMark;

}
