package com.bringspring.system.permission.service.strategy;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.system.permission.model.authorize.ConditionModel;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Component;

/**
 * 具体策略类:
 * 定义：实现策略接口的具体算法类。
 * 角色：提供策略接口中定义的算法的具体实现。
 * 职责：根据条件模型ConditionModel中的条件信息，生成QueryWrapper的查询条件。
 * 适用性：适用于所有条件模型ConditionModel。
 * <p>
 * 默认策略
 */
@Component
public class DefaultConditionStrategy implements ConditionStrategy {

    @Override
    public void generateCondition(QueryWrapper<T> tw, String logic, ConditionModel.ConditionItemModel fieldItem) {
        // 设置tw的查询条件
        SymbolCommon.compare(logic, fieldItem.getField(), fieldItem.getOp(), fieldItem.getValue(), tw);
    }

    @Override
    public Integer key() {
        return 2;
    }

}
