package com.bringspring.system.permission.service.strategy;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.util.JsonUtil;
import org.apache.poi.ss.formula.functions.T;

import java.util.List;
import java.util.stream.Collectors;

import static com.bringspring.common.util.enums.SearchMethodEnum.*;

/**
 * 封装公共的条件比较
 */
public class SymbolCommon {

    public static void compare(String logic, String fieldName, String fieldSymbol, Object value,
                               QueryWrapper<T> tw) {
        if (And.getSymbol().equalsIgnoreCase(logic)) {
            if (fieldSymbol.equals(Equal.getSymbol())) {
                tw.eq(fieldName, value);
            } else if (fieldSymbol.equals(NotEqual.getSymbol())) {
                tw.ne(fieldName, value);
            } else if (fieldSymbol.equals(GreaterThan.getSymbol())) {
                tw.gt(fieldName, value);
            } else if (fieldSymbol.equals(LessThan.getSymbol())) {
                tw.lt(fieldName, value);
            } else if (fieldSymbol.equals(GreaterThanOrEqual.getSymbol())) {
                tw.ge(fieldName, value);
            } else if (fieldSymbol.equals(LessThanOrEqual.getSymbol())) {
                tw.le(fieldName, value);
            } else if (fieldSymbol.equals(Between.getSymbol())) {
                tw.between(fieldName, ((List) value).get(0), ((List) value).get(1));
            } else if (fieldSymbol.equals(Included.getSymbol())) {
                tw.in(fieldName, (List) value);
            } else if (fieldSymbol.equals(NotIncluded.getSymbol())) {
                tw.notIn(fieldName, (List) value);
            } else if (fieldSymbol.equals(IsNull.getSymbol())) {
                tw.isNull(fieldName);
            } else if (fieldSymbol.equals(IsNotNull.getSymbol())) {
                tw.isNotNull(fieldName);
            } else if (fieldSymbol.equals(Like.getSymbol())) {
                tw.like(fieldName, value);
            } else if (fieldSymbol.equals(NotLike.getSymbol())) {
                tw.notLike(fieldName, value);
            } else if (fieldSymbol.equals(LikeIn.getSymbol())) {
                tw.and(x -> {
                    List<List> jsonToList = JsonUtil.getJsonToList((String) value, List.class);
                    for (List<String> ll : jsonToList) {
                        List<String> valueList = JsonUtil.getJsonToList(ll, String.class);
                        if (valueList.size() > 1) {
                            String collect = valueList.stream().map((s) -> "\"" + s + "\"").collect(Collectors.joining(","));
                            collect = "[" + collect;
                            x.or().like(fieldName, collect);
                        } else {
                            String s = valueList.get(valueList.size() - 1);
                            s = "[" + "\"" + s + "\"";
                            x.or().like(fieldName, s);
                        }
                    }
                });
            }
        } else {
            if (fieldSymbol.equals(Equal.getSymbol())) {
                tw.or(
                        qw -> qw.eq(fieldName, value)
                );
            } else if (fieldSymbol.equals(NotEqual.getSymbol())) {
                tw.or(
                        qw -> qw.ne(fieldName, value)
                );
            } else if (fieldSymbol.equals(GreaterThan.getSymbol())) {
                tw.or(
                        qw -> qw.gt(fieldName, value)
                );
            } else if (fieldSymbol.equals(LessThan.getSymbol())) {
                tw.or(
                        qw -> qw.lt(fieldName, value)
                );
            } else if (fieldSymbol.equals(GreaterThanOrEqual.getSymbol())) {
                tw.or(
                        qw -> qw.ge(fieldName, value)
                );
            } else if (fieldSymbol.equals(LessThanOrEqual.getSymbol())) {
                tw.or(
                        qw -> qw.le(fieldName, value)
                );
            } else if (fieldSymbol.equals(Between.getSymbol())) {
                tw.or(
                        qw -> qw.between(fieldName, ((List) value).get(0), ((List) value).get(1))
                );
            } else if (fieldSymbol.equals(Included.getSymbol())) {
                tw.or(
                        qw -> qw.in(fieldName, (List) value)
                );
            } else if (fieldSymbol.equals(NotIncluded.getSymbol())) {
                tw.or(
                        qw -> qw.notIn(fieldName, (List) value)
                );
            } else if (fieldSymbol.equals(IsNull.getSymbol())) {
                tw.or(
                        qw -> qw.isNull(fieldName)
                );
            } else if (fieldSymbol.equals(IsNotNull.getSymbol())) {
                tw.or(
                        qw -> qw.isNotNull(fieldName)
                );
            } else if (fieldSymbol.equals(Like.getSymbol())) {
                tw.or(
                        qw -> qw.like(fieldName, value)
                );
            } else if (fieldSymbol.equals(NotLike.getSymbol())) {
                tw.or(
                        qw -> qw.notLike(fieldName, value)
                );
            } else if (fieldSymbol.equals(LikeIn.getSymbol())) {
                tw.or(x -> {
                    for (List<String> ll : (List<List<String>>) value) {
                        List<String> valueList = JsonUtil.getJsonToList(ll, String.class);
                        if (valueList.size() > 1) {
                            String collect = valueList.stream().map((s) -> "\"" + s + "\"").collect(Collectors.joining(","));
                            collect = "[" + collect;
                            x.or().like(fieldName, collect);
                        } else {
                            String s = valueList.get(valueList.size() - 1);
                            s = "[" + "\"" + s + "\"";
                            x.or().like(fieldName, s);
                        }
                    }
                });
            }
        }
    }
}
