/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.ComFieldsEntity;
import com.bringspring.system.base.model.comfields.ComFieldsCrForm;
import com.bringspring.system.base.model.comfields.ComFieldsInfoVO;
import com.bringspring.system.base.model.comfields.ComFieldsListVO;
import com.bringspring.system.base.model.comfields.ComFieldsUpForm;
import com.bringspring.system.base.service.ComFieldsService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e38\u7528\u5b57\u6bb5"}, value="CommonFields")
@RestController
@RequestMapping(value={"/api/system/CommonFields"})
public class ComFieldsController {
    @Autowired
    private ComFieldsService comFieldsService;

    @ApiOperation(value="\u83b7\u53d6\u5e38\u7528\u5b57\u6bb5\u5217\u8868")
    @GetMapping
    public ActionResult<ListVO<ComFieldsListVO>> list() {
        List<ComFieldsEntity> data = this.comFieldsService.getList();
        List list = JsonUtil.getJsonToList(data, ComFieldsListVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e38\u7528\u5b57\u6bb5")
    @GetMapping(value={"/{id}"})
    public ActionResult<ComFieldsInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ComFieldsEntity entity = this.comFieldsService.getInfo(id);
        ComFieldsInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ComFieldsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5e38\u7528\u5b57\u6bb5")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ComFieldsCrForm comFieldsCrForm) {
        ComFieldsEntity entity = (ComFieldsEntity)JsonUtil.getJsonToBean((Object)comFieldsCrForm, ComFieldsEntity.class);
        if (this.comFieldsService.isExistByFullName(entity.getField(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        this.comFieldsService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u5e38\u7528\u5b57\u6bb5")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ComFieldsUpForm comFieldsUpForm) {
        ComFieldsEntity entity = (ComFieldsEntity)JsonUtil.getJsonToBean((Object)comFieldsUpForm, ComFieldsEntity.class);
        if (this.comFieldsService.isExistByFullName(entity.getField(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        boolean flag = this.comFieldsService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u5e38\u7528\u5b57\u6bb5")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ComFieldsEntity entity = this.comFieldsService.getInfo(id);
        if (entity != null) {
            this.comFieldsService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

