/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.controller;

import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.util.JsonUtils;
import io.swagger.annotations.Api;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.message.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.util.crypto.WxCpCryptUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03"}, value="WxCpCallBack")
@RestController
@RequestMapping(value={"/api/white/callback/wxcp"})
public class WxCpCallBackController {
    private static final Logger log = LoggerFactory.getLogger(WxCpCallBackController.class);
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    WxCpConfiguration wxCpConfiguration;

    @PostMapping(value={"/test"})
    public String test(@PathVariable String corpId, @PathVariable Integer agentId, @RequestParam(name="userId", required=true) String userId) throws WxErrorException {
        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        List list = wxCpService.getExternalContactService().listExternalContacts(userId);
        return list.toString();
    }

    @GetMapping(value={"/{corpId}/{agentId}"}, produces={"text/plain;charset=utf-8"})
    public String authGet(@PathVariable String corpId, @PathVariable Integer agentId, @RequestParam(name="msg_signature", required=false) String signature, @RequestParam(name="timestamp", required=false) String timestamp, @RequestParam(name="nonce", required=false) String nonce, @RequestParam(name="echostr", required=false) String echostr) {
        log.info("\n\u63a5\u6536\u5230\u6765\u81ea\u5fae\u4fe1\u670d\u52a1\u5668\u7684\u8ba4\u8bc1\u6d88\u606f\uff1asignature = [{}], timestamp = [{}], nonce = [{}], echostr = [{}]", new Object[]{signature, timestamp, nonce, echostr});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signature, timestamp, nonce, echostr})) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
        }
        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94agentId=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", agentId));
        }
        if (wxCpService.checkSignature(signature, timestamp, nonce, echostr)) {
            return new WxCpCryptUtil(wxCpService.getWxCpConfigStorage()).decrypt(echostr);
        }
        return "\u975e\u6cd5\u8bf7\u6c42";
    }

    @PostMapping(value={"/{corpId}/{agentId}"}, produces={"application/xml; charset=UTF-8"})
    public String post(@PathVariable String corpId, @PathVariable Integer agentId, @RequestBody String requestBody, @RequestParam(value="msg_signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce) {
        log.info("\n\u63a5\u6536\u5fae\u4fe1\u8bf7\u6c42\uff1a[signature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\n{}\n] ", new Object[]{signature, timestamp, nonce, requestBody});
        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94agentId=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", agentId));
        }
        WxCpXmlMessage inMessage = WxCpXmlMessage.fromEncryptedXml((String)requestBody, (WxCpConfigStorage)wxCpService.getWxCpConfigStorage(), (String)timestamp, (String)nonce, (String)signature);
        log.info("\n\u6d88\u606f\u89e3\u5bc6\u540e\u5185\u5bb9\u4e3a\uff1a\n{} ", (Object)JsonUtils.toJson(inMessage));
        WxCpXmlOutMessage outMessage = this.route(corpId, agentId, inMessage);
        if (outMessage == null) {
            return "";
        }
        String out = outMessage.toEncryptedXml(wxCpService.getWxCpConfigStorage());
        log.info("\n\u7ec4\u88c5\u56de\u590d\u4fe1\u606f\uff1a{}", (Object)out);
        return out;
    }

    private WxCpXmlOutMessage route(String corpId, Integer agentId, WxCpXmlMessage message) {
        try {
            return this.wxCpConfiguration.getRouters().get(corpId + agentId).route(message);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

