/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidateCommonUtil {
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationService userRelationService;
    Map<String, SynThirdInfoEntity> thirdMap = new HashMap<String, SynThirdInfoEntity>();
    Map<String, UserEntity> userIdMap = new HashMap<String, UserEntity>();
    Map<String, UserEntity> accountMap = new HashMap<String, UserEntity>();
    Map<String, UserEntity> phoneMap = new HashMap<String, UserEntity>();
    Map<String, UserEntity> emailMap = new HashMap<String, UserEntity>();
    Map<String, OrganizeEntity> organizeMap = new HashMap<String, OrganizeEntity>();
    Map<String, PositionEntity> positionIdMap = new HashMap<String, PositionEntity>();
    String defaultRoleId = "393332333610065861";

    public void initData() {
        List<RoleEntity> list;
        List<PositionEntity> list2;
        List<OrganizeEntity> list3;
        List<UserEntity> userList;
        List<SynThirdInfoEntity> thirdList = this.synThirdInfoService.getList("1", "2");
        if (StringUtils.isNotEmpty(thirdList)) {
            for (SynThirdInfoEntity synThirdInfoEntity : thirdList) {
                this.thirdMap.put(synThirdInfoEntity.getThirdObjectId(), synThirdInfoEntity);
            }
        }
        if (StringUtils.isNotEmpty(userList = this.userService.getList())) {
            for (UserEntity userEntity : userList) {
                this.userIdMap.put(userEntity.getId(), userEntity);
                this.accountMap.put(userEntity.getAccount(), userEntity);
                this.phoneMap.put(userEntity.getMobilePhone(), userEntity);
                this.emailMap.put(userEntity.getEmail(), userEntity);
            }
        }
        if (StringUtils.isNotEmpty(list3 = this.organizeService.getList())) {
            for (OrganizeEntity organizeEntity : list3) {
                this.organizeMap.put(organizeEntity.getId(), organizeEntity);
            }
        }
        if (StringUtils.isNotEmpty(list2 = this.positionService.getList())) {
            for (PositionEntity entity : list2) {
                this.positionIdMap.put(entity.getFullName() + "/" + entity.getOrganizeId(), entity);
            }
        }
        if (CollectionUtil.isNotEmpty(list = this.roleService.getListByEnCode("SimpleUser"))) {
            this.defaultRoleId = list.get(0).getId();
        }
    }

    public String getDefaultRoleId() {
        return this.defaultRoleId;
    }

    public String getAccount(MyWxCpLinkedCorpUser qyuser) {
        if (StringUtils.isNotEmpty((String)qyuser.getMobile())) {
            return qyuser.getMobile();
        }
        if (StringUtils.isNotEmpty((String)qyuser.getEmail())) {
            return qyuser.getEmail();
        }
        return qyuser.getUserId();
    }

    public SynThirdInfoEntity getThirdEntityByThirdId(String thirdObjId) {
        if (this.thirdMap.containsKey(thirdObjId)) {
            return this.thirdMap.get(thirdObjId);
        }
        return null;
    }

    public SynThirdInfoEntity newSynThirdInfoForWxUser(String thirdObjid) {
        SynThirdInfoEntity synThirdInfoEntity = new SynThirdInfoEntity();
        synThirdInfoEntity.setId(RandomUtil.uuId());
        synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
        synThirdInfoEntity.setDataType(Integer.valueOf("2"));
        synThirdInfoEntity.setThirdObjectId(thirdObjid);
        return synThirdInfoEntity;
    }

    public UserEntity getUserEntity(String account, String phone, String email) {
        if (StringUtils.isNotEmpty((String)account) && this.accountMap.containsKey(account)) {
            return this.accountMap.get(account);
        }
        if (StringUtils.isNotEmpty((String)phone) && this.phoneMap.containsKey(phone)) {
            return this.phoneMap.get(phone);
        }
        if (StringUtils.isNotEmpty((String)email) && this.emailMap.containsKey(email)) {
            return this.emailMap.get(email);
        }
        return null;
    }

    public UserEntity getUserEntityByUserid(String userid) {
        if (this.userIdMap.containsKey(userid)) {
            return this.userIdMap.get(userid);
        }
        return null;
    }

    public UserEntity getUserEntityByAccount(String account) {
        if (this.accountMap.containsKey(account)) {
            return this.accountMap.get(account);
        }
        return null;
    }

    public OrganizeEntity getOrganizeEntityByDeptid(String deptId) {
        if (this.organizeMap.containsKey(deptId)) {
            return this.organizeMap.get(deptId);
        }
        return null;
    }

    public PositionEntity getPositionByUserid(String poitionKey) {
        if (this.positionIdMap.containsKey(poitionKey)) {
            return this.positionIdMap.get(poitionKey);
        }
        return null;
    }

    public void setDeptAndPosition(MyWxCpLinkedCorpUser qyuser, UserEntity userEntity) {
        String position = qyuser.getPosition();
        if (StringUtils.isNotEmpty((Object[])qyuser.getDepartment())) {
            String[] deptList = qyuser.getDepartment();
            String deptIds = "";
            String poitionIds = "";
            for (String cropDept : deptList) {
                String[] cropDeptArr = cropDept.split("/");
                String deptId = cropDeptArr[cropDeptArr.length - 1];
                OrganizeEntity organizeEntity = this.getOrganizeEntityByDeptid(deptId);
                if (!ObjectUtil.isNotEmpty((Object)organizeEntity)) continue;
                deptIds = deptIds + deptId + ",";
                if (!StringUtils.isNotEmpty((String)position)) continue;
                poitionIds = poitionIds + position + "/" + deptId + ",";
            }
            if (StringUtils.isNotEmpty((String)deptIds)) {
                deptIds = deptIds.substring(0, deptIds.length() - 1);
            }
            if (StringUtils.isNotEmpty((String)poitionIds)) {
                poitionIds = poitionIds.substring(0, poitionIds.length() - 1);
            }
            userEntity.setOrganizeId(deptIds);
            userEntity.setPositionId(poitionIds);
        } else {
            userEntity.setOrganizeId("");
            userEntity.setOrganizeId("");
        }
    }

    public String getCode(MyWxCpLinkedCorpUser qyuser) {
        String extattr;
        JSONObject jsonObject;
        JSONArray attrs;
        String value = null;
        if (StringUtils.isNotEmpty((String)qyuser.getExtattr()) && (attrs = (jsonObject = JSONObject.parseObject((String)(extattr = qyuser.getExtattr()))).getJSONArray("attrs")).size() != 0) {
            for (int i = 0; i < attrs.size(); ++i) {
                JSONObject attr = attrs.getJSONObject(i);
                String name = attr.getString("name");
                if (!StringUtils.isNotEmpty((String)name) || !name.contains("\u5de5\u53f7")) continue;
                value = attr.getString("value");
            }
        }
        return value;
    }

    public void setUserRelation(UserEntity userEntity) {
        String organizeIds = "";
        String positionIds = "";
        String roleIds = "";
        String groupIds = "";
        List<UserRelationEntity> relationList = this.userRelationService.getListByUserId(userEntity.getId());
        if (StringUtils.isNotEmpty(relationList)) {
            for (UserRelationEntity item : relationList) {
                switch (item.getObjectType()) {
                    case "Organize": {
                        organizeIds = organizeIds + item.getObjectId() + ",";
                        break;
                    }
                    case "Position": {
                        positionIds = positionIds + item.getObjectId() + ",";
                        break;
                    }
                    case "Role": {
                        roleIds = roleIds + item.getObjectId() + ",";
                        break;
                    }
                    case "Group": {
                        groupIds = groupIds + item.getObjectId() + ",";
                        break;
                    }
                }
            }
        }
        userEntity.setOrganizeId(organizeIds);
        userEntity.setPositionId(positionIds);
        userEntity.setRoleId(roleIds);
        userEntity.setGroupId(groupIds);
    }

    public void mergeDistinctOrganize(UserEntity aEntity, UserEntity bEntity) {
        String orgId1 = aEntity.getOrganizeId();
        String[] arr1 = StringUtils.isNotEmpty((String)orgId1) ? orgId1.split(",") : new String[]{};
        String orgId2 = bEntity.getOrganizeId();
        String[] arr2 = StringUtils.isNotEmpty((String)orgId2) ? orgId2.split(",") : new String[]{};
        Object[] arrAll = (String[])ArrayUtil.addAll((Object[][])new String[][]{arr1, arr2});
        Object[] distinct = (String[])ArrayUtil.distinct((Object[])arrAll);
        String orgId3 = ArrayUtil.join((Object[])distinct, (CharSequence)",");
        aEntity.setOrganizeId(orgId3);
    }

    public void mergeDistinctPosition(UserEntity aEntity, UserEntity bEntity) {
        String posId1 = aEntity.getPositionId();
        String[] posArr1 = StringUtils.isNotEmpty((String)posId1) ? posId1.split(",") : new String[]{};
        String posId2 = bEntity.getPositionId();
        String[] posArr2 = StringUtils.isNotEmpty((String)posId2) ? posId2.split(",") : new String[]{};
        Object[] posArrAll = (String[])ArrayUtil.addAll((Object[][])new String[][]{posArr1, posArr2});
        Object[] distinctPos = (String[])ArrayUtil.distinct((Object[])posArrAll);
        String posId3 = ArrayUtil.join((Object[])distinctPos, (CharSequence)",");
        aEntity.setPositionId(posId3);
    }

    public void convertPosition(Map<String, PositionEntity> savePositionMap, UserEntity userEntity) {
        String positionId = userEntity.getPositionId();
        String[] posArr = StringUtils.isNotEmpty((String)positionId) ? positionId.split(",") : new String[]{};
        int posLength = posArr.length;
        Object[] positionIdArr = new String[posLength];
        for (int i = 0; i < posLength; ++i) {
            String poitionKey = posArr[i];
            PositionEntity positionEntity = this.getPositionByUserid(poitionKey);
            if (ObjectUtil.isNotEmpty((Object)positionEntity)) {
                positionIdArr[i] = positionEntity.getId();
                continue;
            }
            if (savePositionMap.containsKey(poitionKey)) {
                positionIdArr[i] = savePositionMap.get(poitionKey).getId();
                continue;
            }
            if (!poitionKey.contains("/")) continue;
            String position = poitionKey.substring(0, poitionKey.lastIndexOf("/"));
            String deptId = poitionKey.substring(poitionKey.lastIndexOf("/") + 1);
            if (!StringUtils.isNotEmpty((String)position)) continue;
            PositionEntity posEntity = new PositionEntity();
            posEntity.setId(RandomUtil.uuId());
            posEntity.setFullName(position);
            posEntity.setOrganizeId(deptId);
            posEntity.setSortCode(0L);
            savePositionMap.put(poitionKey, posEntity);
            positionIdArr[i] = posEntity.getId();
        }
        String posId3 = ArrayUtil.join((Object[])positionIdArr, (CharSequence)",");
        userEntity.setPositionId(posId3);
    }
}

