/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MessageTypeConst;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.model.OnlineUserModel;
import com.bringspring.common.model.OnlineUserProvider;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.entity.MessageEntity;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.mapper.MessageMapper;
import com.bringspring.system.message.model.message.NoticePagination;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.message.service.MessagereceiveService;
import com.bringspring.system.message.util.SentMessageUtil;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
extends ServiceImpl<MessageMapper, MessageEntity>
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DataSourceModel dataSourceUtils;
    @Autowired
    private MessagereceiveService messagereceiveService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private SentMessageUtil sentMessageUtil;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private SysConfigService sysConfigService;

    @Override
    public List<MessageEntity> getNoticeList(NoticePagination pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageEntity::getType, (Object)1);
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(MessageEntity::getTitle, (Object)pagination.getKeyword());
        }
        if (!StrUtil.isBlank((CharSequence)pagination.getNoticeType())) {
            flag = true;
            queryWrapper.lambda().eq(MessageEntity::getNoticeTypeJC, (Object)pagination.getNoticeType());
        }
        StringBuilder orderBySql = new StringBuilder();
        if (flag) {
            orderBySql.append("publish_time DESC, ");
        }
        orderBySql.append("CASE WHEN enabled_mark = 0 THEN 0 ELSE 1 END ASC, CASE WHEN enabled_mark = 0 THEN creator_time END DESC, publish_time DESC, creator_time DESC");
        queryWrapper.last("ORDER BY " + orderBySql.toString());
        queryWrapper.lambda().select(new SFunction[]{MessageEntity::getId, MessageEntity::getNoticeTypeJC, MessageEntity::getCreatorUserId, MessageEntity::getCreatorTime, MessageEntity::getEnabledMark, MessageEntity::getLastModifyTime, MessageEntity::getTitle});
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<MessageEntity> getNoticeListByType(Pagination pagination, String type) {
        UserInfo userInfo = this.userProvider.get();
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageEntity::getType, (Object)1)).eq(MessageEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(MessageEntity::getToUserIds, (Object)userInfo.getUserId())).or(w1 -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w1.isNull(MessageEntity::getToUserIds);
        })).or(w2 -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w2.eq(MessageEntity::getToUserIds, (Object)"");
        })).or(w3 -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w3.eq(MessageEntity::getToUserIds, (Object)"@All");
        }));
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(MessageEntity::getTitle, (Object)pagination.getKeyword());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(MessageEntity::getEnabledMark)).orderByDesc(MessageEntity::getPublishTime)).orderByDesc(MessageEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(MessageEntity::getPublishTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<MessageEntity> getNoticeList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageEntity::getType, (Object)1)).eq(MessageEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByAsc(MessageEntity::getSortCode);
        return ((MessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<MessageEntity> getDashboardNoticeList() {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageEntity::getType, (Object)1)).eq(MessageEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().and(query -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)query.like(MessageEntity::getToUserIds, (Object)userInfo.getUserId())).or()).eq(MessageEntity::getSendType, (Object)"user")).eq(MessageEntity::getToUserIds, (Object)""));
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(MessageEntity::getSortCode)).orderByDesc(MessageEntity::getPublishTime)).orderByDesc(MessageEntity::getCreatorTime);
        Page page = new Page(1L, 20L);
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return iPage.getRecords();
    }

    @Override
    public List<MessageEntity> getMessageList(Pagination pagination, String type, String appid, String isShowRead) {
        return this.getMessageList(pagination, type, null, appid, isShowRead);
    }

    @Override
    public List<MessageEntity> getMessageList(Pagination pagination, String type) {
        return this.getMessageList(pagination, type, null, null, "0");
    }

    @Override
    public List<MessageEntity> getMessageList(Pagination pagination, String type, String user, String appid, String isShowRead) {
        String userId = StringUtil.isEmpty((String)user) ? this.userProvider.get().getUserId() : user;
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("userId", userId);
        StringBuilder sql = new StringBuilder();
        if (!StringUtil.isEmpty((String)pagination.getKeyword())) {
            sql.append(" AND m.title like '%" + pagination.getKeyword() + "%' ");
        }
        if (!StringUtil.isEmpty((String)type)) {
            if (type.contains(",")) {
                sql.append(" AND m.type in (" + type + ")");
            } else {
                sql.append(" AND m.type = '" + type + "'");
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)isShowRead)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageReceiveEntity::getUserId, (Object)userId)).eq(MessageReceiveEntity::getIsRead, (Object)isShowRead);
            List list = this.messagereceiveService.list((Wrapper)queryWrapper);
            String collect = list.stream().map(MessageReceiveEntity::getMessageId).collect(Collectors.joining(","));
            if (StringUtil.isEmpty((String)collect)) {
                return CollectionUtil.list((boolean)false);
            }
            sql.append(" and m.id in ( ").append(collect).append(" )");
        }
        List allToList = MessageTypeConst.getAllToList();
        List collect = allToList.stream().filter(x -> String.valueOf(x.getType()).startsWith("2")).collect(Collectors.toList());
        List contractMessage = collect.stream().map(MessageTypeConst::getType).collect(Collectors.toList());
        if (!StrUtil.isNotEmpty((CharSequence)appid)) {
            boolean pc;
            if (StringUtil.isNotEmpty((String)ServletUtils.getHeader((String)"jsbos-origin")) && !(pc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc"))) {
                contractMessage.add(4);
            }
            String collect2 = contractMessage.stream().map(String::valueOf).collect(Collectors.joining(","));
            sql.append(" and m.type not in (").append(collect2).append(" ) ");
        }
        sql.append(" ORDER BY  creator_time desc");
        map.put("sql", sql.toString());
        PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
        List<MessageEntity> lists = ((MessageMapper)this.baseMapper).getMessageList(map);
        PageInfo pageInfo = new PageInfo(lists);
        return pagination.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public List<MessageEntity> getMessageList(Pagination pagination) {
        return this.getMessageList(pagination, null);
    }

    @Override
    public MessageEntity getinfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageEntity::getId, (Object)id);
        return (MessageEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public MessageEntity getInfoDefault(int type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageEntity::getType, (Object)type)).eq(MessageEntity::getEnabledMark, (Object)1);
        if (type == 1) {
            queryWrapper.lambda().orderByDesc(MessageEntity::getCreatorTime);
        } else {
            queryWrapper.lambda().orderByDesc(MessageEntity::getLastModifyTime);
        }
        queryWrapper.lambda().select(new SFunction[]{MessageEntity::getId, MessageEntity::getTitle, MessageEntity::getCreatorTime});
        List list = ((Page)this.page((IPage)new Page(1L, 1L, false), (Wrapper)queryWrapper)).getRecords();
        MessageEntity entity = new MessageEntity();
        if (list.size() > 0) {
            entity = (MessageEntity)list.get(0);
        }
        return entity;
    }

    @Override
    @DSTransactional
    public void delete(MessageEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageReceiveEntity::getMessageId, (Object)entity.getId());
        this.messagereceiveService.remove((Wrapper)queryWrapper);
    }

    @Override
    public void create(MessageEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setBodyText(entity.getBodyText());
        entity.setType(1);
        entity.setEnabledMark(0);
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, MessageEntity entity) {
        entity.setId(id);
        entity.setBodyText(entity.getBodyText());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public MessageReceiveEntity messageRead(String messageId) {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageReceiveEntity::getUserId, (Object)userId)).eq(MessageReceiveEntity::getMessageId, (Object)messageId);
        MessageReceiveEntity entity = (MessageReceiveEntity)this.messagereceiveService.getOne((Wrapper)queryWrapper);
        if (entity != null) {
            entity.setIsRead(1);
            entity.setReadCount(entity.getReadCount() == null ? 1 : entity.getReadCount() + 1);
            entity.setReadTime(new Date());
            this.messagereceiveService.updateById(entity);
        }
        return entity;
    }

    @Override
    @DSTransactional
    public void messageRead() {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageReceiveEntity::getUserId, (Object)userId)).eq(MessageReceiveEntity::getIsRead, (Object)0);
        List entitys = this.messagereceiveService.list((Wrapper)queryWrapper);
        if (entitys.size() > 0) {
            for (MessageReceiveEntity entity : entitys) {
                entity.setIsRead(1);
                entity.setReadCount(entity.getReadCount() == null ? 1 : entity.getReadCount() + 1);
                entity.setReadTime(new Date());
                this.messagereceiveService.updateById(entity);
            }
        }
    }

    @Override
    @DSTransactional
    public void deleteRecord(List<String> messageIds) {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageReceiveEntity::getUserId, (Object)userId)).in(MessageReceiveEntity::getMessageId, messageIds);
        this.messagereceiveService.remove((Wrapper)queryWrapper);
    }

    @Override
    public int getUnreadCount(String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(MessageReceiveEntity::getUserId, (Object)userId)).eq(MessageReceiveEntity::getIsRead, (Object)0);
        return (int)this.messagereceiveService.count((Wrapper)queryWrapper);
    }

    @Override
    public int getUnreadNoticeCount(String userId) {
        int result = ((MessageMapper)this.baseMapper).getUnreadNoticeCount(userId);
        return result;
    }

    @Override
    public int getUnreadMessageCount(String userId) {
        int result = ((MessageMapper)this.baseMapper).getUnreadMessageCount(userId);
        return result;
    }

    @Override
    @DSTransactional
    public void sentNotice(List<String> toUserIds, MessageEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        entity.setEnabledMark(1);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userInfo.getUserId());
        this.updateById(entity);
        ArrayList idList = new ArrayList();
        Callable<Object> executeInsert = () -> {
            try {
                this.executeInsert(toUserIds, idList);
            }
            catch (Exception e) {
                entity.setEnabledMark(0);
                entity.setLastModifyTime(new Date());
                entity.setLastModifyUserId(userInfo.getUserId());
                this.updateById(entity);
                return false;
            }
            return true;
        };
        ThreadPoolTaskExecutor threadPoolExecutor = (ThreadPoolTaskExecutor)SpringContext.getBean(ThreadPoolTaskExecutor.class);
        Future submit = threadPoolExecutor.submit(executeInsert);
        try {
            if (((Boolean)submit.get()).booleanValue()) {
                Runnable runnable = () -> this.executeBatch(idList, entity, userInfo);
                threadPoolExecutor.submit(runnable);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void executeInsert(List<String> toUserIds, List<String> idList) throws Exception {
        ArrayList<String> key = new ArrayList<String>();
        try {
            int frequency = 10000;
            int count = toUserIds.size() / frequency + 1;
            for (int i = 0; i < count; ++i) {
                String cacheKey = RandomUtil.uuId() + toUserIds.get(i);
                int endSize = Math.min((i + 1) * frequency, toUserIds.size());
                this.cacheUtil.insert("foreverCacheSpace", cacheKey, toUserIds.subList(i * frequency, endSize));
                key.add(cacheKey);
            }
        }
        catch (Exception e) {
            key.clear();
            throw new Exception();
        }
        idList.addAll(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch(List<String> idList, MessageEntity entity, UserInfo userInfo) {
        List toUserIdList = null;
        String cacheKey = null;
        try {
            String dbName = "true".equals(this.configValueUtil.getMultiTenancy()) ? this.userProvider.get().getTenantDbConnectionString() : this.dataSourceUtils.getDbName();
            for (int i = 0; i < idList.size(); ++i) {
                Connection conn = ConnUtil.getConn((DataSourceMod)this.dataSourceUtils, (String)dbName);
                try {
                    PreparedStatement pstm = null;
                    try {
                        String sql = "INSERT INTO base_message_receive(ID,MESSAGE_ID,USER_ID,IS_READ,BODY_TEXT)  VALUES (?,?,?,?,?)";
                        pstm = conn.prepareStatement(sql);
                        conn.setAutoCommit(false);
                        cacheKey = idList.get(i);
                        List list = this.cacheUtil.getList(cacheKey, 0L, -1L);
                        toUserIdList = (List)list.get(0);
                        for (String toUserId : toUserIdList) {
                            pstm.setString(1, RandomUtil.uuId());
                            pstm.setString(2, entity.getId());
                            pstm.setString(3, toUserId);
                            pstm.setInt(4, 0);
                            pstm.setString(5, entity.getBodyText());
                            pstm.addBatch();
                        }
                        long time = System.currentTimeMillis();
                        log.info("\u5f00\u59cb\u63d0\u4ea4\u4e8b\u52a1\uff0c\u65f6\u95f4\uff1a" + time);
                        pstm.executeBatch();
                        conn.commit();
                        long endTime = System.currentTimeMillis();
                        log.info("\u4e8b\u52a1\u63d0\u4ea4\u5b8c\u6210\uff1a" + endTime + "\u8017\u65f6\uff1a" + (endTime - time));
                        pstm.close();
                        conn.close();
                        for (int j = 0; j < toUserIdList.size(); ++j) {
                            for (OnlineUserModel item : OnlineUserProvider.getOnlineUserList()) {
                                if (!((String)toUserIdList.get(j)).equals(item.getUserId()) || !userInfo.getTenantId().equals(item.getTenantId())) continue;
                                JSONObject map = new JSONObject();
                                map.put("method", (Object)"messagePush");
                                map.put("unreadNoticeCount", (Object)1);
                                map.put("messageType", (Object)1);
                                map.put("userId", (Object)userInfo.getTenantId());
                                map.put("toUserId", (Object)toUserIdList);
                                map.put("title", (Object)entity.getTitle());
                                JSONObject jSONObject = map;
                                synchronized (jSONObject) {
                                    item.getWebSocket().getAsyncRemote().sendText(map.toJSONString());
                                }
                            }
                        }
                        this.cacheUtil.remove("foreverCacheSpace", cacheKey);
                        continue;
                    }
                    finally {
                        if (Collections.singletonList(pstm).get(0) != null) {
                            pstm.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(conn).get(0) != null) {
                        conn.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.error("\u53d1\u9001\u6d88\u606f\u53d1\u751f\u9519\u8bef\uff0cKey\u503c\uff1a" + cacheKey + "\uff0c\u53d1\u9001\u4eba\uff1a" + userInfo.getUserId());
        }
    }

    @Override
    public void sentMessage(List<String> toUserIds, Integer type, String title) {
        this.sentMessage(toUserIds, type, title, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DSTransactional
    public void sentMessage(List<String> toUserIds, Integer type, String title, String descripts, Map<String, String> bodyText) {
        UserInfo userInfo = this.userProvider.get();
        MessageEntity entity = new MessageEntity();
        entity.setTitle(title);
        entity.setDescription(descripts);
        entity.setBodyText(JsonUtil.getObjectToString(bodyText));
        entity.setId(RandomUtil.uuId());
        entity.setType(type);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setLastModifyTime(entity.getCreatorTime());
        entity.setLastModifyUserId(entity.getCreatorUserId());
        ArrayList<MessageReceiveEntity> receiveEntityList = new ArrayList<MessageReceiveEntity>();
        for (String item : toUserIds) {
            MessageReceiveEntity messageReceiveEntity = new MessageReceiveEntity();
            messageReceiveEntity.setId(RandomUtil.uuId());
            messageReceiveEntity.setMessageId(entity.getId());
            messageReceiveEntity.setUserId(item);
            messageReceiveEntity.setIsRead(0);
            String msg = bodyText.get(item) != null ? bodyText.get(item) : "{}";
            messageReceiveEntity.setBodyText(msg);
            receiveEntityList.add(messageReceiveEntity);
        }
        this.save(entity);
        for (MessageReceiveEntity messageReceiveEntity : receiveEntityList) {
            this.messagereceiveService.save(messageReceiveEntity);
        }
        for (int i = 0; i < toUserIds.size(); ++i) {
            for (OnlineUserModel item : OnlineUserProvider.getOnlineUserList()) {
                if (!toUserIds.get(i).equals(item.getUserId()) || !userInfo.getTenantId().equals(item.getTenantId())) continue;
                JSONObject map = new JSONObject();
                map.put("method", (Object)"messagePush");
                map.put("unreadNoticeCount", (Object)1);
                map.put("messageType", (Object)2);
                map.put("userId", (Object)userInfo.getTenantId());
                map.put("toUserId", toUserIds);
                map.put("title", (Object)entity.getTitle());
                JSONObject jSONObject = map;
                synchronized (jSONObject) {
                    item.getWebSocket().getAsyncRemote().sendText(map.toJSONString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DSTransactional
    public void sentMessage(List<String> toUserIds, String title, String bodyText, Map<String, String> contentMsg) {
        UserInfo userInfo = this.userProvider.get();
        MessageEntity entity = new MessageEntity();
        entity.setTitle(title);
        entity.setBodyText(bodyText);
        entity.setId(RandomUtil.uuId());
        entity.setType(2);
        entity.setEnabledMark(1);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setLastModifyTime(entity.getCreatorTime());
        entity.setLastModifyUserId(entity.getCreatorUserId());
        ArrayList<MessageReceiveEntity> receiveEntityList = new ArrayList<MessageReceiveEntity>();
        for (String item : toUserIds) {
            MessageReceiveEntity messageReceiveEntity = new MessageReceiveEntity();
            messageReceiveEntity.setId(RandomUtil.uuId());
            messageReceiveEntity.setMessageId(entity.getId());
            messageReceiveEntity.setUserId(item);
            messageReceiveEntity.setIsRead(0);
            String msg = contentMsg.get(item) != null ? contentMsg.get(item) : "{}";
            messageReceiveEntity.setBodyText(msg);
            receiveEntityList.add(messageReceiveEntity);
        }
        this.save(entity);
        for (MessageReceiveEntity messageReceiveEntity : receiveEntityList) {
            this.messagereceiveService.save(messageReceiveEntity);
        }
        for (int i = 0; i < toUserIds.size(); ++i) {
            for (OnlineUserModel item : OnlineUserProvider.getOnlineUserList()) {
                if (!toUserIds.get(i).equals(item.getUserId()) || !userInfo.getTenantId().equals(item.getTenantId())) continue;
                JSONObject map = new JSONObject();
                map.put("method", (Object)"messagePush");
                map.put("unreadNoticeCount", (Object)1);
                map.put("messageType", (Object)2);
                map.put("userId", (Object)userInfo.getTenantId());
                map.put("toUserId", toUserIds);
                map.put("title", (Object)entity.getTitle());
                JSONObject jSONObject = map;
                synchronized (jSONObject) {
                    item.getWebSocket().getAsyncRemote().sendText(map.toJSONString());
                }
            }
        }
    }

    @Override
    public void sentTemplateMessage(List<String> toUserIds, Integer type, MessageTemplateEntity entity, Map<String, String> parameterMap, Map<String, String> bodyText) {
        if (entity != null) {
            String content;
            String title = entity.getTitle();
            if (StringUtils.isNotEmpty((String)title) && null != parameterMap) {
                StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
                title = strSubstitutor.replace(title);
            }
            if (StringUtils.isNotEmpty((String)(content = entity.getContent())) && null != parameterMap) {
                StringSubstitutor strSubstitutor = new StringSubstitutor(parameterMap, "{", "}");
                content = strSubstitutor.replace(content);
            }
            parameterMap.put("title", title);
            parameterMap.put("content", content);
            this.sentMessage(toUserIds, type, title, content, bodyText);
        }
    }

    @Override
    public void newSendMessage(String tsakCode, String sendCode, String title, String content, String appUrl, String PCurl, List<String> toUserIds, String type) {
        try {
            TaskMsg taskMsg = new TaskMsg();
            taskMsg.setTaskCode(tsakCode);
            taskMsg.setSendCode(sendCode);
            String messageTime = DateUtil.dateFormat((Date)new Date());
            String url = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("title", title);
            parameterMap.put("content", content);
            parameterMap.put("MessageTime", messageTime);
            LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
            linkMsgKeys.setLinkUrl(url);
            linkMsgKeys.setKeys(parameterMap);
            taskMsg.setBusinessKey(linkMsgKeys);
            CustomKeysLink customKeysLink = new CustomKeysLink();
            customKeysLink.setPcUrl(PCurl);
            customKeysLink.setAppUrl(appUrl);
            customKeysLink.setTermType(TermTypeEnum.TERM_APP_PC.getCode());
            taskMsg.setCustomKey(customKeysLink);
            if (type.equals("user")) {
                taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
            } else {
                taskMsg.setToUserIds(type);
            }
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

