/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.annotation.NotRecordedLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgInfoVO;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.McTaskMsgContentInfoVO;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveCrForm;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveInfoVO;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveListQuery;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveListVO;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceivePagination;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveSysListVO;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveUpForm;
import com.bringspring.system.msgcenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgcenter.service.McTaskMsgContentService;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.McTaskMsgService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e1a\u52a1\u573a\u666f\u6d88\u606f\u63a5\u6536\u8bb0\u5f55\u8868"}, value="mcTaskMsgReceive")
@RequestMapping(value={"/api/msgCenter/mcTaskMsgReceive"})
public class McTaskMsgReceiveController {
    private static final Logger log = LoggerFactory.getLogger(McTaskMsgReceiveController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;
    @Autowired
    private McTaskMsgContentService mcTaskMsgContentService;
    @Autowired
    private McTaskMsgService mcTaskMsgService;
    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McTaskMsgReceivePagination mcTaskMsgReceivePagination) throws IOException {
        List<McTaskMsgReceiveEntity> list = this.mcTaskMsgReceiveService.getList(mcTaskMsgReceivePagination);
        List listVO = JsonUtil.getJsonToList(list, McTaskMsgReceiveListVO.class);
        for (McTaskMsgReceiveListVO vo : listVO) {
            vo.setSysUserId(this.baseDataUtil.userSelectValues(vo.getSysUserId()));
            vo.setSendUserId(this.baseDataUtil.userSelectValue(vo.getSendUserId()));
            vo.setAgainUserId(this.baseDataUtil.userSelectValue(vo.getAgainUserId()));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            McTaskMsgEntity taskMsgEntity = this.mcTaskMsgService.getInfo(vo.getMsgId());
            if (!ObjectUtil.isNotNull((Object)taskMsgEntity)) continue;
            vo.setTaskCode(taskMsgEntity.getTaskCode());
            vo.setSendCode(taskMsgEntity.getSendCode());
            vo.setBusinessKey(taskMsgEntity.getBusinessKey());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcTaskMsgReceivePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getSysMsgList"})
    public ActionResult getSysMsgList(@RequestBody McTaskMsgReceivePagination mcTaskMsgReceivePagination) throws IOException {
        List<McTaskMsgReceiveEntity> list = this.mcTaskMsgReceiveService.getList(mcTaskMsgReceivePagination);
        List listVO = JsonUtil.getJsonToList(list, McTaskMsgReceiveSysListVO.class);
        for (McTaskMsgReceiveSysListVO vo : listVO) {
            McTaskMsgEntity taskMsgEntity;
            vo.setSysUserId(this.baseDataUtil.userSelectValues(vo.getSysUserId()));
            vo.setSendUserId(this.baseDataUtil.userSelectValue(vo.getSendUserId()));
            vo.setAgainUserId(this.baseDataUtil.userSelectValue(vo.getAgainUserId()));
            McTaskMsgContentEntity contentEntity = this.mcTaskMsgContentService.getInfo(vo.getContentId());
            if (ObjectUtil.isNotNull((Object)contentEntity)) {
                McTaskMsgContentInfoVO content = (McTaskMsgContentInfoVO)JsonUtil.getJsonToBean((Object)contentEntity, McTaskMsgContentInfoVO.class);
                vo.setContentType(content.getContentType());
                vo.setTitle(content.getTitle());
                vo.setContent(content.getContent());
                vo.setLinkUrl(content.getLinkUrl());
                vo.setPicUrl(content.getPicUrl());
            }
            if (!ObjectUtil.isNotNull((Object)(taskMsgEntity = this.mcTaskMsgService.getInfo(vo.getMsgId())))) continue;
            vo.setTaskCode(taskMsgEntity.getTaskCode());
            vo.setSendCode(taskMsgEntity.getSendCode());
            vo.setCustomKey(taskMsgEntity.getCustomKey());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcTaskMsgReceivePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid McTaskMsgReceiveCrForm mcTaskMsgReceiveCrForm) throws DataException {
        this.mcTaskMsgReceiveService.create(mcTaskMsgReceiveCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McTaskMsgReceiveInfoVO> info(@PathVariable(value="id") String id) {
        McTaskMsgReceiveEntity entity = this.mcTaskMsgReceiveService.getInfo(id);
        McTaskMsgReceiveInfoVO vo = (McTaskMsgReceiveInfoVO)JsonUtil.getJsonToBean((Object)entity, McTaskMsgReceiveInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McTaskMsgReceiveInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McTaskMsgContentEntity contentEntity;
        McMsgSendTemplateModel model;
        McTaskMsgReceiveEntity entity = this.mcTaskMsgReceiveService.getInfo(id);
        McTaskMsgReceiveInfoVO vo = (McTaskMsgReceiveInfoVO)JsonUtil.getJsonToBean((Object)entity, McTaskMsgReceiveInfoVO.class);
        McTaskMsgEntity taskMsgEntity = this.mcTaskMsgService.getInfo(vo.getMsgId());
        if (ObjectUtil.isNotNull((Object)taskMsgEntity)) {
            McTaskMsgInfoVO taskMsgInfo = (McTaskMsgInfoVO)JsonUtil.getJsonToBean((Object)taskMsgEntity, McTaskMsgInfoVO.class);
            vo.setTaskMsgInfo(taskMsgInfo);
        }
        if (ObjectUtil.isNotNull((Object)(model = this.mcMsgSendTemplateService.getModel(vo.getTemplateId())))) {
            vo.setSendTemplateModel(model);
        }
        if (ObjectUtil.isNotNull((Object)(contentEntity = this.mcTaskMsgContentService.getInfo(vo.getContentId())))) {
            McTaskMsgContentInfoVO content = (McTaskMsgContentInfoVO)JsonUtil.getJsonToBean((Object)contentEntity, McTaskMsgContentInfoVO.class);
            vo.setTaskMsgContentInfo(content);
        }
        vo.setChannelType(this.baseDataUtil.getDictName(vo.getChannelType(), "msgSendType"));
        vo.setSysUserId(this.baseDataUtil.userSelectValues(vo.getSysUserId()));
        vo.setSendUserId(this.baseDataUtil.userSelectValue(vo.getSendUserId()));
        vo.setAgainUserId(this.baseDataUtil.userSelectValue(vo.getAgainUserId()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McTaskMsgReceiveUpForm mcTaskMsgReceiveUpForm) throws DataException {
        McTaskMsgReceiveEntity entity = this.mcTaskMsgReceiveService.getInfo(id);
        if (entity != null) {
            this.mcTaskMsgReceiveService.update(id, mcTaskMsgReceiveUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{deleteMark}/{ids}"})
    public ActionResult delete(@PathVariable(value="deleteMark") Integer deleteMark, @PathVariable(value="ids") String[] ids) {
        if (ObjectUtil.isNull((Object)deleteMark)) {
            return ActionResult.fail((String)"\u53c2\u6570deleteMark\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)ids)) {
            return ActionResult.fail((String)"\u53c2\u6570ids\u4e3a\u7a7a");
        }
        this.mcTaskMsgReceiveService.delete(deleteMark, ids);
        return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/againSend/{msgId}/{ids}"})
    public ActionResult againSend(@PathVariable(value="msgId") String msgId, @PathVariable(value="ids") String[] ids) {
        if (StringUtils.isEmpty((String)msgId)) {
            return ActionResult.fail((String)"\u53c2\u6570msgId\u4e3a\u7a7a");
        }
        McTaskMsgEntity taskMsgInfo = this.mcTaskMsgService.getInfo(msgId);
        if (ObjectUtil.isEmpty((Object)taskMsgInfo)) {
            return ActionResult.fail((String)"\u6d88\u606f\u5185\u5bb9\u8868\u4e0d\u5b58\u5728");
        }
        if (ObjectUtil.isEmpty((Object)ids)) {
            return ActionResult.fail((String)"\u53c2\u6570ids\u4e3a\u7a7a");
        }
        McTaskMsgReceiveListQuery listQuery = new McTaskMsgReceiveListQuery();
        listQuery.setMsgId(taskMsgInfo.getId());
        listQuery.setIds(Arrays.asList(ids));
        List<McTaskMsgReceiveEntity> list = this.mcTaskMsgReceiveService.getList(listQuery);
        if (CollectionUtil.isEmpty(list)) {
            return ActionResult.fail((String)"\u63a5\u6536\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        try {
            this.mcTaskMsgReceiveService.againSendMessage(taskMsgInfo, list);
            return ActionResult.success((String)"\u91cd\u53d1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage();
            log.error(message);
            return ActionResult.fail((String)message);
        }
    }

    @NotRecordedLog
    @GetMapping(value={"/isRead/{isAll}/{ids}"})
    public ActionResult isRead(@PathVariable(value="isAll") String isAll, @PathVariable(value="ids") String[] ids) {
        if (StringUtils.isNotEmpty((String)isAll) || ObjectUtil.isNotEmpty((Object)ids)) {
            try {
                this.mcTaskMsgReceiveService.isRead(isAll, ids);
                return ActionResult.success((String)"\u5df2\u8bfb\u6210\u529f");
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = "\u5df2\u8bfb\u5931\u8d25\uff1a" + e.getMessage();
                log.error(message);
                return ActionResult.fail((String)message);
            }
        }
        return ActionResult.success((String)"\u5df2\u8bfb\u6210\u529f");
    }

    @NotRecordedLog
    @GetMapping(value={"/isReadCount"})
    public ActionResult isReadCount() {
        List<Map<String, Object>> vo = this.mcTaskMsgReceiveService.isReadCount();
        return ActionResult.success(vo);
    }

    @ApiOperation(value="\u95e8\u6237\u9762\u677f\u6570\u636e\u96c6")
    @PostMapping(value={"/portalPanelData"})
    public ActionResult portalPanelData(@RequestBody McTaskMsgReceivePagination pagination) {
        if (StringUtils.isEmpty((String)pagination.getMenuId())) {
            return ActionResult.fail((String)"\u83dc\u5355id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ActionResult result = new ActionResult();
        Map<String, Object> data = this.mcTaskMsgReceiveService.selectDataPanel(pagination);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6309\u6d88\u606f\u6e20\u9053\u5206\u7c7b\u7edf\u8ba1")
    @PostMapping(value={"/countGroupByChannelType"})
    public ActionResult countGroupByChannelType(@RequestBody McTaskMsgReceivePagination pagination) {
        if (StringUtils.isEmpty((String)pagination.getMenuId())) {
            return ActionResult.fail((String)"\u83dc\u5355id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ActionResult result = new ActionResult();
        List<Map<String, Object>> data = this.mcTaskMsgReceiveService.selectGroupByChannelType(pagination);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6309\u53d1\u9001\u65f6\u95f4\u5206\u7c7b\u7edf\u8ba1")
    @PostMapping(value={"/countGroupBySendTime"})
    public ActionResult countGroupBySendTime(@RequestBody McTaskMsgReceivePagination pagination) {
        if (StringUtils.isEmpty((String)pagination.getMenuId())) {
            return ActionResult.fail((String)"\u83dc\u5355id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ActionResult result = new ActionResult();
        List<Map<String, Object>> data = this.mcTaskMsgReceiveService.selectGroupBySendTime(pagination, 7);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }
}

