/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy;

import com.bringspring.common.base.UserInfo;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.strategy.MessageSender;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMessageSender
implements MessageSender {
    @Autowired
    protected McBusinessService mcBusinessService;
    @Autowired
    protected McMsgAccountService mcMsgAccountService;
    @Autowired
    protected SynThirdInfoService synThirdInfoService;
    @Autowired
    protected McTaskMsgReceiveService mcTaskMsgReceiveService;

    @Override
    public void send(boolean isAgain, String toType, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, UserInfo currentUserInfo) {
        List batches = ListUtils.partition(receiveList, (int)this.getBatchSize());
        if ("4".equals(toType)) {
            batches.forEach(batch -> this.sendBatchNonSystemUser(isAgain, sendTemplate, taskMsgContent, (List<McTaskMsgReceiveEntity>)batch, currentUserInfo));
        } else {
            batches.forEach(batch -> this.sendBatch(isAgain, sendTemplate, taskMsgContent, (List<McTaskMsgReceiveEntity>)batch, currentUserInfo));
        }
    }

    protected abstract void sendBatch(boolean var1, McMsgSendTemplateModel var2, McTaskMsgContentEntity var3, List<McTaskMsgReceiveEntity> var4, UserInfo var5);

    protected abstract void sendBatchNonSystemUser(boolean var1, McMsgSendTemplateModel var2, McTaskMsgContentEntity var3, List<McTaskMsgReceiveEntity> var4, UserInfo var5);

    protected abstract int getBatchSize();

    public abstract ChannelTypeEnum getChannelType();
}

