/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxMiniAppStrategy
extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WX_MINIAPP;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg, McMsgSendTemplateModel sendTemplate, Map<String, McTaskMsgContentEntity> contentMap, Map<String, List<McTaskMsgReceiveEntity>> receiveMap, Set<String> userSet) {
        McTaskMsgContentEntity maContent;
        String taskMsgId = taskMsg.getId();
        String templateId = sendTemplate.getId();
        String channelType = sendTemplate.getMessageType();
        String msgTemplateId = sendTemplate.getTemplateId();
        String msgAccountId = sendTemplate.getAccountConfigId();
        McMsgAccountEntity account = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        McMsgTemplateEntity msgTemplate = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        String maContentKey = channelType + msgTemplateId + msgAccountId;
        String maReceiveKey = channelType + msgTemplateId;
        if (!contentMap.containsKey(maContentKey)) {
            maContent = this.getTaskMsgContentKey(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(maContentKey, maContent);
        } else {
            maContent = contentMap.get(maContentKey);
        }
        if ("4".equals(taskMsg.getToType())) {
            if (!receiveMap.containsKey(maReceiveKey)) {
                List<McTaskMsgReceiveEntity> maReceiveList = this.packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, maContent.getId());
                receiveMap.put(maReceiveKey, maReceiveList);
            }
        } else {
            List<UserEntity> receiveUsers = this.userService.getUserByIds(new ArrayList<String>(userSet));
            String maCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getAppId();
            List<SynThirdInfoEntity> maThirdList = this.synThirdInfoService.getThirdInfoList("3", "2", maCrop, userSet);
            List<McTaskMsgReceiveEntity> receiveList = null;
            if (receiveMap.containsKey(maReceiveKey)) {
                receiveList = receiveMap.get(maReceiveKey);
            }
            List<McTaskMsgReceiveEntity> maReceiveList = this.packThirdReceive(receiveUsers, maThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, maContent.getId(), receiveList);
            receiveMap.put(maReceiveKey, maReceiveList);
        }
    }
}

