/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.strategy;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.system.permission.model.authorize.ConditionModel;
import com.bringspring.system.permission.service.strategy.ConditionStrategy;
import com.bringspring.system.permission.service.strategy.ConditionStrategyFactory;
import com.bringspring.system.permission.service.strategy.ContentStringInputText;
import com.bringspring.system.permission.service.strategy.ContentStringSelect;
import com.bringspring.system.permission.service.strategy.SymbolCommon;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class StringConditionStrategy
implements ConditionStrategy {
    @Autowired
    private ConditionStrategyFactory conditionStrategyFactory;
    @Autowired
    private ContentStringSelect contentStringSelect;
    @Autowired
    private ContentStringInputText contentStringInputText;

    @Override
    public void generateCondition(QueryWrapper<T> tw, String logic, ConditionModel.ConditionItemModel fieldItem) {
        Object value;
        String fieldSymbol = fieldItem.getOp();
        String fieldContent = fieldItem.getValue();
        if (fieldContent.startsWith("@")) {
            value = this.conditionStrategyFactory.getFieldContentText(fieldContent, fieldSymbol);
            if (ObjectUtils.isEmpty((Object)value)) {
                value = this.conditionStrategyFactory.getFieldContentString(fieldContent, fieldSymbol);
            }
        } else {
            value = fieldContent.startsWith("[") ? this.contentStringSelect.convertFieldContent(fieldContent, fieldSymbol) : this.contentStringInputText.convertFieldContent(fieldContent, fieldSymbol);
        }
        SymbolCommon.compare(logic, fieldItem.getField(), fieldSymbol, value, tw);
    }

    @Override
    public Integer key() {
        return 4;
    }
}

