/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.course.entity.TemsCourseCatalogEntity;
import com.bringspring.course.model.course.catalog.TemsCourseCatalogCrForm;
import com.bringspring.course.model.course.catalog.TemsCourseCatalogInfoVO;
import com.bringspring.course.model.course.catalog.TemsCourseCatalogListVO;
import com.bringspring.course.model.course.catalog.TemsCourseCatalogPagination;
import com.bringspring.course.model.course.catalog.TemsCourseCatalogSelector;
import com.bringspring.course.model.course.catalog.TemsCourseCatalogTreeModel;
import com.bringspring.course.model.course.catalog.TemsCourseCatalogUpForm;
import com.bringspring.course.service.TemsCourseCatalogService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bfe\u7a0b\u76ee\u5f55"}, value="course")
@RequestMapping(value={"/api/course/TemsCourseCatalog"})
public class TemsCourseCatalogController {
    private static final Logger log = LoggerFactory.getLogger(TemsCourseCatalogController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private TemsCourseCatalogService temsCourseCatalogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody TemsCourseCatalogPagination temsCourseCatalogPagination) throws IOException {
        List<TemsCourseCatalogEntity> list = this.temsCourseCatalogService.getList(temsCourseCatalogPagination);
        List listVO = JsonUtil.getJsonToList(list, TemsCourseCatalogListVO.class);
        for (TemsCourseCatalogListVO temsCourseCatalogVO : listVO) {
            temsCourseCatalogVO.setCreatorUserId(this.baseDataUtil.userSelectValue(temsCourseCatalogVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)temsCourseCatalogPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid TemsCourseCatalogCrForm temsCourseCatalogCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        TemsCourseCatalogEntity entity = (TemsCourseCatalogEntity)JsonUtil.getJsonToBean((Object)temsCourseCatalogCrForm, TemsCourseCatalogEntity.class);
        entity.setId(mainId);
        this.temsCourseCatalogService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<TemsCourseCatalogInfoVO> info(@PathVariable(value="id") String id) {
        TemsCourseCatalogEntity entity = this.temsCourseCatalogService.getInfo(id);
        TemsCourseCatalogInfoVO vo = (TemsCourseCatalogInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsCourseCatalogInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<TemsCourseCatalogInfoVO> detailInfo(@PathVariable(value="id") String id) {
        TemsCourseCatalogEntity entity = this.temsCourseCatalogService.getInfo(id);
        TemsCourseCatalogInfoVO vo = (TemsCourseCatalogInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsCourseCatalogInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid TemsCourseCatalogUpForm temsCourseCatalogUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        TemsCourseCatalogEntity entity = this.temsCourseCatalogService.getInfo(id);
        if (entity != null) {
            TemsCourseCatalogEntity subentity = (TemsCourseCatalogEntity)JsonUtil.getJsonToBean((Object)temsCourseCatalogUpForm, TemsCourseCatalogEntity.class);
            this.temsCourseCatalogService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        TemsCourseCatalogEntity entity = this.temsCourseCatalogService.getInfo(id);
        if (entity != null) {
            this.temsCourseCatalogService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7c7b\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<TemsCourseCatalogSelector>> getSelector(TemsCourseCatalogPagination query) {
        List<TemsCourseCatalogEntity> data = this.temsCourseCatalogService.getList(query);
        String keyword = query.getKeyword();
        if (!StringUtils.isEmpty((String)keyword)) {
            data = data.stream().filter(t -> t.getName().contains(keyword)).collect(Collectors.toList());
        }
        List models = JsonUtil.getJsonToList(data, TemsCourseCatalogTreeModel.class);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, TemsCourseCatalogSelector.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }
}

