/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.course.entity.TemsCourseCatalogEntity;
import com.bringspring.course.entity.TemsCourseChapterEntity;
import com.bringspring.course.entity.TemsCourseEntity;
import com.bringspring.course.entity.TemsCourseStudyChapterEntity;
import com.bringspring.course.entity.TemsCourseStudyEntity;
import com.bringspring.course.exception.CourseException;
import com.bringspring.course.model.course.chapter.TemsCourseChapterModel;
import com.bringspring.course.model.course.manager.TemsCourseCrForm;
import com.bringspring.course.model.course.manager.TemsCourseInfoVO;
import com.bringspring.course.model.course.manager.TemsCourseListVO;
import com.bringspring.course.model.course.manager.TemsCoursePagination;
import com.bringspring.course.model.course.manager.TemsCoursePaginationExportModel;
import com.bringspring.course.model.course.manager.TemsCourseUpForm;
import com.bringspring.course.model.study.TemsCourseStarModel;
import com.bringspring.course.model.study.TemsCourseStudyChapterModel;
import com.bringspring.course.model.study.TemsCourseStudyInfoVO;
import com.bringspring.course.service.TemsCourseCatalogService;
import com.bringspring.course.service.TemsCourseChapterService;
import com.bringspring.course.service.TemsCourseService;
import com.bringspring.course.service.TemsCourseStudyService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bfe\u7a0b\u7ba1\u7406"}, value="course")
@RequestMapping(value={"/api/course/TemsCourse"})
public class TemsCourseController {
    private static final Logger log = LoggerFactory.getLogger(TemsCourseController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private TemsCourseService temsCourseService;
    @Autowired
    private TemsCourseChapterService temsCourseChapterService;
    @Autowired
    private TemsCourseCatalogService temsCourseCatalogService;
    @Autowired
    private TemsCourseStudyService temsCourseStudyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody TemsCoursePagination temsCoursePagination) throws IOException {
        List<TemsCourseEntity> list = this.temsCourseService.getList(temsCoursePagination);
        List listVO = JsonUtil.getJsonToList(list, TemsCourseListVO.class);
        for (TemsCourseListVO temsCourseVO : listVO) {
            TemsCourseCatalogEntity info;
            temsCourseVO.setCover(this.baseDataUtil.getFileNameInJson(temsCourseVO.getCover()));
            if (StringUtils.isNotEmpty((String)temsCourseVO.getCategory()) && ObjectUtil.isNotNull((Object)(info = this.temsCourseCatalogService.getInfo(temsCourseVO.getCategory())))) {
                temsCourseVO.setCategory(info.getName());
            }
            temsCourseVO.setTeacher(this.baseDataUtil.userSelectValues(temsCourseVO.getTeacher()));
            temsCourseVO.setLabel(this.baseDataUtil.getDictName(temsCourseVO.getLabel(), "559344335821209861"));
            temsCourseVO.setCreatorUserId(this.baseDataUtil.userSelectValue(temsCourseVO.getCreatorUserId()));
            HashMap homeworkMap = new HashMap();
            HashMap homeExamMap = new HashMap();
            temsCourseVO.setLearningMaterials(this.baseDataUtil.getFileNameInJson(temsCourseVO.getLearningMaterials()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)temsCoursePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/study/{chapterId}"})
    public ActionResult<TemsCourseInfoVO> study(@PathVariable(value="chapterId") String chapterId, @RequestBody TemsCourseStudyChapterModel studyChapterModel) {
        TemsCourseInfoVO study = this.temsCourseService.study(chapterId, studyChapterModel.getProcess());
        return ActionResult.success((Object)study);
    }

    @PostMapping(value={"/star/{studyId}"})
    public ActionResult<TemsCourseInfoVO> star(@PathVariable(value="studyId") String studyId, @RequestBody TemsCourseStarModel starScore) throws CourseException {
        this.temsCourseService.star(studyId, starScore.getStarScore());
        return ActionResult.success((String)"\u8bfe\u7a0b\u8bc4\u5206\u6210\u529f");
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid TemsCourseCrForm temsCourseCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        temsCourseCrForm.setCreatorUserId(userInfo.getUserId());
        temsCourseCrForm.setCreatorTime(DateUtil.getNow());
        TemsCourseEntity entity = (TemsCourseEntity)JsonUtil.getJsonToBean((Object)temsCourseCrForm, TemsCourseEntity.class);
        entity.setId(mainId);
        this.temsCourseService.save(entity);
        List TemsCourseChapterList = JsonUtil.getJsonToList(temsCourseCrForm.getTemsCourseChapterList(), TemsCourseChapterEntity.class);
        for (TemsCourseChapterEntity entitys : TemsCourseChapterList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setCourseId(entity.getId());
            this.temsCourseChapterService.save(entitys);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f", (Object)entity);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(TemsCoursePaginationExportModel temsCoursePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)temsCoursePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        TemsCoursePagination temsCoursePagination = (TemsCoursePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)temsCoursePaginationExportModel), TemsCoursePagination.class));
        List list = null;
        for (Object entity : list) {
            ((TemsCourseEntity)entity).setCover(this.baseDataUtil.getFileNameInJson(((TemsCourseEntity)entity).getCover()));
            ((TemsCourseEntity)entity).setCategory(this.baseDataUtil.getDictName(((TemsCourseEntity)entity).getCategory(), "559344335821209861"));
            ((TemsCourseEntity)entity).setTeacher(this.baseDataUtil.userSelectValues(((TemsCourseEntity)entity).getTeacher()));
            ((TemsCourseEntity)entity).setLabel(this.baseDataUtil.getDictName(((TemsCourseEntity)entity).getLabel(), "559344335821209861"));
            ((TemsCourseEntity)entity).setCreatorUserId(this.baseDataUtil.userSelectValue(((TemsCourseEntity)entity).getCreatorUserId()));
            Object homeworkMap = new HashMap();
            ((TemsCourseEntity)entity).setHomework(this.baseDataUtil.getPopupSelectValue("456562722272711301", "id", "name", ((TemsCourseEntity)entity).getHomework(), (Map)homeworkMap));
            HashMap homeExamMap = new HashMap();
            ((TemsCourseEntity)entity).setHomeExam(this.baseDataUtil.getPopupSelectValue("458698670229951941", "id", "name", ((TemsCourseEntity)entity).getHomeExam(), homeExamMap));
            ((TemsCourseEntity)entity).setLearningMaterials(this.baseDataUtil.getFileNameInJson(((TemsCourseEntity)entity).getLearningMaterials()));
        }
        List listVO = JsonUtil.getJsonToList((Object)list, TemsCourseListVO.class);
        for (Object homeworkMap : listVO) {
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)temsCoursePaginationExportModel.getSelectKey()) ? temsCoursePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block52: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "cover": {
                        entitys.add(new ExcelExportEntity("\u5c01\u9762", (Object)"cover"));
                        continue block52;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"name"));
                        continue block52;
                    }
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u8bfe\u7a0b\u7f16\u7801", (Object)"code"));
                        continue block52;
                    }
                    case "category": {
                        entitys.add(new ExcelExportEntity("\u8bfe\u7a0b\u76ee\u5f55", (Object)"category"));
                        continue block52;
                    }
                    case "teacher": {
                        entitys.add(new ExcelExportEntity("\u8bb2\u5e08", (Object)"teacher"));
                        continue block52;
                    }
                    case "label": {
                        entitys.add(new ExcelExportEntity("\u6807\u7b7e", (Object)"label"));
                        continue block52;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u8bfe\u7a0b\u4ecb\u7ecd", (Object)"description"));
                        continue block52;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block52;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block52;
                    }
                    case "scope": {
                        entitys.add(new ExcelExportEntity("\u53ef\u89c1\u8303\u56f4", (Object)"scope"));
                        continue block52;
                    }
                    case "docsLearningLength": {
                        entitys.add(new ExcelExportEntity("\u6587\u6863\u5b66\u4e60\u65f6\u957f", (Object)"docsLearningLength"));
                        continue block52;
                    }
                    case "homework": {
                        entitys.add(new ExcelExportEntity("\u8bfe\u540e\u4f5c\u4e1a", (Object)"homework"));
                        continue block52;
                    }
                    case "homeExam": {
                        entitys.add(new ExcelExportEntity("\u8bfe\u540e\u8003\u8bd5", (Object)"homeExam"));
                        continue block52;
                    }
                    case "evaluation": {
                        entitys.add(new ExcelExportEntity("\u8bfe\u7a0b\u8bc4\u4f30", (Object)"evaluation"));
                        continue block52;
                    }
                    case "learningMaterials": {
                        entitys.add(new ExcelExportEntity("\u5b66\u4e60\u8d44\u6599", (Object)"learningMaterials"));
                        continue block52;
                    }
                    case "learningRewards": {
                        entitys.add(new ExcelExportEntity("\u5b66\u4e60\u5956\u52b1", (Object)"learningRewards"));
                        continue block52;
                    }
                    case "preventionCheat": {
                        entitys.add(new ExcelExportEntity("\u500d\u901f", (Object)"preventionCheat"));
                        continue block52;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u9632\u6302\u673a", (Object)"lastModifyUserId"));
                        continue block52;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u5f00\u542f\u540e\uff0c\u6bcf", (Object)"lastModifyTime"));
                        continue block52;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block52;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<TemsCourseInfoVO> info(@PathVariable(value="id") String id) {
        TemsCourseEntity entity = this.temsCourseService.getInfo(id);
        TemsCourseInfoVO vo = (TemsCourseInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsCourseInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<TemsCourseChapterEntity> TemsCourseChapterList = this.temsCourseService.getTemsCourseChapterList(id);
        for (TemsCourseChapterEntity temsCourseChapterEntity : TemsCourseChapterList) {
        }
        vo.setTemsCourseChapterList(JsonUtil.getJsonToList(TemsCourseChapterList, TemsCourseChapterModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<TemsCourseInfoVO> detailInfo(@PathVariable(value="id") String id) throws CourseException {
        if (StringUtils.isEmpty((String)id)) {
            throw new CourseException("\u8bfe\u7a0bId\u4e3a\u7a7a");
        }
        TemsCourseEntity entity = this.temsCourseService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            throw new CourseException("\u672a\u627e\u5230\u8bfe\u7a0b");
        }
        if (entity.getEnabledMark() != 20) {
            throw new CourseException("\u8bfe\u7a0b\u672a\u53d1\u5e03\u6216\u5df2\u4e0b\u7ebf\u3002\u8bf7\u91cd\u8bd5");
        }
        TemsCourseInfoVO vo = (TemsCourseInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsCourseInfoVO.class);
        List<TemsCourseChapterEntity> temsCourseChapterList = this.temsCourseService.getTemsCourseChapterList(id);
        List temsCourseChapterModelList = JsonUtil.getJsonToList(temsCourseChapterList, TemsCourseChapterModel.class);
        TemsCourseStudyEntity infoByCourse = this.temsCourseStudyService.getInfoByCourseId(id);
        TemsCourseStudyInfoVO jsonToBean = (TemsCourseStudyInfoVO)JsonUtil.getJsonToBean((Object)infoByCourse, TemsCourseStudyInfoVO.class);
        vo.setTemsCourseStudyInfo(jsonToBean);
        if (null != infoByCourse) {
            List<TemsCourseStudyChapterEntity> temsCourseStudyChapterList = this.temsCourseStudyService.getTemsCourseStudyChapterList(infoByCourse.getId());
            for (TemsCourseChapterModel temsCourseChapterModel : temsCourseChapterModelList) {
                for (TemsCourseStudyChapterEntity studyChapter : temsCourseStudyChapterList) {
                    if (!studyChapter.getChapterId().equals(temsCourseChapterModel.getId())) continue;
                    temsCourseChapterModel.setProcess(studyChapter.getProcess());
                    temsCourseChapterModel.setEnabledMark(studyChapter.getEnabledMark());
                }
            }
        }
        vo.setTemsCourseChapterList(temsCourseChapterModelList);
        vo.setCover(vo.getCover());
        vo.setTeacher(this.baseDataUtil.userSelectValues(vo.getTeacher()));
        vo.setLabel(this.baseDataUtil.getDictName(vo.getLabel(), "559344335821209861"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLearningMaterials(this.baseDataUtil.getFileNameInJson(vo.getLearningMaterials()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid TemsCourseUpForm temsCourseUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        TemsCourseEntity entity = this.temsCourseService.getInfo(id);
        if (entity != null) {
            TemsCourseEntity subentity = (TemsCourseEntity)JsonUtil.getJsonToBean((Object)temsCourseUpForm, TemsCourseEntity.class);
            this.temsCourseService.update(id, subentity);
            QueryWrapper TemsCourseChapterqueryWrapper = new QueryWrapper();
            TemsCourseChapterqueryWrapper.lambda().eq(TemsCourseChapterEntity::getCourseId, (Object)entity.getId());
            this.temsCourseChapterService.remove((Wrapper)TemsCourseChapterqueryWrapper);
            List TemsCourseChapterList = JsonUtil.getJsonToList(temsCourseUpForm.getTemsCourseChapterList(), TemsCourseChapterEntity.class);
            for (TemsCourseChapterEntity entitys : TemsCourseChapterList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setCourseId(entity.getId());
                this.temsCourseChapterService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/unpublish/{id}"})
    @DSTransactional
    public ActionResult unpublish(@PathVariable(value="id") String id) {
        TemsCourseEntity entity = this.temsCourseService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(10);
            this.temsCourseService.update(id, entity);
        }
        return ActionResult.success((String)"\u53d6\u6d88\u53d1\u5e03\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        TemsCourseEntity entity = this.temsCourseService.getInfo(id);
        if (entity != null) {
            this.temsCourseService.delete(entity);
            QueryWrapper queryWrapperTemsCourseChapter = new QueryWrapper();
            queryWrapperTemsCourseChapter.lambda().eq(TemsCourseChapterEntity::getCourseId, (Object)entity.getId());
            this.temsCourseChapterService.remove((Wrapper)queryWrapperTemsCourseChapter);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

