/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.course.entity.TemsCourseEntity;
import com.bringspring.course.entity.TemsCourseStudyChapterEntity;
import com.bringspring.course.entity.TemsCourseStudyEntity;
import com.bringspring.course.model.study.TemsCourseModel;
import com.bringspring.course.model.study.TemsCourseStudyChapterModel;
import com.bringspring.course.model.study.TemsCourseStudyCrForm;
import com.bringspring.course.model.study.TemsCourseStudyInfoVO;
import com.bringspring.course.model.study.TemsCourseStudyListVO;
import com.bringspring.course.model.study.TemsCourseStudyPagination;
import com.bringspring.course.model.study.TemsCourseStudyUpForm;
import com.bringspring.course.service.TemsCourseService;
import com.bringspring.course.service.TemsCourseStudyChapterService;
import com.bringspring.course.service.TemsCourseStudyService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bfe\u7a0b\u5b66\u4e60"}, value="course")
@RequestMapping(value={"/api/course/TemsCourseStudy"})
public class TemsCourseStudyController {
    private static final Logger log = LoggerFactory.getLogger(TemsCourseStudyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private TemsCourseStudyService temsCourseStudyService;
    @Autowired
    private TemsCourseStudyChapterService temsCourseStudyChapterService;
    @Autowired
    private TemsCourseService temsCourseService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody TemsCourseStudyPagination temsCourseStudyPagination) throws IOException {
        List<TemsCourseStudyEntity> list = this.temsCourseStudyService.getList(temsCourseStudyPagination);
        List listVO = JsonUtil.getJsonToList(list, TemsCourseStudyListVO.class);
        for (TemsCourseStudyListVO temsCourseStudyVO : listVO) {
            TemsCourseEntity temsCourseEntity = this.temsCourseStudyService.getTemsCourse(temsCourseStudyVO.getCourseId());
            if (!ObjectUtil.isNotEmpty((Object)temsCourseEntity)) continue;
            temsCourseStudyVO.setName(temsCourseEntity.getName());
            temsCourseStudyVO.setCover(temsCourseEntity.getCover());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)temsCourseStudyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid TemsCourseStudyCrForm temsCourseStudyCrForm) throws DataException {
        this.temsCourseStudyService.create(temsCourseStudyCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<TemsCourseStudyInfoVO> info(@PathVariable(value="id") String id) {
        TemsCourseStudyEntity entity = this.temsCourseStudyService.getInfo(id);
        TemsCourseStudyInfoVO vo = (TemsCourseStudyInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsCourseStudyInfoVO.class);
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        List<TemsCourseStudyChapterEntity> TemsCourseStudyChapterList = this.temsCourseStudyService.getTemsCourseStudyChapterList(id);
        for (TemsCourseStudyChapterEntity temsCourseStudyChapterEntity : TemsCourseStudyChapterList) {
        }
        vo.setTemsCourseStudyChapterList(JsonUtil.getJsonToList(TemsCourseStudyChapterList, TemsCourseStudyChapterModel.class));
        QueryWrapper queryWrapperTemsCourse = new QueryWrapper();
        queryWrapperTemsCourse.lambda().eq(TemsCourseEntity::getId, (Object)entity.getCourseId());
        TemsCourseEntity tems_courseEntity = (TemsCourseEntity)this.temsCourseService.getOne((Wrapper)queryWrapperTemsCourse);
        vo.setTemsCourse((TemsCourseModel)JsonUtil.getJsonToBean((Object)tems_courseEntity, TemsCourseModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<TemsCourseStudyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        TemsCourseStudyEntity entity = this.temsCourseStudyService.getInfo(id);
        TemsCourseStudyInfoVO vo = (TemsCourseStudyInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsCourseStudyInfoVO.class);
        List<TemsCourseStudyChapterEntity> temsCourseStudyChapterList = this.temsCourseStudyService.getTemsCourseStudyChapterList(id);
        List temsCourseStudyChapterModelList = JsonUtil.getJsonToList(temsCourseStudyChapterList, TemsCourseStudyChapterModel.class);
        for (TemsCourseStudyChapterModel temsCourseStudyChapterModel : temsCourseStudyChapterModelList) {
        }
        vo.setTemsCourseStudyChapterList(temsCourseStudyChapterModelList);
        QueryWrapper queryWrapperTemsCourse = new QueryWrapper();
        queryWrapperTemsCourse.lambda().eq(TemsCourseEntity::getId, (Object)entity.getCourseId());
        TemsCourseEntity tems_courseEntity = (TemsCourseEntity)this.temsCourseService.getOne((Wrapper)queryWrapperTemsCourse);
        if (ObjectUtil.isEmpty((Object)tems_courseEntity)) {
            tems_courseEntity = new TemsCourseEntity();
        }
        tems_courseEntity.setCover(this.baseDataUtil.getFileNameInJson(tems_courseEntity.getCover()));
        vo.setTemsCourse((TemsCourseModel)JsonUtil.getJsonToBean((Object)tems_courseEntity, TemsCourseModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid TemsCourseStudyUpForm temsCourseStudyUpForm) throws DataException {
        this.temsCourseStudyService.update(id, temsCourseStudyUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        TemsCourseStudyEntity entity = this.temsCourseStudyService.getInfo(id);
        if (entity != null) {
            this.temsCourseStudyService.delete(entity);
            QueryWrapper queryWrapperTemsCourseStudyChapter = new QueryWrapper();
            queryWrapperTemsCourseStudyChapter.lambda().eq(TemsCourseStudyChapterEntity::getStudyId, (Object)entity.getId());
            this.temsCourseStudyChapterService.remove((Wrapper)queryWrapperTemsCourseStudyChapter);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

