/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.course.entity.TemsSourceCatalogEntity;
import com.bringspring.course.model.source.catalog.TemsSourceCatalogCrForm;
import com.bringspring.course.model.source.catalog.TemsSourceCatalogInfoVO;
import com.bringspring.course.model.source.catalog.TemsSourceCatalogListVO;
import com.bringspring.course.model.source.catalog.TemsSourceCatalogPagination;
import com.bringspring.course.model.source.catalog.TemsSourceCatalogSelector;
import com.bringspring.course.model.source.catalog.TemsSourceCatalogTreeModel;
import com.bringspring.course.model.source.catalog.TemsSourceCatalogUpForm;
import com.bringspring.course.service.TemsSourceCatalogService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7d20\u6750\u76ee\u5f55"}, value="course")
@RequestMapping(value={"/api/course/TemsSourceCatalog"})
public class TemsSourceCatalogController {
    private static final Logger log = LoggerFactory.getLogger(TemsSourceCatalogController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private TemsSourceCatalogService temsSourceCatalogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody TemsSourceCatalogPagination temsSourceCatalogPagination) throws IOException {
        List<TemsSourceCatalogEntity> list = this.temsSourceCatalogService.getList(temsSourceCatalogPagination);
        List listVO = JsonUtil.getJsonToList(list, TemsSourceCatalogListVO.class);
        for (TemsSourceCatalogListVO temsCourseCatalogVO : listVO) {
            temsCourseCatalogVO.setCreatorUserId(this.baseDataUtil.userSelectValue(temsCourseCatalogVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)temsSourceCatalogPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid TemsSourceCatalogCrForm temsSourceCatalogCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        TemsSourceCatalogEntity entity = (TemsSourceCatalogEntity)JsonUtil.getJsonToBean((Object)temsSourceCatalogCrForm, TemsSourceCatalogEntity.class);
        entity.setId(mainId);
        this.temsSourceCatalogService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid TemsSourceCatalogUpForm temsSourceCatalogUpForm) throws DataException {
        TemsSourceCatalogEntity entity = this.temsSourceCatalogService.getInfo(id);
        if (entity != null) {
            TemsSourceCatalogEntity subentity = (TemsSourceCatalogEntity)JsonUtil.getJsonToBean((Object)temsSourceCatalogUpForm, TemsSourceCatalogEntity.class);
            this.temsSourceCatalogService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<TemsSourceCatalogInfoVO> info(@PathVariable(value="id") String id) {
        TemsSourceCatalogEntity entity = this.temsSourceCatalogService.getInfo(id);
        TemsSourceCatalogInfoVO vo = (TemsSourceCatalogInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsSourceCatalogInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<TemsSourceCatalogInfoVO> detailInfo(@PathVariable(value="id") String id) {
        TemsSourceCatalogEntity entity = this.temsSourceCatalogService.getInfo(id);
        TemsSourceCatalogInfoVO vo = (TemsSourceCatalogInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsSourceCatalogInfoVO.class);
        vo.setParentId(this.baseDataUtil.getDictName(vo.getParentId(), "3e2d33e54d554b4b8a33fc41b93f8a2d"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        TemsSourceCatalogEntity entity = this.temsSourceCatalogService.getInfo(id);
        if (entity != null) {
            this.temsSourceCatalogService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7c7b\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<TemsSourceCatalogSelector>> getSelector(TemsSourceCatalogPagination query) {
        List<TemsSourceCatalogEntity> data = this.temsSourceCatalogService.getList(query);
        String keyword = query.getKeyword();
        if (!StringUtils.isEmpty((String)keyword)) {
            data = data.stream().filter(t -> t.getName().contains(keyword)).collect(Collectors.toList());
        }
        List models = JsonUtil.getJsonToList(data, TemsSourceCatalogTreeModel.class);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, TemsSourceCatalogSelector.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }
}

