/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.course.entity.TemsSourceCatalogEntity;
import com.bringspring.course.entity.TemsSourceEntity;
import com.bringspring.course.model.source.manager.TemsSourceCrBatchForm;
import com.bringspring.course.model.source.manager.TemsSourceInfoVO;
import com.bringspring.course.model.source.manager.TemsSourceListVO;
import com.bringspring.course.model.source.manager.TemsSourcePagination;
import com.bringspring.course.model.source.manager.TemsSourceUpForm;
import com.bringspring.course.service.TemsSourceCatalogService;
import com.bringspring.course.service.TemsSourceService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7d20\u6750\u8bfe\u4ef6"}, value="course")
@RequestMapping(value={"/api/course/TemsSource"})
public class TemsSourceController {
    private static final Logger log = LoggerFactory.getLogger(TemsSourceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private TemsSourceService temsSourceService;
    @Autowired
    private TemsSourceCatalogService temsSourceCatalogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody TemsSourcePagination temsSourcePagination) throws IOException {
        List<TemsSourceEntity> list = this.temsSourceService.getList(temsSourcePagination);
        List catalogList = this.temsSourceCatalogService.list();
        List listVO = JsonUtil.getJsonToList(list, TemsSourceListVO.class);
        for (TemsSourceListVO temsSourceListVO : listVO) {
            if (StringUtils.isNotEmpty((String)temsSourceListVO.getCatalogId()) && !temsSourceListVO.getCatalogId().equals("-1")) {
                TemsSourceCatalogEntity temsSourceCatalogEntity = catalogList.stream().filter(catalog -> catalog.getId().equals(temsSourceListVO.getCatalogId())).findFirst().get();
                temsSourceListVO.setCatalogId(temsSourceCatalogEntity.getName());
            } else {
                temsSourceListVO.setCatalogId("");
            }
            temsSourceListVO.setCreatorUserId(this.baseDataUtil.userSelectValue(temsSourceListVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)temsSourcePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid TemsSourceCrBatchForm sourceCrBatchForm) throws DataException {
        this.temsSourceService.saveBatchResource(sourceCrBatchForm.getSourceList());
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<TemsSourceInfoVO> info(@PathVariable(value="id") String id) {
        TemsSourceEntity entity = this.temsSourceService.getInfo(id);
        TemsSourceInfoVO vo = (TemsSourceInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsSourceInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<TemsSourceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        TemsSourceEntity entity = this.temsSourceService.getInfo(id);
        TemsSourceInfoVO vo = (TemsSourceInfoVO)JsonUtil.getJsonToBean((Object)entity, TemsSourceInfoVO.class);
        vo.setCatalogId(this.baseDataUtil.getDictName(vo.getCatalogId(), "559344335821209861"));
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "559344335821209861"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid TemsSourceUpForm temsSourceUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        TemsSourceEntity entity = this.temsSourceService.getInfo(id);
        if (entity != null) {
            TemsSourceEntity subentity = (TemsSourceEntity)JsonUtil.getJsonToBean((Object)temsSourceUpForm, TemsSourceEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.temsSourceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        TemsSourceEntity entity = this.temsSourceService.getInfo(id);
        if (entity != null) {
            this.temsSourceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

