/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.UserProvider;
import com.bringspring.course.entity.TemsCourseChapterEntity;
import com.bringspring.course.entity.TemsCourseEntity;
import com.bringspring.course.entity.TemsCourseStudyEntity;
import com.bringspring.course.exception.CourseException;
import com.bringspring.course.mapper.TemsCourseMapper;
import com.bringspring.course.model.course.manager.TemsCourseInfoVO;
import com.bringspring.course.model.course.manager.TemsCoursePagination;
import com.bringspring.course.service.TemsCourseChapterService;
import com.bringspring.course.service.TemsCourseService;
import com.bringspring.course.service.TemsCourseStudyChapterService;
import com.bringspring.course.service.TemsCourseStudyService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemsCourseServiceImpl
extends ServiceImpl<TemsCourseMapper, TemsCourseEntity>
implements TemsCourseService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private TemsCourseChapterService temsCourseChapterService;
    @Autowired
    private TemsCourseStudyService temsCourseStudyService;
    @Autowired
    private TemsCourseStudyChapterService temsCourseStudyChapterService;

    @Override
    public List<TemsCourseEntity> getList(TemsCoursePagination temsCoursePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int temsCourseNum = 0;
        QueryWrapper temsCourseQueryWrapper = new QueryWrapper();
        temsCourseQueryWrapper.lambda().select(new SFunction[]{TemsCourseEntity::getId, TemsCourseEntity::getCover, TemsCourseEntity::getCategory, TemsCourseEntity::getName, TemsCourseEntity::getScope, TemsCourseEntity::getEnabledMark, TemsCourseEntity::getCreatorUserId, TemsCourseEntity::getCreatorTime});
        boolean temsCourseChapterNum = false;
        QueryWrapper temsCourseChapterQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getCategory())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getCategory, (Object)temsCoursePagination.getCategory());
        }
        if (temsCoursePagination.isMyCreated()) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getCreatorUserId, (Object)userId);
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getScope())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getScope, (Object)temsCoursePagination.getScope());
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getEnabledMark())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getEnabledMark, (Object)temsCoursePagination.getEnabledMark());
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getName())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().like(TemsCourseEntity::getName, (Object)temsCoursePagination.getName());
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getLabel())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().like(TemsCourseEntity::getLabel, (Object)temsCoursePagination.getLabel());
        }
        if (AllIdList.size() > 0) {
            temsCourseQueryWrapper.lambda().in(TemsCourseEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)temsCoursePagination.getSidx())) {
            temsCourseQueryWrapper.lambda().orderByDesc(TemsCourseEntity::getId);
        } else {
            try {
                String sidx = temsCoursePagination.getSidx();
                TemsCourseEntity temsCourseEntity = new TemsCourseEntity();
                Field declaredField = temsCourseEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                temsCourseQueryWrapper = "asc".equals(temsCoursePagination.getSort().toLowerCase()) ? (QueryWrapper)temsCourseQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)temsCourseQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(temsCoursePagination.getCurrentPage(), temsCoursePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)temsCourseQueryWrapper);
            return temsCoursePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return temsCoursePagination.setData(list, list.size());
    }

    @Override
    public List<TemsCourseEntity> getTypeList(TemsCoursePagination temsCoursePagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int temsCourseNum = 0;
        QueryWrapper temsCourseQueryWrapper = new QueryWrapper();
        boolean temsCourseChapterNum = false;
        QueryWrapper temsCourseChapterQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getCategory())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getCategory, (Object)temsCoursePagination.getCategory());
        }
        if (temsCoursePagination.isMyCreated()) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getCreatorUserId, (Object)userId);
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getScope())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getScope, (Object)temsCoursePagination.getScope());
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getEnabledMark())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().eq(TemsCourseEntity::getEnabledMark, (Object)temsCoursePagination.getEnabledMark());
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getName())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().like(TemsCourseEntity::getName, (Object)temsCoursePagination.getName());
        }
        if (StringUtil.isNotEmpty((String)temsCoursePagination.getLabel())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().like(TemsCourseEntity::getLabel, (Object)temsCoursePagination.getLabel());
        }
        if (AllIdList.size() > 0) {
            temsCourseQueryWrapper.lambda().in(TemsCourseEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)temsCoursePagination.getSidx())) {
            temsCourseQueryWrapper.lambda().orderByDesc(TemsCourseEntity::getId);
        } else {
            try {
                String sidx = temsCoursePagination.getSidx();
                TemsCourseEntity temsCourseEntity = new TemsCourseEntity();
                Field declaredField = temsCourseEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                temsCourseQueryWrapper = "asc".equals(temsCoursePagination.getSort().toLowerCase()) ? (QueryWrapper)temsCourseQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)temsCourseQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(temsCoursePagination.getCurrentPage(), temsCoursePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)temsCourseQueryWrapper);
                return temsCoursePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return temsCoursePagination.setData(list, list.size());
        }
        return this.list((Wrapper)temsCourseQueryWrapper);
    }

    @Override
    public TemsCourseEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TemsCourseEntity::getId, (Object)id);
        return (TemsCourseEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(TemsCourseEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, TemsCourseEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(TemsCourseEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<TemsCourseChapterEntity> getTemsCourseChapterList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TemsCourseChapterEntity::getCourseId, (Object)id);
        return this.temsCourseChapterService.list((Wrapper)queryWrapper);
    }

    @Override
    public TemsCourseInfoVO study(String chapterId, int process) {
        TemsCourseChapterEntity courseChapterEntity = (TemsCourseChapterEntity)this.temsCourseChapterService.getById((Serializable)((Object)chapterId));
        TemsCourseEntity courseEntity = this.getInfo(courseChapterEntity.getCourseId());
        TemsCourseInfoVO study = this.temsCourseStudyService.study(courseEntity, courseChapterEntity, process);
        return study;
    }

    @Override
    public void star(String studyId, Integer starScore) throws CourseException {
        TemsCourseStudyEntity courseStudyEntity = this.temsCourseStudyService.getInfo(studyId);
        if (ObjectUtil.isEmpty((Object)courseStudyEntity)) {
            throw new CourseException("\u6ca1\u6709\u627e\u5230\u8bfe\u7a0b\u5b66\u4e60\u8bb0\u5f55");
        }
        courseStudyEntity.setMyStar(starScore);
        courseStudyEntity.setIsCompletedStar(1);
        this.temsCourseStudyService.updateById(courseStudyEntity);
        TemsCourseEntity courseEntity = this.getInfo(courseStudyEntity.getCourseId());
        courseEntity.setStarUsers(courseEntity.getStarUsers() + 1);
        List<TemsCourseStudyEntity> courseList = this.temsCourseStudyService.getCourseStudyListByCourseId(courseEntity.getId());
        double v = courseList.stream().mapToInt(course -> course.getMyStar()).average().orElse(0.0);
        courseEntity.setStarScore(v);
    }

    public static void main(String[] args) {
        TemsCourseStudyEntity courseStudyEntity = new TemsCourseStudyEntity();
        System.out.println(courseStudyEntity.toString());
    }
}

