/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.course.entity.TemsCourseChapterEntity;
import com.bringspring.course.entity.TemsCourseEntity;
import com.bringspring.course.entity.TemsCourseStudyChapterEntity;
import com.bringspring.course.entity.TemsCourseStudyEntity;
import com.bringspring.course.mapper.TemsCourseStudyMapper;
import com.bringspring.course.model.course.chapter.TemsCourseChapterModel;
import com.bringspring.course.model.course.manager.TemsCourseInfoVO;
import com.bringspring.course.model.study.TemsCourseStudyCrForm;
import com.bringspring.course.model.study.TemsCourseStudyInfoVO;
import com.bringspring.course.model.study.TemsCourseStudyPagination;
import com.bringspring.course.model.study.TemsCourseStudyUpForm;
import com.bringspring.course.service.TemsCourseChapterService;
import com.bringspring.course.service.TemsCourseService;
import com.bringspring.course.service.TemsCourseStudyChapterService;
import com.bringspring.course.service.TemsCourseStudyService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemsCourseStudyServiceImpl
extends ServiceImpl<TemsCourseStudyMapper, TemsCourseStudyEntity>
implements TemsCourseStudyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private TemsCourseService temsCourseService;
    @Autowired
    private TemsCourseChapterService temsCourseChapterService;
    @Autowired
    private TemsCourseStudyChapterService temsCourseStudyChapterService;

    @Override
    public List<TemsCourseStudyEntity> getList(TemsCourseStudyPagination temsCourseStudyPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int temsCourseStudyNum = 0;
        QueryWrapper temsCourseStudyQueryWrapper = new QueryWrapper();
        temsCourseStudyQueryWrapper.lambda().select(new SFunction[]{TemsCourseStudyEntity::getId, TemsCourseStudyEntity::getCourseId, TemsCourseStudyEntity::getChapterProgress, TemsCourseStudyEntity::getIsHaveHomework, TemsCourseStudyEntity::getIsCompletedHomework, TemsCourseStudyEntity::getIsHaveExam, TemsCourseStudyEntity::getIsCompletedExam, TemsCourseStudyEntity::getIsHaveQuestionnaire, TemsCourseStudyEntity::getIsCompletedQuestionnaire, TemsCourseStudyEntity::getIsHaveStar, TemsCourseStudyEntity::getIsCompletedStar, TemsCourseStudyEntity::getLastModifyTime, TemsCourseStudyEntity::getEnabledMark});
        boolean temsCourseStudyChapterNum = false;
        QueryWrapper temsCourseStudyChapterQueryWrapper = new QueryWrapper();
        int temsCourseNum = 0;
        QueryWrapper temsCourseQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)temsCourseStudyPagination.getJsbos_tems_course_jsbos_name())) {
            ++temsCourseNum;
            temsCourseQueryWrapper.lambda().like(TemsCourseEntity::getName, (Object)temsCourseStudyPagination.getJsbos_tems_course_jsbos_name());
        }
        if (temsCourseNum > 0) {
            List tems_courseIdList = this.temsCourseService.list((Wrapper)temsCourseQueryWrapper).stream().filter(t -> StringUtils.isNotEmpty((String)t.getId())).map(t -> t.getId()).collect(Collectors.toList());
            AllIdList.addAll(tems_courseIdList);
        }
        total += temsCourseNum;
        if (StringUtils.isNotEmpty((String)temsCourseStudyPagination.getEnabledMark())) {
            ++temsCourseStudyNum;
            temsCourseStudyQueryWrapper.lambda().eq(TemsCourseStudyEntity::getEnabledMark, (Object)temsCourseStudyPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            temsCourseStudyQueryWrapper.lambda().in(TemsCourseStudyEntity::getCourseId, AllIdList);
        }
        if (StringUtils.isEmpty((String)temsCourseStudyPagination.getSidx())) {
            temsCourseStudyQueryWrapper.lambda().orderByDesc(TemsCourseStudyEntity::getId);
        } else {
            try {
                String sidx = temsCourseStudyPagination.getSidx();
                TemsCourseStudyEntity temsCourseStudyEntity = new TemsCourseStudyEntity();
                Field declaredField = temsCourseStudyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                temsCourseStudyQueryWrapper = "asc".equals(temsCourseStudyPagination.getSort().toLowerCase()) ? (QueryWrapper)temsCourseStudyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)temsCourseStudyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(temsCourseStudyPagination.getCurrentPage(), temsCourseStudyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)temsCourseStudyQueryWrapper);
            return temsCourseStudyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return temsCourseStudyPagination.setData(list, list.size());
    }

    @Override
    public TemsCourseStudyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TemsCourseStudyEntity::getId, (Object)id);
        return (TemsCourseStudyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public TemsCourseStudyEntity getInfoByCourseId(String courseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(TemsCourseStudyEntity::getCourseId, (Object)courseId)).eq(TemsCourseStudyEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
        return (TemsCourseStudyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(TemsCourseStudyCrForm temsCourseStudyCrForm) {
        String mainId = RandomUtil.uuId();
        TemsCourseStudyEntity entity = (TemsCourseStudyEntity)JsonUtil.getJsonToBean((Object)temsCourseStudyCrForm, TemsCourseStudyEntity.class);
        entity.setId(mainId);
        this.save(entity);
        List TemsCourseStudyChapterList = JsonUtil.getJsonToList(temsCourseStudyCrForm.getTemscoursestudychapterList(), TemsCourseStudyChapterEntity.class);
        for (TemsCourseStudyChapterEntity entitys : TemsCourseStudyChapterList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setStudyId(entity.getId());
            this.temsCourseStudyChapterService.save(entitys);
        }
        if (ObjectUtil.isNotEmpty((Object)temsCourseStudyCrForm.getTems_course())) {
            TemsCourseEntity tems_courseentity = (TemsCourseEntity)JsonUtil.getJsonToBean((Object)temsCourseStudyCrForm.getTems_course(), TemsCourseEntity.class);
            tems_courseentity.setId(entity.getCourseId());
            tems_courseentity.setId(mainId);
            this.temsCourseService.save(tems_courseentity);
        }
    }

    @Override
    public void update(String id, TemsCourseStudyUpForm temsCourseStudyUpForm) {
        UserInfo userInfo = this.userProvider.get();
        TemsCourseStudyEntity entity = this.getInfo(id);
        if (entity != null) {
            QueryWrapper TemsCourseStudyChapterqueryWrapper = new QueryWrapper();
            TemsCourseStudyChapterqueryWrapper.lambda().eq(TemsCourseStudyChapterEntity::getStudyId, (Object)entity.getId());
            this.temsCourseStudyChapterService.remove((Wrapper)TemsCourseStudyChapterqueryWrapper);
            List TemsCourseStudyChapterList = JsonUtil.getJsonToList(temsCourseStudyUpForm.getTemscoursestudychapterList(), TemsCourseStudyChapterEntity.class);
            for (TemsCourseStudyChapterEntity entitys : TemsCourseStudyChapterList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setStudyId(entity.getId());
                this.temsCourseStudyChapterService.save(entitys);
            }
            if (ObjectUtil.isNotEmpty((Object)temsCourseStudyUpForm.getTems_course())) {
                QueryWrapper queryWrapperTemsCourse = new QueryWrapper();
                queryWrapperTemsCourse.lambda().eq(TemsCourseEntity::getId, (Object)entity.getCourseId());
                TemsCourseEntity tems_courseOneEntity = (TemsCourseEntity)this.temsCourseService.getOne((Wrapper)queryWrapperTemsCourse);
                TemsCourseEntity tems_courseentity = (TemsCourseEntity)JsonUtil.getJsonToBean((Object)temsCourseStudyUpForm.getTems_course(), TemsCourseEntity.class);
                tems_courseentity.setId(tems_courseOneEntity.getId());
                tems_courseentity.setId(entity.getCourseId());
                this.temsCourseService.updateById(tems_courseentity);
            }
            this.updateById(entity);
        }
    }

    @Override
    public void delete(TemsCourseStudyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<TemsCourseStudyChapterEntity> getTemsCourseStudyChapterList(String courseStudyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TemsCourseStudyChapterEntity::getStudyId, (Object)courseStudyId);
        return this.temsCourseStudyChapterService.list((Wrapper)queryWrapper);
    }

    @Override
    public TemsCourseEntity getTemsCourse(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TemsCourseEntity::getId, (Object)id);
        return (TemsCourseEntity)this.temsCourseService.getOne((Wrapper)queryWrapper);
    }

    @Override
    public TemsCourseInfoVO study(TemsCourseEntity courseEntity, TemsCourseChapterEntity courseChapterEntity, int process) {
        TemsCourseStudyEntity courseStudy = this.getInfoByCourseId(courseEntity.getId());
        if (ObjectUtil.isEmpty((Object)courseStudy)) {
            courseStudy = new TemsCourseStudyEntity();
            courseStudy.setId(RandomUtil.uuId());
            courseStudy.setCourseId(courseEntity.getId());
            if (StringUtils.isNotEmpty((String)courseEntity.getHomework())) {
                courseStudy.setIsHaveHomework(1);
            }
            if (StringUtils.isNotEmpty((String)courseEntity.getHomeExam())) {
                courseStudy.setIsHaveExam(1);
            }
            if (StringUtils.isNotEmpty((String)courseEntity.getEvaluation())) {
                courseStudy.setIsHaveStar(1);
            }
            this.saveOrUpdate(courseStudy);
            courseEntity.setLearnUsers(courseEntity.getLearnUsers() + 1);
            List<TemsCourseChapterEntity> temsCourseChapterList = this.temsCourseService.getTemsCourseChapterList(courseEntity.getId());
            for (TemsCourseChapterEntity temsCourseChapterEntity : temsCourseChapterList) {
                TemsCourseStudyChapterEntity studyChapterEntity = new TemsCourseStudyChapterEntity();
                studyChapterEntity.setStudyId(courseStudy.getId());
                studyChapterEntity.setChapterId(temsCourseChapterEntity.getId());
                if (!(!StringUtils.isNotEmpty((String)courseChapterEntity.getType()) || courseChapterEntity.getType().equals("\u89c6\u9891") && courseChapterEntity.getType().equals("\u97f3\u9891") || courseEntity.getDocsLearning() != 0)) {
                    studyChapterEntity.setProcess(100);
                    studyChapterEntity.setEnabledMark(1);
                }
                this.temsCourseStudyChapterService.save(studyChapterEntity);
            }
        }
        courseEntity.setLearnCount(courseEntity.getLearnCount() + 1);
        this.temsCourseService.updateById(courseEntity);
        TemsCourseStudyChapterEntity studyChapterEntity = this.temsCourseStudyChapterService.getInfoByChapterId(courseChapterEntity.getId());
        if (ObjectUtil.isEmpty((Object)studyChapterEntity)) {
            studyChapterEntity = new TemsCourseStudyChapterEntity();
            studyChapterEntity.setStudyId(courseStudy.getId());
            studyChapterEntity.setChapterId(courseChapterEntity.getId());
            if (!(!StringUtils.isNotEmpty((String)courseChapterEntity.getType()) || courseChapterEntity.getType().equals("\u89c6\u9891") && courseChapterEntity.getType().equals("\u97f3\u9891") || courseEntity.getDocsLearning() != 0)) {
                studyChapterEntity.setProcess(100);
                studyChapterEntity.setEnabledMark(1);
            }
            this.temsCourseStudyChapterService.save(studyChapterEntity);
        } else if (process > 0 && studyChapterEntity.getProcess() < process) {
            studyChapterEntity.setProcess(process);
            if (process > 80) {
                studyChapterEntity.setProcess(100);
                studyChapterEntity.setEnabledMark(1);
            }
            this.temsCourseStudyChapterService.updateById(studyChapterEntity);
        }
        if (courseStudy.getEnabledMark() != 1) {
            this.computerCourseStudyProcess(courseStudy);
        }
        List<TemsCourseChapterEntity> temsCourseChapterList = this.temsCourseService.getTemsCourseChapterList(courseEntity.getId());
        List temsCourseChapterModelList = JsonUtil.getJsonToList(temsCourseChapterList, TemsCourseChapterModel.class);
        TemsCourseInfoVO vo = (TemsCourseInfoVO)JsonUtil.getJsonToBean((Object)courseEntity, TemsCourseInfoVO.class);
        TemsCourseStudyInfoVO jsonToBean = (TemsCourseStudyInfoVO)JsonUtil.getJsonToBean((Object)courseStudy, TemsCourseStudyInfoVO.class);
        vo.setTemsCourseStudyInfo(jsonToBean);
        if (null != courseStudy) {
            List<TemsCourseStudyChapterEntity> temsCourseStudyChapterList = this.getTemsCourseStudyChapterList(courseStudy.getId());
            for (TemsCourseChapterModel temsCourseChapterModel : temsCourseChapterModelList) {
                for (TemsCourseStudyChapterEntity studyChapter : temsCourseStudyChapterList) {
                    if (!studyChapter.getChapterId().equals(temsCourseChapterModel.getId())) continue;
                    temsCourseChapterModel.setProcess(studyChapter.getProcess());
                    temsCourseChapterModel.setEnabledMark(studyChapter.getEnabledMark());
                }
            }
        }
        vo.setTemsCourseChapterList(temsCourseChapterModelList);
        return vo;
    }

    @Override
    public List<TemsCourseStudyEntity> getCourseStudyListByCourseId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(TemsCourseStudyEntity::getCourseId, (Object)id)).eq(TemsCourseStudyEntity::getIsHaveStar, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    private int computerChapterStudyProcess(TemsCourseStudyChapterEntity studyChapterEntity) {
        return 1;
    }

    private void computerCourseStudyProcess(TemsCourseStudyEntity courseStudy) {
        int processTemp = 100;
        if (courseStudy.getIsHaveHomework() == 1 && courseStudy.getIsCompletedHomework() == 0) {
            processTemp -= 25;
        }
        if (courseStudy.getIsHaveExam() == 1 && courseStudy.getIsCompletedExam() == 0) {
            processTemp -= 25;
        }
        if (courseStudy.getIsHaveStar() == 1 && courseStudy.getIsCompletedStar() == 0) {
            processTemp -= 10;
        } else if (courseStudy.getIsHaveQuestionnaire() == 1 && courseStudy.getIsCompletedQuestionnaire() == 0) {
            processTemp -= 10;
        }
        List<TemsCourseStudyChapterEntity> temsCourseStudyChapterList = this.getTemsCourseStudyChapterList(courseStudy.getId());
        int chapterPercentage = processTemp / temsCourseStudyChapterList.size();
        int complateCount = (int)temsCourseStudyChapterList.stream().filter(chapterStudy -> chapterStudy.getEnabledMark() == 1).count();
        int process = chapterPercentage * complateCount;
        if (process >= 100) {
            courseStudy.setProcess(100);
            courseStudy.setEnabledMark(1);
        } else {
            courseStudy.setProcess(process);
        }
        this.updateById(courseStudy);
    }
}

