/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.course.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.course.entity.TemsSourceEntity;
import com.bringspring.course.mapper.TemsSourceMapper;
import com.bringspring.course.model.source.manager.TemsSourcePagination;
import com.bringspring.course.service.TemsSourceService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemsSourceServiceImpl
extends ServiceImpl<TemsSourceMapper, TemsSourceEntity>
implements TemsSourceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<TemsSourceEntity> getList(TemsSourcePagination temsSourcePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int temsSourceNum = 0;
        QueryWrapper temsSourceQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getName())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().like(TemsSourceEntity::getName, (Object)temsSourcePagination.getName());
        }
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getCatalogId()) && !"-1".equals(temsSourcePagination.getCatalogId())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().eq(TemsSourceEntity::getCatalogId, (Object)temsSourcePagination.getCatalogId());
        }
        if (temsSourcePagination.isMyCreated()) {
            temsSourceQueryWrapper.lambda().eq(TemsSourceEntity::getCreatorUserId, (Object)userId);
        }
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getType())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().eq(TemsSourceEntity::getType, (Object)temsSourcePagination.getType());
        }
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getEnabledMark())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().eq(TemsSourceEntity::getEnabledMark, (Object)temsSourcePagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            temsSourceQueryWrapper.lambda().in(TemsSourceEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)temsSourcePagination.getSidx())) {
            temsSourceQueryWrapper.lambda().orderByDesc(TemsSourceEntity::getId);
        } else {
            try {
                String sidx = temsSourcePagination.getSidx();
                TemsSourceEntity temsSourceEntity = new TemsSourceEntity();
                Field declaredField = temsSourceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                temsSourceQueryWrapper = "asc".equals(temsSourcePagination.getSort().toLowerCase()) ? (QueryWrapper)temsSourceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)temsSourceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(temsSourcePagination.getCurrentPage(), temsSourcePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)temsSourceQueryWrapper);
            return temsSourcePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return temsSourcePagination.setData(list, list.size());
    }

    @Override
    public List<TemsSourceEntity> getTypeList(TemsSourcePagination temsSourcePagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int temsSourceNum = 0;
        QueryWrapper temsSourceQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getName())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().like(TemsSourceEntity::getName, (Object)temsSourcePagination.getName());
        }
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getCatalogId())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().eq(TemsSourceEntity::getCatalogId, (Object)temsSourcePagination.getCatalogId());
        }
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getType())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().eq(TemsSourceEntity::getType, (Object)temsSourcePagination.getType());
        }
        if (StringUtil.isNotEmpty((String)temsSourcePagination.getEnabledMark())) {
            ++temsSourceNum;
            temsSourceQueryWrapper.lambda().eq(TemsSourceEntity::getEnabledMark, (Object)temsSourcePagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            temsSourceQueryWrapper.lambda().in(TemsSourceEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)temsSourcePagination.getSidx())) {
            temsSourceQueryWrapper.lambda().orderByDesc(TemsSourceEntity::getId);
        } else {
            try {
                String sidx = temsSourcePagination.getSidx();
                TemsSourceEntity temsSourceEntity = new TemsSourceEntity();
                Field declaredField = temsSourceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                temsSourceQueryWrapper = "asc".equals(temsSourcePagination.getSort().toLowerCase()) ? (QueryWrapper)temsSourceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)temsSourceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(temsSourcePagination.getCurrentPage(), temsSourcePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)temsSourceQueryWrapper);
                return temsSourcePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return temsSourcePagination.setData(list, list.size());
        }
        return this.list((Wrapper)temsSourceQueryWrapper);
    }

    @Override
    public TemsSourceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TemsSourceEntity::getId, (Object)id);
        return (TemsSourceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(TemsSourceEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, TemsSourceEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean saveBatchResource(List<TemsSourceEntity> sourceList) {
        for (TemsSourceEntity temsSourceEntity : sourceList) {
            if (StringUtils.isNotEmpty((String)temsSourceEntity.getFileSize())) {
                temsSourceEntity.setFileSize(cn.hutool.core.io.FileUtil.readableFileSize((long)Long.parseLong(temsSourceEntity.getFileSize())));
            }
            String courseChapterType = this.getCourseChapterType(temsSourceEntity.getUrl());
            temsSourceEntity.setType(courseChapterType);
        }
        return this.saveBatch(sourceList);
    }

    public String getCourseChapterType(String url) {
        String fileType = FileUtil.getFileType((String)url).toLowerCase();
        if (fileType.equals("mp4") || fileType.equals("avi") || fileType.equals("mov") || fileType.equals("wmv") || fileType.equals("flv") || fileType.equals("rm") || fileType.equals("rmvb")) {
            return "\u89c6\u9891";
        }
        if (fileType.equals("mp3")) {
            return "\u97f3\u9891";
        }
        if (fileType.equals("png") || fileType.equals("jpg") || fileType.equals("gif")) {
            return "\u56fe\u7247";
        }
        return "\u6587\u6863";
    }

    @Override
    public void delete(TemsSourceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

