/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.mapper.VisualdevMapper;
import com.bringspring.visualdev.base.model.PaginationVisualdev;
import com.bringspring.visualdev.base.model.VisualWebTypeEnum;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.util.VisualDevTableCre;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualdevServiceImpl
extends ServiceImpl<VisualdevMapper, VisualdevEntity>
implements VisualdevService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private UserService userService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisualDevTableCre visualDevTableCre;

    @Override
    public List<VisualdevEntity> getList(PaginationVisualdev paginationVisualdev) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtil.isEmpty((String)paginationVisualdev.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(VisualdevEntity::getFullName, (Object)paginationVisualdev.getKeyword());
        }
        queryWrapper.lambda().eq(VisualdevEntity::getType, (Object)paginationVisualdev.getType());
        if (StringUtil.isNotEmpty((String)paginationVisualdev.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(VisualdevEntity::getCategory, (Object)paginationVisualdev.getCategory());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(VisualdevEntity::getSortCode)).orderByDesc(VisualdevEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(VisualdevEntity::getLastModifyTime);
        }
        Page page = new Page(paginationVisualdev.getCurrentPage(), paginationVisualdev.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationVisualdev.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<VisualdevEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(VisualdevEntity::getSortCode)).orderByDesc(VisualdevEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public VisualdevEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualdevEntity::getId, (Object)id);
        return (VisualdevEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Boolean create(VisualdevEntity entity) throws WorkFlowException {
        if (StringUtil.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        List tableModels = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        Map formMap = JsonUtil.stringToMap((String)entity.getFormData());
        if (tableModels.size() == 0) {
            List list = JsonUtil.getJsonToList(formMap.get("fields"), FieLdsModel.class);
            JSONArray formJsonArray = JsonUtil.getJsonToJsonArray((String)String.valueOf(formMap.get("fields")));
            ArrayList formAllModel = new ArrayList();
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setTableModelList(JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class));
            recursionForm.setList(list);
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            String tableName = "mt" + RandomUtil.uuId();
            String dbLinkId = entity.getDbLinkId();
            List tableModelList = this.visualDevTableCre.tableList(formJsonArray, formAllModel, tableName, dbLinkId);
            formMap.put("fields", formJsonArray);
            entity.setFormData(JsonUtil.getObjectToString((Object)formMap));
            entity.setVisualTables(JsonUtil.getObjectToString((Object)tableModelList));
        }
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setSortCode(RandomUtil.parses());
        if (ObjectUtil.isNotEmpty((Object)entity.getWebType()) && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            entity.setFlowId(entity.getId());
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                FlowEngineEntity flowEngineEntity = new FlowEngineEntity();
                flowEngineEntity.setId(entity.getId());
                flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                flowEngineEntity.setType(Integer.valueOf(1));
                flowEngineEntity.setIcon("icon-ym icon-ym-node");
                flowEngineEntity.setIconBackground("#008cff");
                flowEngineEntity.setEnabledMark(Integer.valueOf(1));
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setCategory(this.dictionaryDataService.getInfo(entity.getCategory()).getEnCode());
                flowEngineEntity.setFormType(Integer.valueOf(2));
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                this.flowEngineService.create(flowEngineEntity);
                entity.setFlowId(flowEngineEntity.getId());
            }
        }
        return this.save(entity);
    }

    @Override
    public boolean update(String id, VisualdevEntity entity) throws WorkFlowException {
        entity.setId(id);
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        if (entity.getWebType() != null && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            FlowEngineEntity flowEngineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)id));
            VisualdevEntity visualdevEntity = this.getInfo(id);
            if (visualdevEntity.getFlowId() == null) {
                entity.setFlowId(id);
            }
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                if (flowEngineEntity == null) {
                    flowEngineEntity = new FlowEngineEntity();
                    flowEngineEntity.setId(id);
                    flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                    flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                    flowEngineEntity.setType(Integer.valueOf(1));
                    flowEngineEntity.setIcon("icon-ym icon-ym-node");
                    flowEngineEntity.setIconBackground("#008cff");
                    flowEngineEntity.setEnabledMark(Integer.valueOf(1));
                    flowEngineEntity.setFormType(Integer.valueOf(2));
                    flowEngineEntity.setFlowTables(entity.getVisualTables());
                    flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                    flowEngineEntity.setFormData(entity.getFormData());
                    flowEngineEntity.setFullName(entity.getFullName());
                    this.flowEngineService.create(flowEngineEntity);
                }
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                this.flowEngineService.update(visualdevEntity.getId(), flowEngineEntity);
            }
        }
        return this.updateById(entity);
    }

    @Override
    public void delete(VisualdevEntity entity) throws WorkFlowException {
        if (entity != null) {
            FlowEngineEntity flowEngineEntity;
            if (StringUtil.isNotEmpty((String)entity.getFlowId()) && (flowEngineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)entity.getFlowId()))) != null) {
                this.flowEngineService.delete(flowEngineEntity);
            }
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public Long getObjByEncode(String encode, Integer type) {
        QueryWrapper visualWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)visualWrapper.lambda().eq(VisualdevEntity::getEnCode, (Object)encode)).eq(VisualdevEntity::getType, (Object)type);
        Long count = ((VisualdevMapper)this.baseMapper).selectCount((Wrapper)visualWrapper);
        return count;
    }

    @Override
    public Long getCountByName(String name, Integer type) {
        QueryWrapper visualWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)visualWrapper.lambda().eq(VisualdevEntity::getFullName, (Object)name)).eq(VisualdevEntity::getType, (Object)type);
        Long count = ((VisualdevMapper)this.baseMapper).selectCount((Wrapper)visualWrapper);
        return count;
    }
}

