/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.generater.util.workFlow;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormColumnModel;
import com.bringspring.common.model.FormColumnTableModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.FormMastTableModel;
import com.bringspring.common.model.visiual.DownloadCodeForm;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.config.ConfigModel;
import com.bringspring.common.model.visiual.fields.props.PropsBeanModel;
import com.bringspring.common.model.visiual.fields.props.PropsModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.system.base.util.SourceUtil;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.model.template7.Template7Model;
import com.bringspring.visualdev.base.util.VisualUtils;
import com.bringspring.visualdev.generater.util.common.DataControlUtils;
import com.bringspring.visualdev.generater.util.custom.CustomGenerator;
import com.bringspring.visualdev.generater.util.workFlow.WorkGenModel;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class WorkGenUtil {
    public void htmlTemplates(WorkGenModel workGenModel) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        VisualdevEntity entity = workGenModel.getEntity();
        ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
        Map<String, String> tableNameAll = this.forDataMode(workGenModel, formAllModel);
        FormDataModel model = workGenModel.getModel();
        String className = NamingStrategy.capitalFirst((String)NamingStrategy.underlineToCamel((String)model.getClassName()));
        Template7Model templateModel = this.templateModel(workGenModel, className);
        List<FormAllModel> mast = this.mast(formAllModel);
        ArrayList<Map<String, Object>> child = new ArrayList<Map<String, Object>>();
        this.childModel(formAllModel, child, tableNameAll);
        Map<String, List<FormAllModel>> mastListAll = this.mastTableModel(formAllModel, map, tableNameAll);
        map.put("children", child);
        map.put("fields", mast);
        map.put("genInfo", templateModel);
        map.put("modelName", model.getClassName());
        map.put("package", "jsbos");
        map.put("isModel", "true");
        String modelPathName = model.getClassName().substring(0, 1).toLowerCase() + model.getClassName().substring(1);
        map.put("modelPathName", modelPathName);
        map.put("flowEnCode", entity.getEnCode());
        map.put("flowId", entity.getId());
        this.formData(map, workGenModel, formAllModel, tableNameAll);
        List<String> getTemplate = this.getTemplate(workGenModel, false);
        String path = templateModel.getServiceDirectory() + workGenModel.getFileName();
        this.htmlTemplates(map, getTemplate, path, templateModel.getClassName(), modelPathName);
        for (Map map2 : child) {
            map2.put("genInfo", templateModel);
            map2.put("package", "jsbos");
            getTemplate = this.getTemplate(workGenModel, true);
            String childName = map2.get("className").toString();
            map2.put("className", childName);
            this.htmlTemplates(map2, getTemplate, path, childName, modelPathName);
        }
        for (String string : mastListAll.keySet()) {
            List mastlist = mastListAll.get(string).stream().map(t -> t.getFormMastTableModel()).collect(Collectors.toList());
            LinkedList<FormColumnModel> childList = new LinkedList<FormColumnModel>();
            for (FormMastTableModel columnModel : mastlist) {
                String field = columnModel.getField();
                if (!StringUtil.isNotEmpty((String)field)) continue;
                FormColumnModel columnTable = columnModel.getMastTable();
                FieLdsModel fieLdsModel = columnTable.getFieLdsModel();
                fieLdsModel.setVModel(field);
                columnTable.setFieLdsModel(fieLdsModel);
                childList.add(columnTable);
            }
            getTemplate = this.getTemplate(workGenModel, true);
            FormColumnTableModel mastTableModel = new FormColumnTableModel();
            mastTableModel.setChildList(childList);
            String name = tableNameAll.get(string);
            String childName = name.substring(0, 1).toUpperCase() + name.substring(1);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("children", mastTableModel);
            objectMap.put("genInfo", templateModel);
            objectMap.put("package", "jsbos");
            objectMap.put("className", childName);
            this.htmlTemplates(objectMap, getTemplate, path, childName, modelPathName);
        }
    }

    private void formData(Map<String, Object> map, WorkGenModel workGenModel, List<FormAllModel> formAllModel, Map<String, String> tableNameAll) {
        FormDataModel model = workGenModel.getModel();
        DownloadCodeForm codeForm = workGenModel.getDownloadCodeForm();
        map.put("module", codeForm.getModule());
        String className = NamingStrategy.capitalFirst((String)NamingStrategy.underlineToCamel((String)model.getClassName()));
        map.put("className", className);
        map.put("formRef", model.getFormRef());
        map.put("formModel", model.getFormModel());
        map.put("size", model.getSize());
        map.put("labelPosition", model.getLabelPosition());
        map.put("labelWidth", model.getLabelWidth());
        map.put("formRules", model.getFormRules());
        map.put("gutter", model.getGutter());
        map.put("disabled", model.getDisabled());
        map.put("span", model.getSpan());
        map.put("formBtns", model.getFormBtns());
        map.put("idGlobal", model.getIdGlobal());
        map.put("popupType", model.getPopupType());
        map.put("form", formAllModel);
        String pKeyName = workGenModel.getPKeyName();
        pKeyName = pKeyName.toLowerCase().trim().replaceAll("f_", "");
        map.put("pKeyName", pKeyName);
    }

    private List<String> getTemplate(WorkGenModel workGenModel, boolean isChild) {
        String template = workGenModel.getTemplatePath();
        ArrayList<String> templates = new ArrayList<String>();
        if (isChild) {
            templates.add(template + File.separator + "java" + File.separator + "Model.java.vm");
        } else {
            templates.add(template + File.separator + "java" + File.separator + "Form.java.vm");
            templates.add(template + File.separator + "html" + File.separator + "form.vue.vm");
            templates.add(template + File.separator + "html" + File.separator + "app.vue.vm");
            templates.add(template + File.separator + "java" + File.separator + "InfoVO.java.vm");
        }
        return templates;
    }

    private String getFileNames(String path, String template, String className, String modePath) {
        File modelfile;
        String appHtmlPath;
        File appHtmlfile;
        String pcHtmlPath;
        File pcHtmlfile;
        path = XSSEscape.escapePath((String)path);
        modePath = XSSEscape.escapePath((String)modePath);
        className = XSSEscape.escapePath((String)className);
        String modelPath = path + File.separator + "java" + File.separator + "model";
        if (StringUtil.isNotEmpty((String)modePath)) {
            modelPath = modelPath + File.separator + modePath;
        }
        if (!(pcHtmlfile = new File(pcHtmlPath = path + File.separator + "html" + File.separator + "web")).exists()) {
            pcHtmlfile.mkdirs();
        }
        if (!(appHtmlfile = new File(appHtmlPath = path + File.separator + "html" + File.separator + "app")).exists()) {
            appHtmlfile.mkdirs();
        }
        if (!(modelfile = new File(modelPath)).exists()) {
            modelfile.mkdirs();
        }
        if (template.contains("form.vue.vm")) {
            className = "index";
            return pcHtmlfile + File.separator + className + ".vue";
        }
        if (template.contains("app.vue.vm")) {
            className = "index";
            return appHtmlfile + File.separator + className + ".vue";
        }
        if (template.contains("Form.java.vm")) {
            return modelPath + File.separator + className + "Form.java";
        }
        if (template.contains("InfoVO.java.vm")) {
            return modelPath + File.separator + className + "InfoVO.java";
        }
        if (template.contains("Model.java.vm")) {
            return modelPath + File.separator + className + "Model.java";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void htmlTemplates(Object object, List<String> templates, String path, String className, String modePath) {
        VelocityContext context = new VelocityContext();
        context.put("context", object);
        for (String template : templates) {
            try {
                StringWriter sw = new StringWriter();
                try {
                    Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
                    tpl.merge((Context)context, (Writer)sw);
                    String fileNames = this.getFileNames(path, template, className, modePath);
                    if (fileNames == null) continue;
                    File file = new File(XSSEscape.escapePath((String)fileNames));
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        IOUtils.write((String)sw.toString(), (OutputStream)fos, (String)"UTF-8");
                        IOUtils.closeQuietly((Writer)sw);
                        IOUtils.closeQuietly((OutputStream)fos);
                    }
                    finally {
                        if (Collections.singletonList(fos).get(0) == null) continue;
                        fos.close();
                    }
                }
                finally {
                    if (Collections.singletonList(sw).get(0) == null) continue;
                    sw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<FormAllModel> mast(List<FormAllModel> formAllModel) {
        List<FormAllModel> mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        for (int i = 0; i < mast.size(); ++i) {
            FieLdsModel fieLdsModel = mast.get(i).getFormColumnModel().getFieLdsModel();
            this.model(fieLdsModel);
            String vmodel = fieLdsModel.getVModel();
            if (!StringUtil.isEmpty((String)vmodel)) continue;
            mast.remove(i);
        }
        return mast;
    }

    private Map<String, List<FormAllModel>> mastTableModel(List<FormAllModel> formAllModel, Map<String, Object> map, Map<String, String> tableNameAll) {
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        Map<String, List<FormAllModel>> mastListAll = mastTable.stream().collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
        HashMap<String, String> mastTableNameAll = new HashMap<String, String>();
        HashMap<String, List<FormAllModel>> mastTableList = new HashMap<String, List<FormAllModel>>();
        for (String mastkey : mastListAll.keySet()) {
            List<FormAllModel> mastList = mastListAll.get(mastkey);
            for (FormAllModel fieLdsList : mastList) {
                FieLdsModel fieLdsModel = fieLdsList.getFormMastTableModel().getMastTable().getFieLdsModel();
                this.model(fieLdsModel);
            }
            mastListAll.put(mastkey, mastList);
            String tableName = tableNameAll.get(mastkey);
            String name = tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
            mastTableNameAll.put(mastkey, name);
            mastTableList.put(tableName.toLowerCase(), mastList);
        }
        map.put("mastTableName", mastTableNameAll);
        map.put("tableName", tableNameAll);
        map.put("mastTable", mastTableList);
        return mastListAll;
    }

    private void childModel(List<FormAllModel> formAllModel, List<Map<String, Object>> child, Map<String, String> tableNameAll) {
        List table = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        for (FormAllModel formModel : table) {
            FormColumnTableModel childList = formModel.getChildList();
            String tableName = childList.getTableName();
            List tableList = childList.getChildList();
            for (int i = 0; i < tableList.size(); ++i) {
                FormColumnModel columnModel = (FormColumnModel)tableList.get(i);
                FieLdsModel fieLdsModel = columnModel.getFieLdsModel();
                this.model(fieLdsModel);
            }
            childList.setChildList(tableList);
            String name = tableNameAll.get(tableName);
            Map childs = JsonUtil.entityToMap((Object)childList);
            String className = name.substring(0, 1).toUpperCase() + name.substring(1);
            childs.put("className", className);
            childs.put("children", childList);
            child.add(childs);
        }
    }

    private void model(FieLdsModel fieLdsModel) {
        ConfigModel configModel = fieLdsModel.getConfig();
        String keyName = configModel.getKeyName();
        if (configModel.getDefaultValue() instanceof String) {
            configModel.setValueType("String");
        }
        if (configModel.getDefaultValue() == null) {
            configModel.setValueType("undefined");
            if ("numInput".equals(keyName)) {
                configModel.setDefaultValue((Object)(ObjectUtil.isNotEmpty((Object)fieLdsModel.getMin()) ? fieLdsModel.getMin() : 0));
                configModel.setValueType(null);
            }
        }
        if ("switch".equals(keyName) && configModel.getDefaultValue() instanceof Boolean) {
            Boolean defaultValue = (Boolean)configModel.getDefaultValue();
            configModel.setDefaultValue((Object)(defaultValue != false ? 1 : 0));
        }
        fieLdsModel.setConfig(configModel);
    }

    private Map<String, String> tableName(List<TableModel> tableModelList, DownloadCodeForm downloadCodeForm) {
        HashMap<String, String> tableClass = new HashMap<String, String>(16);
        int i = 0;
        for (TableModel tableModel : tableModelList) {
            if (!"0".equals(tableModel.getTypeId())) continue;
            String[] subClassName = downloadCodeForm.getSubClassName().split(",");
            tableClass.put(tableModel.getTable(), subClassName[i]);
            ++i;
        }
        return tableClass;
    }

    public void generate(WorkGenModel workGenModel) throws SQLException {
        VisualdevEntity entity = workGenModel.getEntity();
        List list = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        DownloadCodeForm downloadCodeForm = workGenModel.getDownloadCodeForm();
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        Map<String, String> tableNameAll = this.tableName(tableModelList, downloadCodeForm);
        for (TableModel model : list) {
            String table = model.getTable();
            workGenModel.setTable(table);
            if ("1".equals(model.getTypeId())) {
                workGenModel.setClassName(downloadCodeForm.getClassName());
                this.setCode(workGenModel);
                continue;
            }
            if (!"0".equals(model.getTypeId())) continue;
            String name = tableNameAll.get(table);
            String className = name.substring(0, 1).toUpperCase() + name.substring(1);
            workGenModel.setClassName(className);
            this.childTable(workGenModel);
        }
    }

    private void setCode(WorkGenModel workGenModel) throws SQLException {
        DownloadCodeForm downloadCodeForm = workGenModel.getDownloadCodeForm();
        HashMap<String, Object> columndata = new HashMap<String, Object>(16);
        String className = downloadCodeForm.getClassName().substring(0, 1).toUpperCase() + downloadCodeForm.getClassName().substring(1);
        Template7Model model = this.templateModel(workGenModel, className);
        this.columData(columndata, workGenModel, model);
        DbLinkEntity linkEntity = workGenModel.getLinkEntity();
        columndata.put("DSId", linkEntity != null ? linkEntity.getId() : "master");
        this.javaGenerate(columndata, model, workGenModel, true);
    }

    private void childTable(WorkGenModel workGenModel) {
        Template7Model model = this.templateModel(workGenModel, workGenModel.getClassName());
        HashMap<String, Object> columndata = new HashMap<String, Object>(16);
        columndata.put("genInfo", model);
        DbLinkEntity linkEntity = workGenModel.getLinkEntity();
        columndata.put("DSId", linkEntity != null ? linkEntity.getId() : "master");
        this.javaGenerate(columndata, model, workGenModel, false);
    }

    private Template7Model templateModel(WorkGenModel workGenModel, String className) {
        DownloadCodeForm downloadCodeForm = workGenModel.getDownloadCodeForm();
        Template7Model template7Model = new Template7Model();
        template7Model.setClassName(className);
        template7Model.setServiceDirectory(workGenModel.getServiceDirectory());
        template7Model.setCreateDate(DateUtil.daFormat((Date)new Date()));
        template7Model.setCreateUser("RKKJ\u5f00\u53d1\u5e73\u53f0\u7ec4");
        template7Model.setCopyright("\u8363\u79d1\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        template7Model.setDescription(downloadCodeForm.getDescription());
        return template7Model;
    }

    private Map<String, String> forDataMode(WorkGenModel workGenModel, List<FormAllModel> formAllModel) {
        VisualdevEntity entity = workGenModel.getEntity();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        RecursionForm recursionForm = new RecursionForm(list, tableModelList);
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        Map<String, String> tableNameAll = this.tableName(tableModelList, workGenModel.getDownloadCodeForm());
        return tableNameAll;
    }

    private void javaGenerate(Map<String, Object> columndata, Template7Model model, WorkGenModel workGenModel, boolean isMast) {
        CustomGenerator mpg = new CustomGenerator(columndata);
        GlobalConfig gc = new GlobalConfig();
        gc.setFileOverride(true);
        gc.setActiveRecord(false);
        gc.setEnableCache(false);
        gc.setBaseResultMap(false);
        gc.setBaseColumnList(false);
        gc.setAuthor(model.getCreateUser());
        gc.setOpen(false);
        String className = model.getClassName();
        if (isMast) {
            gc.setControllerName(className + "Controller");
        }
        gc.setEntityName(className + "Entity");
        gc.setMapperName(className + "Mapper");
        gc.setXmlName(className + "Mapper");
        gc.setServiceName(className + "Service");
        gc.setServiceImplName(className + "ServiceImpl");
        mpg.setGlobalConfig(gc);
        UserInfo userInfo = workGenModel.getUserInfo();
        DbLinkEntity linkEntity = workGenModel.getLinkEntity();
        mpg.setDataSource(SourceUtil.dbConfig((String)userInfo.getTenantDbConnectionString(), (DataSourceUtil)linkEntity));
        StrategyConfig strategy = new StrategyConfig();
        strategy.setEntityLombokModel(true);
        strategy.setNaming(NamingStrategy.underline_to_camel);
        String table = workGenModel.getTable();
        strategy.setInclude(new String[]{table});
        strategy.setRestControllerStyle(true);
        mpg.setStrategy(strategy);
        PackageConfig pc = new PackageConfig();
        DownloadCodeForm downloadCodeForm = workGenModel.getDownloadCodeForm();
        pc.setParent("com.bringspring" + downloadCodeForm.getModule());
        mpg.setPackageInfo(pc);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
            }
        };
        ArrayList<FileOutConfig> focList = new ArrayList<FileOutConfig>();
        final String javaPath = model.getServiceDirectory();
        String templatePath = workGenModel.getTemplatePath();
        final String fileName = workGenModel.getFileName();
        String path = workGenModel.getTemplateCodePath();
        if (isMast) {
            focList.add(new FileOutConfig(templatePath + File.separator + "java" + File.separator + "Controller.java.vm"){

                public String outputFile(TableInfo tableInfo) {
                    return javaPath + fileName + File.separator + "java" + File.separator + "controller" + File.separator + tableInfo.getControllerName() + ".java";
                }
            });
        }
        focList.add(new FileOutConfig(templatePath + File.separator + "java" + File.separator + "Entity.java.vm"){

            public String outputFile(TableInfo tableInfo) {
                List fieldAll = tableInfo.getFields();
                TableField mainTableField = fieldAll.stream().filter(tableField -> tableField.isKeyFlag()).findFirst().orElse(null);
                fieldAll = fieldAll.stream().filter(DataControlUtils.distinctByKey(t -> t.getName())).collect(Collectors.toList());
                if (mainTableField != null) {
                    fieldAll.stream().filter(tableField -> tableField.getName().equals(mainTableField.getName())).forEach(t -> t.setKeyFlag(mainTableField.isKeyFlag()));
                }
                for (TableField field : fieldAll) {
                    String name = field.getName().toLowerCase().replaceAll("f_", "");
                    field.setPropertyName(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name));
                }
                tableInfo.setFields(fieldAll);
                return javaPath + fileName + File.separator + "java" + File.separator + "entity" + File.separator + tableInfo.getEntityName() + ".java";
            }
        });
        focList.add(new FileOutConfig(templatePath + File.separator + "java" + File.separator + "Mapper.java.vm"){

            public String outputFile(TableInfo tableInfo) {
                return javaPath + fileName + File.separator + "java" + File.separator + "mapper" + File.separator + tableInfo.getMapperName() + ".java";
            }
        });
        focList.add(new FileOutConfig(templatePath + File.separator + "java" + File.separator + "Mapper.xml.vm"){

            public String outputFile(TableInfo tableInfo) {
                return javaPath + fileName + File.separator + "resources" + File.separator + "mapper" + File.separator + tableInfo.getMapperName() + ".xml";
            }
        });
        focList.add(new FileOutConfig(templatePath + File.separator + "java" + File.separator + "Service.java.vm"){

            public String outputFile(TableInfo tableInfo) {
                return javaPath + fileName + File.separator + "java" + File.separator + "service" + File.separator + tableInfo.getServiceName() + ".java";
            }
        });
        focList.add(new FileOutConfig(templatePath + File.separator + "java" + File.separator + "ServiceImpl.java.vm"){

            public String outputFile(TableInfo tableInfo) {
                return javaPath + fileName + File.separator + "java" + File.separator + "service" + File.separator + "impl" + File.separator + tableInfo.getServiceImplName() + ".java";
            }
        });
        cfg.setFileOutConfigList(focList);
        mpg.setTemplate(new TemplateConfig().setXml(null).setMapper(null).setController(null).setEntity(null).setService(null).setServiceImpl(null));
        mpg.setCfg(cfg);
        mpg.execute(path);
    }

    private void system(List<FormAllModel> formAllModel, List<FieLdsModel> system) {
        List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        for (int i = 0; i < mast.size(); ++i) {
            FormAllModel mastModel = (FormAllModel)mast.get(i);
            FieLdsModel fieLdsModel = mastModel.getFormColumnModel().getFieLdsModel();
            String model = fieLdsModel.getVModel();
            String keyName = fieLdsModel.getConfig().getKeyName();
            PropsModel propsModel = fieLdsModel.getProps();
            if (!StringUtil.isNotEmpty((String)model)) continue;
            if (propsModel != null) {
                PropsBeanModel props = (PropsBeanModel)JsonUtil.getJsonToBean((String)propsModel.getProps(), PropsBeanModel.class);
                propsModel.setPropsModel(props);
            }
            fieLdsModel.setProps(propsModel);
            system.add(fieLdsModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mastTable(List<FormAllModel> formAllModel, Map<String, Object> columndata, WorkGenModel workGenModel, Map<String, String> tableNameAll) throws SQLException {
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        Map<String, List<FormAllModel>> mastListAll = mastTable.stream().collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
        DbLinkEntity linkEntity = workGenModel.getLinkEntity();
        List tableModelList = JsonUtil.getJsonToList((String)workGenModel.getEntity().getVisualTables(), TableModel.class);
        Connection conn = VisualUtils.getDataConn(linkEntity);
        try {
            ArrayList mastTableNameAll = new ArrayList();
            for (String mastkey : mastListAll.keySet()) {
                HashMap<String, Object> childMap = new HashMap<String, Object>();
                String mastTableName = tableNameAll.get(mastkey);
                String className = mastTableName.substring(0, 1).toUpperCase() + mastTableName.substring(1);
                Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(mastkey)).findFirst();
                if (!first.isPresent()) {
                    throw new SQLException(MsgCode.COD001.get());
                }
                TableModel tableModel = first.get();
                String chidKeyName = VisualUtils.getpKey(conn, tableModel.getTable());
                String tableField = tableModel.getTableField().trim().replaceAll(":\"f_", ":\"");
                childMap.put("tableField", tableField);
                String relationField = tableModel.getRelationField().trim().replaceAll(":\"f_", ":\"");
                childMap.put("relationField", relationField);
                childMap.put("className", className);
                String keyName = chidKeyName.trim().toLowerCase().replaceAll("f_", "");
                childMap.put("chidKeyName", keyName);
                childMap.put("childList", mastListAll.get(mastkey));
                childMap.put("table", mastkey);
                mastTableNameAll.add(childMap);
            }
            columndata.put("tableNameAll", mastTableNameAll);
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void child(List<FormAllModel> formAllModel, List<Map<String, Object>> child, WorkGenModel workGenModel, Map<String, String> tableNameAll) throws SQLException {
        List table = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        DbLinkEntity linkEntity = workGenModel.getLinkEntity();
        List tableModelList = JsonUtil.getJsonToList((String)workGenModel.getEntity().getVisualTables(), TableModel.class);
        Connection conn = VisualUtils.getDataConn(linkEntity);
        try {
            for (FormAllModel tableModelAll : table) {
                FormColumnTableModel childList = tableModelAll.getChildList();
                String childTableName = childList.getTableName();
                String name = tableNameAll.get(childTableName);
                List columnList = childList.getChildList();
                for (int i = 0; i < columnList.size(); ++i) {
                    String model = ((FormColumnModel)columnList.get(i)).getFieLdsModel().getVModel();
                    if (!StringUtil.isEmpty((String)model)) continue;
                    columnList.remove(i);
                }
                childList.setChildList(columnList);
                Map childs = JsonUtil.entityToMap((Object)childList);
                String childClassName = name.substring(0, 1).toUpperCase() + name.substring(1);
                Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(childList.getTableName())).findFirst();
                if (!first.isPresent()) {
                    throw new SQLException(MsgCode.COD001.get());
                }
                TableModel tableModel = first.get();
                String chidKeyName = VisualUtils.getpKey(conn, tableModel.getTable());
                String tableField = tableModel.getTableField().trim().replaceAll(":\"f_", ":\"");
                childs.put("tableField", tableField);
                String relationField = tableModel.getRelationField().trim().replaceAll(":\"f_", ":\"");
                childs.put("relationField", relationField);
                childs.put("className", childClassName);
                String keyName = chidKeyName.trim().toLowerCase().replaceAll("f_", "");
                childs.put("chidKeyName", keyName);
                child.add(childs);
            }
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    private void columData(Map<String, Object> columndata, WorkGenModel workGenModel, Template7Model template7Model) throws SQLException {
        ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
        Map<String, String> tableNameAll = this.forDataMode(workGenModel, formAllModel);
        ArrayList<FieLdsModel> system = new ArrayList<FieLdsModel>();
        this.system(formAllModel, system);
        ArrayList<Map<String, Object>> child = new ArrayList<Map<String, Object>>();
        this.child(formAllModel, child, workGenModel, tableNameAll);
        this.mastTable(formAllModel, columndata, workGenModel, tableNameAll);
        DownloadCodeForm downloadCodeForm = workGenModel.getDownloadCodeForm();
        columndata.put("genInfo", template7Model);
        columndata.put("areasName", downloadCodeForm.getModule());
        columndata.put("modelName", template7Model.getClassName());
        columndata.put("typeId", 1);
        columndata.put("system", system);
        columndata.put("child", child);
        String pKeyName = workGenModel.getPKeyName().toLowerCase().trim().replaceAll("f_", "");
        columndata.put("pKeyName", pKeyName);
        columndata.put("isModel", "true");
        String modelPathName = downloadCodeForm.getClassName().substring(0, 1).toLowerCase() + downloadCodeForm.getClassName().substring(1);
        columndata.put("modelPathName", modelPathName);
        columndata.put("module", downloadCodeForm.getModule());
    }
}

