/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.base.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.model.dataInterface.DataInterfaceActionVo;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DictionaryDataService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynDicUtil {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DataInterfaceService dataInterfaceService;
    public final String regEx = "[\\[\\]\"]";

    public String getDicName(String feild, String dictionaryTypeId) {
        if (this.redisUtil.exists(this.cacheKeyUtil.getDictionary() + feild)) {
            return this.redisUtil.getString(this.cacheKeyUtil.getDictionary() + feild).toString();
        }
        if (StringUtil.isNotEmpty((String)feild)) {
            String[] feilds = (feild = feild.replaceAll("[\\[\\]\"]", "")).split(",");
            if (feilds.length > 1) {
                StringBuilder feildsValue = new StringBuilder();
                for (String feil : feilds) {
                    DictionaryDataEntity dictionaryDataEntity = this.dictionaryDataService.getSwapInfo(feil, dictionaryTypeId);
                    if (dictionaryDataEntity == null) continue;
                    feildsValue.append(dictionaryDataEntity.getFullName() + ",");
                }
                String finalValue = StringUtil.isEmpty((CharSequence)feildsValue) || feildsValue.equals("") ? feildsValue.toString() : feildsValue.substring(0, feildsValue.length() - 1);
                this.redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
                this.redisUtil.insert(this.cacheKeyUtil.getDictionary() + feild, (Object)finalValue, 20L);
                return finalValue;
            }
            DictionaryDataEntity dictionaryDataentity = this.dictionaryDataService.getSwapInfo(feild, dictionaryTypeId);
            if (dictionaryDataentity != null) {
                this.redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
                this.redisUtil.insert(this.cacheKeyUtil.getDictionary() + feild, (Object)dictionaryDataentity.getFullName(), 20L);
                return dictionaryDataentity.getFullName();
            }
            return feild;
        }
        return feild;
    }

    public String getDynName(String urlId, String label, String value, String feildValue) {
        String rediskey = this.cacheKeyUtil.getDynamic() + "_" + urlId + "_" + feildValue;
        if (this.redisUtil.exists(rediskey)) {
            return this.redisUtil.getString(rediskey).toString();
        }
        if (StringUtil.isNotEmpty((String)feildValue)) {
            feildValue = feildValue.replaceAll("[\\[\\]\"]", "");
            ActionResult object = this.dataInterfaceService.infoToId(urlId);
            if (object.getData() != null && object.getData() instanceof DataInterfaceActionVo) {
                DataInterfaceActionVo vo = (DataInterfaceActionVo)object.getData();
                List dataList = (List)vo.getData();
                String[] feildValues = feildValue.split(",");
                if (feildValues.length > 0) {
                    StringBuilder feildVa = new StringBuilder();
                    for (String feild : feildValues) {
                        for (Map data : dataList) {
                            if (!String.valueOf(data.get(value)).equals(feild)) continue;
                            feildVa.append(data.get(label) + ",");
                        }
                    }
                    String finalValue = StringUtil.isEmpty((CharSequence)feildVa) || feildVa.equals("") ? feildVa.toString() : feildVa.substring(0, feildVa.length() - 1);
                    this.redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
                    this.redisUtil.insert(rediskey, (Object)finalValue, 20L);
                    return finalValue;
                }
                Iterator iterator = dataList.iterator();
                if (iterator.hasNext()) {
                    Map data = (Map)iterator.next();
                    if (feildValue.equals(String.valueOf(data.get(value)))) {
                        this.redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
                        this.redisUtil.insert(rediskey, (Object)data.get(label).toString(), 20L);
                        return data.get(label).toString();
                    }
                    return feildValue;
                }
            }
            return feildValue;
        }
        return feildValue;
    }

    public String getDynName(String urlId, String name, String id, String children, String feildValue) {
        String rediskey = this.cacheKeyUtil.getDynamic() + "_" + urlId + "_" + feildValue;
        if (this.redisUtil.exists(rediskey)) {
            return this.redisUtil.getString(rediskey).toString();
        }
        List<Object> result = new ArrayList();
        if (StringUtil.isNotEmpty((String)feildValue)) {
            ActionResult object = this.dataInterfaceService.infoToId(urlId);
            DataInterfaceActionVo actionVo = (DataInterfaceActionVo)object.getData();
            List dataList = new ArrayList();
            if (actionVo.getData() instanceof List) {
                dataList = (List)actionVo.getData();
            }
            JSONArray dataAll = JsonUtil.getListToJsonArray(dataList);
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            this.treeToList(id, name, children, dataAll, list);
            String value = feildValue.replaceAll("\\[", "").replaceAll("\\]", "");
            result = list.stream().filter(t -> value.contains(String.valueOf(t.get(id)))).map(t -> String.valueOf(t.get(name))).collect(Collectors.toList());
        }
        return String.join((CharSequence)",", result);
    }

    private void treeToList(String id, String fullName, String children, JSONArray data, List<Map<String, String>> result) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(id, String.valueOf(ob.get((Object)id)));
            tree.put(fullName, String.valueOf(ob.get((Object)fullName)));
            result.add(tree);
            if (ob.get((Object)children) == null) continue;
            JSONArray childArray = ob.getJSONArray(children);
            this.treeToList(id, fullName, children, childArray, result);
        }
    }
}

