/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataField;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.VisualdevTreeChildModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.model.online.VisualMenuModel;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.util.visualUtil.PubulishUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.model.PaginationVisualdev;
import com.bringspring.visualdev.base.model.VisualDevCrForm;
import com.bringspring.visualdev.base.model.VisualDevInfoVO;
import com.bringspring.visualdev.base.model.VisualDevPubModel;
import com.bringspring.visualdev.base.model.VisualDevUpForm;
import com.bringspring.visualdev.base.model.VisualFunctionModel;
import com.bringspring.visualdev.base.model.VisualdevTreeVO;
import com.bringspring.visualdev.base.model.template6.BtnData;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.base.util.VisualUtil;
import com.bringspring.visualdev.onlinedev.model.PaginationModel;
import com.bringspring.visualdev.onlinedev.service.VisualdevModelDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53ef\u89c6\u5316\u57fa\u7840\u6a21\u5757"}, value="Base")
@RestController
@RequestMapping(value={"/api/visualdev/Base"})
public class VisualdevController {
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private UserService userService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private PubulishUtil pubulishUtil;
    @Autowired
    private ModuleService moduleService;

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<VisualFunctionModel>> list(PaginationVisualdev paginationVisualdev) {
        List<VisualdevEntity> data = this.visualdevService.getList(paginationVisualdev);
        List userId = data.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List lastUserId = data.stream().map(t -> t.getLastModifyUserId()).collect(Collectors.toList());
        List userEntities = this.userService.getUserName(userId);
        List lastUserIdEntities = this.userService.getUserName(lastUserId);
        List dictionList = this.dictionaryDataService.getList(DictionaryDataEnum.getTypeId((Integer)paginationVisualdev.getType()));
        LinkedList<VisualFunctionModel> modelAll = new LinkedList<VisualFunctionModel>();
        for (VisualdevEntity entity : data) {
            VisualFunctionModel model = (VisualFunctionModel)JsonUtil.getJsonToBean((Object)entity, VisualFunctionModel.class);
            DictionaryDataEntity dataEntity = dictionList.stream().filter(t -> t.getId().equals(entity.getCategory())).findFirst().orElse(null);
            model.setCategory(dataEntity != null ? dataEntity.getFullName() : null);
            UserEntity creatorUser = userEntities.stream().filter(t -> t.getId().equals(model.getCreatorUserId())).findFirst().orElse(null);
            model.setCreatorUserId(creatorUser != null ? creatorUser.getRealName() + "/" + creatorUser.getAccount() : "");
            UserEntity lastmodifyuser = lastUserIdEntities.stream().filter(t -> t.getId().equals(model.getLastModifyUserId())).findFirst().orElse(null);
            model.setLastModifyUserId(lastmodifyuser != null ? lastmodifyuser.getRealName() + "/" + lastmodifyuser.getAccount() : "");
            List moduleList = this.moduleService.getModuleList(entity.getId());
            model.setAppIsRelease(0);
            model.setPcIsRelease(0);
            if (moduleList.size() > 0) {
                ModuleEntity appModuleEntity = moduleList.stream().filter(module -> "app".equalsIgnoreCase(module.getCategory())).findFirst().orElse(null);
                ModuleEntity pcModuleEntity = moduleList.stream().filter(module -> "web".equalsIgnoreCase(module.getCategory())).findFirst().orElse(null);
                model.setAppIsRelease(Objects.nonNull(appModuleEntity) ? 1 : 0);
                model.setPcIsRelease(Objects.nonNull(pcModuleEntity) ? 1 : 0);
            }
            modelAll.add(model);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationVisualdev), PaginationVO.class);
        return ActionResult.page(modelAll, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u5217\u8868\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult selectorList(Integer type) {
        VisualdevTreeVO visualdevTreeVO;
        int i;
        List list = this.visualdevService.getList().stream().filter(t -> t.getState() == 1).collect(Collectors.toList());
        List dataEntityList = new ArrayList(16);
        ArrayList<VisualdevTreeVO> voList = new ArrayList<VisualdevTreeVO>();
        HashSet<String> cate = new HashSet<String>(16);
        if (type != null) {
            list = list.stream().filter(t -> type.equals(t.getType())).collect(Collectors.toList());
            dataEntityList = this.dictionaryDataService.getList(DictionaryDataEnum.getTypeId((Integer)type));
            for (DictionaryDataEntity dataEntity : dataEntityList) {
                List num = list.stream().filter(t -> dataEntity.getId().equals(t.getCategory())).collect(Collectors.toList());
                if (num.size() <= 0) continue;
                i = cate.size();
                cate.add(dataEntity.getId());
                if (cate.size() != i + 1) continue;
                visualdevTreeVO = new VisualdevTreeVO();
                visualdevTreeVO.setId(dataEntity.getId());
                visualdevTreeVO.setFullName(dataEntity.getFullName());
                visualdevTreeVO.setHasChildren(true);
                voList.add(visualdevTreeVO);
            }
        } else {
            for (VisualdevEntity entity : list) {
                DictionaryDataEntity dataEntity;
                if (StringUtil.isEmpty((String)entity.getCategory()) || (dataEntity = this.dictionaryDataService.getInfo(entity.getCategory())) == null) continue;
                i = cate.size();
                cate.add(dataEntity.getId());
                if (cate.size() != i + 1) continue;
                visualdevTreeVO = new VisualdevTreeVO();
                visualdevTreeVO.setId(entity.getCategory());
                visualdevTreeVO.setFullName(dataEntity.getFullName());
                visualdevTreeVO.setHasChildren(true);
                voList.add(visualdevTreeVO);
            }
        }
        for (VisualdevTreeVO vo : voList) {
            ArrayList<VisualdevTreeChildModel> visualdevTreeChildModelList = new ArrayList<VisualdevTreeChildModel>();
            for (VisualdevEntity entity : list) {
                if (!vo.getId().equals(entity.getCategory())) continue;
                VisualdevTreeChildModel model = (VisualdevTreeChildModel)JsonUtil.getJsonToBean((Object)entity, VisualdevTreeChildModel.class);
                visualdevTreeChildModelList.add(model);
            }
            vo.setChildren(visualdevTreeChildModelList);
        }
        ListVO listVO = new ListVO();
        listVO.setList(voList);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) throws DataException {
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        VisualDevInfoVO vo = (VisualDevInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, VisualDevInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u4e3b\u8868\u5c5e\u6027\u4e0b\u62c9\u6846")
    @GetMapping(value={"/{id}/FormDataFields"})
    public ActionResult getFormData(@PathVariable(value="id") String id) {
        List<FormDataField> fieldList = this.visualdevModelDataService.fieldList(id);
        ListVO listVO = new ListVO();
        listVO.setList(fieldList);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u5173\u8054\u6570\u636e\u5206\u9875\u6570\u636e")
    @GetMapping(value={"/{id}/FieldDataSelect"})
    public ActionResult getFormData(@PathVariable(value="id") String id, PaginationModel paginationModel) {
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        List<Map<String, Object>> realList = this.visualdevModelDataService.getPageList(entity, paginationModel);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationModel), PaginationVO.class);
        return ActionResult.page(realList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u590d\u5236\u529f\u80fd")
    @PostMapping(value={"/{id}/Actions/Copy"})
    public ActionResult copyInfo(@PathVariable(value="id") String id) throws WorkFlowException {
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        entity.setState(0);
        String copyNum = UUID.randomUUID().toString().substring(0, 5);
        entity.setFullName(entity.getFullName() + ".\u526f\u672c" + copyNum);
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        entity.setCreatorTime(null);
        entity.setId(RandomUtil.uuId());
        entity.setEnCode(entity.getEnCode() + copyNum);
        VisualdevEntity entity1 = (VisualdevEntity)JsonUtil.getJsonToBean((Object)entity, VisualdevEntity.class);
        if (entity1.getEnCode().length() > 50 || entity1.getFullName().length() > 50) {
            return ActionResult.fail((String)"\u5df2\u5230\u8fbe\u8be5\u6a21\u677f\u590d\u5236\u4e0a\u9650\uff0c\u8bf7\u590d\u5236\u6e90\u6a21\u677f");
        }
        this.visualdevService.create(entity1);
        return ActionResult.success((String)"\u590d\u5236\u529f\u80fd\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0\u529f\u80fd\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult update(@PathVariable(value="id") String id) throws WorkFlowException {
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        if (entity != null) {
            if (entity.getState() == 1) {
                entity.setState(0);
            } else {
                entity.setState(1);
            }
            boolean flag = this.visualdevService.update(entity.getId(), entity);
            if (!flag) {
                return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u65b0\u5efa\u529f\u80fd")
    @PostMapping
    public ActionResult create(@RequestBody VisualDevCrForm visualDevCrForm) throws WorkFlowException {
        VisualdevEntity entity = (VisualdevEntity)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToString((Object)visualDevCrForm), VisualdevEntity.class);
        RecursionForm recursionForm = new RecursionForm();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        recursionForm.setList(list);
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        recursionForm.setTableModelList(tableModelList);
        if (FormCloumnUtil.repetition((RecursionForm)recursionForm, new ArrayList())) {
            return ActionResult.fail((String)"\u5b50\u8868\u91cd\u590d");
        }
        if (this.visualdevService.getObjByEncode(entity.getEnCode(), entity.getType()) > 0L) {
            return ActionResult.fail((String)"\u7f16\u7801\u91cd\u590d");
        }
        if (this.visualdevService.getCountByName(entity.getFullName(), entity.getType()) > 0L) {
            return ActionResult.fail((String)"\u540d\u79f0\u91cd\u590d");
        }
        this.visualdevService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u529f\u80fd")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody VisualDevUpForm visualDevUpForm) throws WorkFlowException {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(id);
        String enCode = visualdevEntity.getEnCode();
        String fullName = visualdevEntity.getFullName();
        VisualdevEntity entity = (VisualdevEntity)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToString((Object)visualDevUpForm), VisualdevEntity.class);
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        if (tableModelList.size() == 0) {
            return ActionResult.fail((String)"\u5fc5\u987b\u5b58\u5728\u81f3\u5c11\u4e00\u4e2a\u8868");
        }
        if (!enCode.equals(visualDevUpForm.getEnCode()) && this.visualdevService.getObjByEncode(entity.getEnCode(), entity.getType()) > 0L) {
            return ActionResult.fail((String)"\u7f16\u7801\u91cd\u590d");
        }
        if (!fullName.equals(visualDevUpForm.getFullName()) && this.visualdevService.getCountByName(entity.getFullName(), entity.getType()) > 0L) {
            return ActionResult.fail((String)"\u540d\u79f0\u91cd\u590d");
        }
        RecursionForm recursionForm = new RecursionForm();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        recursionForm.setList(list);
        recursionForm.setTableModelList(tableModelList);
        if (FormCloumnUtil.repetition((RecursionForm)recursionForm, new ArrayList())) {
            return ActionResult.fail((String)"\u5b50\u8868\u91cd\u590d");
        }
        boolean flag = this.visualdevService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u529f\u80fd")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) throws WorkFlowException {
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        if (entity != null) {
            this.visualdevService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u6309\u94ae\u548c\u5217\u8868\u5b57\u6bb5")
    @GetMapping(value={"/ModuleBtn"})
    public ActionResult getModuleBtn(String moduleId) {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(moduleId);
        VisualUtil.delfKey(visualdevEntity);
        ArrayList btnData = new ArrayList();
        Map column = JsonUtil.stringToMap((String)visualdevEntity.getColumnData());
        if (column.get("columnBtnsList") != null) {
            btnData.addAll(JsonUtil.getJsonToList((Object)JsonUtil.getJsonToListMap((String)column.get("columnBtnsList").toString()), BtnData.class));
        }
        if (column.get("btnsList") != null) {
            btnData.addAll(JsonUtil.getJsonToList((Object)JsonUtil.getJsonToListMap((String)column.get("btnsList").toString()), BtnData.class));
        }
        return ActionResult.success(btnData);
    }

    @ApiOperation(value="\u53d1\u5e03\u529f\u80fd")
    @PostMapping(value={"/{id}/Actions/Release"})
    public ActionResult publish(@PathVariable(value="id") String id, @RequestBody VisualDevPubModel visualDevPubModel) {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(id);
        if (visualdevEntity.getState() == 0) {
            return ActionResult.fail((String)"\u8be5\u529f\u80fd\u5df2\u505c\u7528\u65e0\u6cd5\u540c\u6b65\u83dc\u5355!");
        }
        VisualMenuModel visual = VisualUtil.getVisual(visualdevEntity, visualDevPubModel);
        visual.setApp(visualDevPubModel.getApp());
        visual.setPc(visualDevPubModel.getPc());
        visual.setAppModuleParentId(visualDevPubModel.getAppModuleParentId());
        visual.setPcModuleParentId(visualDevPubModel.getPcModuleParentId());
        Integer integer = this.pubulishUtil.publishMenu(visual);
        if (integer == 2) {
            return ActionResult.fail((String)"\u540c\u6b65\u5931\u8d25,\u68c0\u67e5\u7f16\u7801\u6216\u540d\u79f0\u662f\u5426\u91cd\u590d");
        }
        if (integer == 3) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u7236\u7ea7\u83dc\u5355");
        }
        return ActionResult.success((String)"\u540c\u6b65\u6210\u529f");
    }
}

