/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.generater.util.common;

import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormColumnModel;
import com.bringspring.common.model.FormColumnTableModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.FormMastTableModel;
import com.bringspring.common.model.visiual.DownloadCodeForm;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.config.ConfigModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineModel;
import com.bringspring.workflow.engine.model.flowengine.FlowExportModel;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FunctionFormPublicUtil {
    public static FlowExportModel jsonFile(VisualdevEntity entity, DownloadCodeForm downloadCodeForm) {
        FlowEngineModel engineModel;
        ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
        FunctionFormPublicUtil.forDataMode(entity, formAllModel);
        List mastList = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        ArrayList<FlowEngineModel> tempJson = new ArrayList<FlowEngineModel>();
        for (FormAllModel mastModel : mastList) {
            FieLdsModel fieLdsModel = mastModel.getFormColumnModel().getFieLdsModel();
            String model = fieLdsModel.getVModel();
            ConfigModel configModel = fieLdsModel.getConfig();
            if (!StringUtil.isNotEmpty((String)model)) continue;
            FlowEngineModel engineModel2 = new FlowEngineModel();
            String label = configModel.getLabel();
            engineModel2.setFiledId(model);
            engineModel2.setFiledName(label);
            engineModel2.setRequired(Boolean.valueOf(configModel.isRequired()));
            tempJson.add(engineModel2);
        }
        List<FormAllModel> tableList = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        Map<String, String> tableListAll = FunctionFormPublicUtil.tableNameRename(downloadCodeForm, tableModelList);
        for (FormAllModel formAllModel2 : tableList) {
            String table = formAllModel2.getChildList().getTableName();
            String name = tableListAll.get(table);
            FormColumnTableModel childList = formAllModel2.getChildList();
            String label = childList.getLabel();
            boolean required = childList.isRequired();
            engineModel = new FlowEngineModel();
            engineModel.setFiledId(name.toLowerCase() + "List");
            engineModel.setFiledName(label);
            engineModel.setRequired(Boolean.valueOf(required));
            tempJson.add(engineModel);
            for (FormColumnModel columnModel : formAllModel2.getChildList().getChildList()) {
                String vModel = columnModel.getFieLdsModel().getVModel();
                String childLable = columnModel.getFieLdsModel().getConfig().getLabel();
                ConfigModel config = columnModel.getFieLdsModel().getConfig();
                if (!StringUtil.isNotEmpty((String)vModel)) continue;
                FlowEngineModel childModel = new FlowEngineModel();
                childModel.setFiledId(name.toLowerCase() + "List-" + vModel);
                childModel.setFiledName(label + "-" + childLable);
                childModel.setRequired(Boolean.valueOf(config.isRequired()));
                tempJson.add(childModel);
            }
        }
        List mastTableList = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        for (FormAllModel mastTableModel : mastTableList) {
            FormMastTableModel formMastTableModel = mastTableModel.getFormMastTableModel();
            FieLdsModel fieLdsModel = formMastTableModel.getMastTable().getFieLdsModel();
            String model = formMastTableModel.getVModel();
            ConfigModel config = fieLdsModel.getConfig();
            if (!StringUtil.isNotEmpty((String)model)) continue;
            engineModel = new FlowEngineModel();
            String label = config.getLabel();
            engineModel.setFiledId(model);
            engineModel.setFiledName(label);
            engineModel.setRequired(Boolean.valueOf(config.isRequired()));
            tempJson.add(engineModel);
        }
        FunctionFormPublicUtil.tableJson(tableList, entity, tableListAll);
        FlowEngineEntity flowEngineEntity = FunctionFormPublicUtil.flowEngine(entity, downloadCodeForm.getClassName());
        flowEngineEntity.setFormData(JsonUtil.getObjectToString(tempJson));
        FlowExportModel exportModel = new FlowExportModel();
        exportModel.setFlowEngine(flowEngineEntity);
        exportModel.setVisibleList(new ArrayList());
        return exportModel;
    }

    private static FlowEngineEntity flowEngine(VisualdevEntity entity, String className) {
        FlowEngineEntity engineEntity = (FlowEngineEntity)JsonUtil.getJsonToBean((Object)entity, FlowEngineEntity.class);
        engineEntity.setFlowTables("[]");
        engineEntity.setFormType(Integer.valueOf(1));
        engineEntity.setType(Integer.valueOf(1));
        engineEntity.setSortCode(Long.valueOf(0L));
        engineEntity.setEnabledMark(Integer.valueOf(1));
        engineEntity.setVisibleType(Integer.valueOf(0));
        engineEntity.setIcon("fa fa-file-text-o");
        engineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
        String formUrl = "extend/" + className.toLowerCase() + "/form.vue";
        if (entity.getType() == 4 && entity.getWebType() == 3) {
            engineEntity.setFormUrl(formUrl);
        } else if (entity.getType() == 5 && entity.getWebType() == 3) {
            engineEntity.setAppFormUrl(formUrl);
        }
        DictionaryDataService dataService = (DictionaryDataService)SpringContext.getBean(DictionaryDataService.class);
        DictionaryDataEntity dataEntity = dataService.getInfo(entity.getCategory());
        engineEntity.setCategory(dataEntity != null ? dataEntity.getEnCode() : entity.getCategory());
        return engineEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(String data, String path) {
        block6: {
            try {
                File file = new File(XSSEscape.escapePath((String)(path + File.separator + "flow." + ModuleTypeEnum.FLOW_FLOWENGINE.getTableName())));
                boolean b = file.createNewFile();
                if (!b) break block6;
                FileWriter out = new FileWriter(file);
                try {
                    out.write(data);
                    ((Writer)out).close();
                }
                finally {
                    if (Collections.singletonList(out).get(0) != null) {
                        ((Writer)out).close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void forDataMode(VisualdevEntity entity, List<FormAllModel> formAllModel) {
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        RecursionForm recursionForm = new RecursionForm(list, tableModelList);
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
    }

    public static Map<String, String> tableNameRename(DownloadCodeForm downloadCodeForm, List<TableModel> tableModelList) {
        HashMap<String, String> tableNameMap = new HashMap<String, String>(16);
        int i = 0;
        for (TableModel tableModel : tableModelList) {
            if ("0".equals(tableModel.getTypeId())) {
                String[] subClassName = downloadCodeForm.getSubClassName().split(",");
                tableNameMap.put(tableModel.getTable(), subClassName[i]);
                ++i;
                continue;
            }
            tableNameMap.put(tableModel.getTable(), downloadCodeForm.getClassName());
        }
        return tableNameMap;
    }

    private static void tableJson(List<FormAllModel> tableList, VisualdevEntity entity, Map<String, String> tableListAll) {
        String json = entity.getFlowTemplateJson();
        for (FormAllModel model : tableList) {
            String table = model.getChildList().getTableName();
            String tableModel = model.getChildList().getTableModel();
            String name = tableListAll.get(table);
            json = json.replaceAll(tableModel, name.toLowerCase() + "List");
        }
        entity.setFlowTemplateJson(json);
    }
}

