/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtil;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineColumnFieldModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OnlineDatabaseUtils {
    public static List<OnlineDevListDataVO> getTableDataList(Connection conn, String sql, String pKeyName, List<OnlineColumnFieldModel> childFieldList) {
        ArrayList<OnlineDevListDataVO> list = new ArrayList<OnlineDevListDataVO>();
        try {
            List fieldMods = JdbcUtil.queryIncludeFieldMods((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
            ArrayList dataList = new ArrayList();
            for (List list2 : fieldMods) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                HashMap collect = list2.stream().collect(Collectors.toMap(s -> Optional.ofNullable(s.getColumnName()).orElse(""), s -> Optional.ofNullable(s.getColumnValue()).orElse(""), (a, b) -> b, HashMap::new));
                dataMap.putAll(collect);
                for (OnlineColumnFieldModel on : childFieldList) {
                    DbFieldMod fieldMod = list2.stream().filter(dbMod -> dbMod.getTableName().equalsIgnoreCase(on.getTableName()) && dbMod.getColumnName().equalsIgnoreCase(on.getField())).findFirst().orElse(null);
                    if (!ObjectUtil.isNotEmpty((Object)fieldMod)) continue;
                    dataMap.remove(fieldMod.getColumnName());
                    dataMap.put(on.getOriginallyField(), fieldMod.getColumnValue());
                }
                dataList.add(dataMap);
            }
            for (Map map : dataList) {
                OnlineDevListDataVO dataVo = new OnlineDevListDataVO();
                Map<String, Object> map2 = OnlineDatabaseUtils.toLowerKey(map);
                dataVo.setData(map2);
                if (map2.containsKey(pKeyName.toUpperCase())) {
                    dataVo.setId(String.valueOf(map2.get(pKeyName.toUpperCase())));
                }
                list.add(dataVo);
            }
        }
        catch (DataException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Map<String, Object> toLowerKey(Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        Set<String> sets = map.keySet();
        for (String key : sets) {
            resultMap.put(key.toLowerCase(), map.get(key));
        }
        return resultMap;
    }

    public static Boolean existKey(List<String> feilds, String pKeyName) {
        if (feilds.size() > 0) {
            for (String feild : feilds) {
                if (!feild.equals(pKeyName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<OnlineDevListDataVO> setDataId(String keyName, List<OnlineDevListDataVO> DevList) {
        keyName = keyName.toLowerCase();
        for (OnlineDevListDataVO dataVo : DevList) {
            Map<String, Object> dataMap = dataVo.getData();
            if (dataMap.get(keyName) == null) continue;
            dataVo.setId(String.valueOf(dataMap.get(keyName)));
        }
        return DevList;
    }

    public static List<Object> getValueList(List<VisualColumnSearchVO> searchVOList) {
        LinkedList<Object> valueList = new LinkedList<Object>();
        block13: for (VisualColumnSearchVO vo : searchVOList) {
            String keyName;
            switch (keyName = vo.getConfig().getKeyName()) {
                case "modifyTime": 
                case "createTime": 
                case "date": {
                    JSONArray timeStampArray = (JSONArray)vo.getValue();
                    Long o1 = (Long)timeStampArray.get(0);
                    Long o2 = (Long)timeStampArray.get(1);
                    String format = StringUtil.isEmpty((String)vo.getFormat()) ? "yyyy-MM-dd HH:mm:ss" : vo.getFormat();
                    String startTime = OnlinePublicUtils.getDateByFormat(o1, format);
                    String endTime = OnlinePublicUtils.getDateByFormat(o2, format);
                    endTime = endTime.substring(0, 10);
                    String firstTimeDate = OnlineDatabaseUtils.getTimeFormat(startTime);
                    String lastTimeDate = OnlineDatabaseUtils.getLastTimeFormat(endTime);
                    valueList.add(firstTimeDate);
                    valueList.add(lastTimeDate);
                    continue block13;
                }
                case "time": {
                    JSONArray timeArray = (JSONArray)vo.getValue();
                    String start = String.valueOf(timeArray.get(0));
                    String end = String.valueOf(timeArray.get(1));
                    valueList.add(start);
                    valueList.add(end);
                    continue block13;
                }
                case "numInput": 
                case "calculate": {
                    List searchArray = (List)vo.getValue();
                    Integer firstValue = null;
                    Integer secondValue = null;
                    for (int i = 0; i < searchArray.size(); ++i) {
                        String name = (String)searchArray.get(i);
                        if (!StringUtil.isNotEmpty((String)name)) continue;
                        if (i == 0) {
                            firstValue = Integer.valueOf(name);
                            continue;
                        }
                        secondValue = Integer.valueOf(name);
                    }
                    if (firstValue != null) {
                        valueList.add(firstValue);
                    }
                    if (secondValue == null) continue block13;
                    valueList.add(secondValue);
                    continue block13;
                }
            }
            valueList.add(vo.getValue());
        }
        return valueList;
    }

    public static String getTimeFormat(String time) {
        String result;
        switch (time.length()) {
            case 16: {
                result = time + ":00";
                break;
            }
            case 19: {
                result = time;
                break;
            }
            case 21: {
                result = time.substring(0, time.length() - 2);
                break;
            }
            case 10: {
                result = time + " 00:00:00";
                break;
            }
            case 8: {
                result = "2000-01-01 " + time;
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public static String getLastTimeFormat(String time) {
        String result;
        switch (time.length()) {
            case 16: {
                result = time + ":00";
                break;
            }
            case 19: {
                result = time;
                break;
            }
            case 10: {
                result = time + " 23:59:59";
                break;
            }
            case 8: {
                result = "2000-01-01 " + time;
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }
}

