/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.visualdev.base.util.VisualUtils;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineColumnChildFieldModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineColumnFieldModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineListSqlModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDatabaseUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OnlineProductSqlUtils {
    private static DataSourceModel dataSourceModel = (DataSourceModel)SpringContext.getBean(DataSourceModel.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder getColumnListSql(StringBuilder sql, List<TableModel> tableModelList, List<String> collect, DbLinkEntity linkEntity) {
        try {
            collect = collect.stream().distinct().collect(Collectors.toList());
            Connection conn = VisualUtils.getDataConn(linkEntity);
            try {
                TableModel mainTable = tableModelList.stream().filter(model -> model.getTypeId().equals("1")).findFirst().orElse(null);
                String pKeyName = VisualUtils.getpKey(conn, mainTable.getTable());
                String reg = "^[jsbos_]\\S*_jsbos\\S*";
                List mainTableFields = collect.stream().filter(s -> !s.matches(reg)).collect(Collectors.toList());
                mainTableFields.add(pKeyName);
                List childFieldList = collect.stream().filter(s -> s.matches(reg)).map(child -> {
                    OnlineColumnFieldModel fieldModel = new OnlineColumnFieldModel();
                    String s1 = child.substring(child.lastIndexOf("jsbos_")).replace("jsbos_", "");
                    String s2 = child.substring(child.indexOf("_") + 1, child.lastIndexOf("_jsbos"));
                    fieldModel.setTableName(s2);
                    fieldModel.setField(s1);
                    fieldModel.setOriginallyField((String)child);
                    return fieldModel;
                }).collect(Collectors.toList());
                List ColumnTableNameList = childFieldList.stream().map(t -> t.getTableName().toLowerCase()).collect(Collectors.toList());
                List tableModelList1 = tableModelList.stream().filter(t -> ColumnTableNameList.contains(t.getTable().toLowerCase())).collect(Collectors.toList());
                ArrayList<OnlineColumnChildFieldModel> classifyFieldList = new ArrayList<OnlineColumnChildFieldModel>(10);
                for (TableModel t2 : tableModelList1) {
                    OnlineColumnChildFieldModel childFieldModel = new OnlineColumnChildFieldModel();
                    childFieldModel.setTable(t2.getTable());
                    childFieldModel.setRelationField(t2.getRelationField());
                    childFieldModel.setTableField(t2.getTableField());
                    classifyFieldList.add(childFieldModel);
                }
                for (int i = 0; i < childFieldList.size(); ++i) {
                    OnlineColumnFieldModel model2 = (OnlineColumnFieldModel)childFieldList.get(i);
                    model2.setOtherName(model2.getField() + "_" + i);
                }
                String mainSqlFields = mainTableFields.stream().collect(Collectors.joining(","));
                String childFields = "";
                if (classifyFieldList.size() > 0) {
                    mainSqlFields = mainTableFields.stream().map(m -> mainTable.getTable() + "." + m).collect(Collectors.joining(","));
                    childFields = "," + childFieldList.stream().map(c -> c.getTableName() + "." + c.getField() + "  " + c.getOtherName()).collect(Collectors.joining(","));
                }
                OnlineListSqlModel listSqlModel = new OnlineListSqlModel();
                listSqlModel.setFields(mainSqlFields + childFields);
                listSqlModel.setMainTable(mainTable.getTable());
                listSqlModel.setPKeyName(pKeyName);
                sql = OnlineProductSqlUtils.getSqlByDatabase(classifyFieldList, listSqlModel, linkEntity);
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return sql;
    }

    public static StringBuilder getSqlByDatabase(List<OnlineColumnChildFieldModel> classifyFieldList, OnlineListSqlModel listSqlModel, DbLinkEntity linkEntity) {
        StringBuilder sql = new StringBuilder();
        String mainTable = listSqlModel.getMainTable();
        if (classifyFieldList.size() > 0) {
            sql.append("select " + listSqlModel.getFields() + " from" + " " + mainTable);
            for (OnlineColumnChildFieldModel model : classifyFieldList) {
                sql.append(" LEFT JOIN " + model.getTable() + " ON " + model.getTable() + "." + model.getTableField() + "=" + mainTable + "." + model.getRelationField() + " ");
            }
        } else {
            sql.append("select " + listSqlModel.getFields() + " from" + " " + mainTable);
        }
        return sql;
    }

    public static StringBuilder getConditionSql(StringBuilder sql, DbLinkEntity linkEntity, List<VisualColumnSearchVO> searchVOList, String mainTable) {
        boolean isOracle = DbTypeUtil.checkOracle((DataSourceMod)dataSourceModel);
        if (linkEntity != null) {
            isOracle = linkEntity.getDbType().toLowerCase().contains("oracle");
        }
        block13: for (int k = 0; k < searchVOList.size(); ++k) {
            VisualColumnSearchVO vo = searchVOList.get(k);
            String keyName = "keyName";
            String tableName = mainTable;
            if (Objects.nonNull(vo.getConfig())) {
                keyName = vo.getConfig().getKeyName();
                tableName = vo.getConfig().getTableName();
            }
            String searchType = vo.getSearchType();
            String vModel = vo.getVModel();
            String value = String.valueOf(vo.getValue());
            Boolean isMultiple = vo.getMultiple() != null ? vo.getMultiple() : false;
            if (isMultiple.booleanValue() || "checkbox".equals(keyName) || "cascader".equals(keyName) || "currOrganize".equals(keyName)) {
                searchType = "2";
                if (value.contains("[")) {
                    List mutipleList = JsonUtil.getJsonToList((String)value, String.class);
                    value = (String)mutipleList.get(mutipleList.size() - 1);
                }
            }
            if ("1".equals(searchType)) {
                sql.append("AND " + tableName + "." + vModel + " = " + "'" + value + "'");
                continue;
            }
            if ("2".equals(searchType)) {
                sql.append("AND " + tableName + "." + vModel + " like " + "'%" + value + "%'");
                continue;
            }
            if (!"3".equals(searchType)) continue;
            switch (keyName) {
                case "modifyTime": 
                case "createTime": 
                case "date": {
                    JSONArray timeStampArray = (JSONArray)vo.getValue();
                    Long o1 = (Long)timeStampArray.get(0);
                    Long o2 = (Long)timeStampArray.get(1);
                    String format = StringUtil.isEmpty((String)vo.getFormat()) ? "yyyy-MM-dd HH:mm:ss" : vo.getFormat();
                    String startTime = OnlinePublicUtils.getDateByFormat(o1, format);
                    String endTime = OnlinePublicUtils.getDateByFormat(o2, format);
                    if (!"yyyy-MM-dd HH:mm:ss".equals(format) || vo.getFormat() == null) {
                        endTime = endTime.substring(0, 10);
                    }
                    String firstTimeDate = OnlineDatabaseUtils.getTimeFormat(startTime);
                    String lastTimeDate = OnlineDatabaseUtils.getLastTimeFormat(endTime);
                    if (isOracle) {
                        sql.append("AND " + tableName + "." + vModel + " between to_date(" + "'" + firstTimeDate + "','yyyy-mm-dd hh24:mi:ss'" + ") AND to_date(" + "'" + lastTimeDate + "','yyyy-mm-dd hh24:mi:ss')");
                        continue block13;
                    }
                    sql.append("AND " + tableName + "." + vModel + " between " + "'" + firstTimeDate + "'" + "AND " + "'" + lastTimeDate + "'");
                    continue block13;
                }
                case "time": {
                    List stringList = JsonUtil.getJsonToList((String)value, String.class);
                    String format = "HH:mm:ss";
                    if (isOracle) {
                        sql.append("AND " + tableName + "." + vModel + " between to_date(" + "'" + (String)stringList.get(0) + "','" + format + "'" + ") AND to_date(" + "'" + (String)stringList.get(1) + "','" + format + "')");
                        continue block13;
                    }
                    sql.append("AND " + tableName + "." + vModel + " between " + "'" + (String)stringList.get(0) + "'" + "AND " + "'" + (String)stringList.get(1) + "'");
                    continue block13;
                }
                case "numInput": 
                case "calculate": {
                    Float firstValue = null;
                    Float secondValue = null;
                    JSONArray objects = (JSONArray)vo.getValue();
                    for (int i = 0; i < objects.size(); ++i) {
                        Object n = objects.get(i);
                        if (!ObjectUtil.isNotEmpty((Object)n)) continue;
                        if (i == 0) {
                            firstValue = Float.valueOf(Float.parseFloat(String.valueOf(n)));
                            continue;
                        }
                        secondValue = Float.valueOf(Float.parseFloat(String.valueOf(n)));
                    }
                    if (firstValue != null) {
                        sql.append("AND " + tableName + "." + vModel + " >= " + firstValue);
                    }
                    if (secondValue == null) continue block13;
                    sql.append("AND " + tableName + "." + vModel + " <= " + secondValue);
                    continue block13;
                }
            }
        }
        return sql;
    }

    public static List<OnlineColumnFieldModel> getChildValue(List<String> collect) {
        List<Object> childFieldList = new ArrayList();
        String reg = "^[jsbos_]\\S*_jsbos\\S*";
        List mainTableFields = collect.stream().filter(s -> !s.matches(reg)).collect(Collectors.toList());
        List mainList = mainTableFields.stream().map(c -> {
            OnlineColumnFieldModel fieldModel = new OnlineColumnFieldModel();
            fieldModel.setOriginallyField((String)c);
            fieldModel.setOtherName((String)c);
            return fieldModel;
        }).collect(Collectors.toList());
        childFieldList = collect.stream().filter(s -> s.matches(reg)).map(child -> {
            OnlineColumnFieldModel fieldModel = new OnlineColumnFieldModel();
            String s1 = child.substring(child.lastIndexOf("jsbos_")).replace("jsbos_", "");
            String s2 = child.substring(child.indexOf("_") + 1, child.lastIndexOf("_jsbos"));
            fieldModel.setTableName(s2);
            fieldModel.setField(s1);
            fieldModel.setOriginallyField((String)child);
            return fieldModel;
        }).collect(Collectors.toList());
        for (int i = 0; i < childFieldList.size(); ++i) {
            OnlineColumnFieldModel model = (OnlineColumnFieldModel)childFieldList.get(i);
            model.setOtherName(model.getField() + "_" + i);
        }
        childFieldList.addAll(mainList);
        return childFieldList;
    }
}

