package com.bringspring.visualdev.base.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.model.PaginationVisualdev;

import java.util.List;

/**
 *
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @author RKKJ开发平台组
 * @date 2021/3/16
 */
public interface VisualdevService extends IService<VisualdevEntity> {

    List<VisualdevEntity> getList(PaginationVisualdev paginationVisualdev);

    List<VisualdevEntity> getList();

    VisualdevEntity getInfo(String id);

    Boolean create(VisualdevEntity entity) throws WorkFlowException;

    boolean update(String id, VisualdevEntity entity) throws WorkFlowException;

    void delete(VisualdevEntity entity) throws WorkFlowException;

    /**
     * 根据encode判断是否有相同值
     * @param encode
     * @return
     */
    Long getObjByEncode (String encode, Integer type);

    /**
     * 根据name判断是否有相同值
     * @param name
     * @return
     */
    Long getCountByName (String name, Integer type);
}

