package com.bringspring.visualdev.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.model.visiual.ColumnDataModel;
import com.bringspring.common.model.visiual.ComponentKeyConsts;
import com.bringspring.common.model.visiual.OnlineDevData;
import com.bringspring.common.util.*;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.model.dataInterface.DataInterfaceActionVo;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.CacheKeyEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.MultipleControlEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineFieldsModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataInfoVO;
import com.bringspring.visualdev.onlinedev.service.VisualDevInfoService;
import com.bringspring.visualdev.onlinedev.service.VisualdevModelDataService;
import lombok.extern.slf4j.Slf4j;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/7/28
 */
@Slf4j
public class OnlineDevListUtils {
	private static RedisUtil redisUtil;
	private static DictionaryDataService dictionaryDataService;
	private static UserService userService;
	private static PositionService positionService;
	private static ProvinceService provinceService;
	private static OrganizeService organizeService;
	private static VisualdevService visualdevService;
	private static VisualdevModelDataService visualdevModelDataService;
	private static DataInterfaceService dataInterfaceService;
	private static VisualDevInfoService visualDevInfoService;

	/**
	 * 初始化bean
	 */
	public static void init() {
		visualdevModelDataService = SpringContext.getBean(VisualdevModelDataService.class);
		dictionaryDataService = SpringContext.getBean(DictionaryDataService.class);
		userService = SpringContext.getBean(UserService.class);
		positionService = SpringContext.getBean(PositionService.class);
		redisUtil = SpringContext.getBean(RedisUtil.class);
		provinceService = SpringContext.getBean(ProvinceService.class);
		organizeService = SpringContext.getBean(OrganizeService.class);
		visualdevService = SpringContext.getBean(VisualdevService.class);
		dataInterfaceService = SpringContext.getBean(DataInterfaceService.class);
		visualDevInfoService = SpringContext.getBean(VisualDevInfoService.class);
	}

	/**
	 * 查询条件
	 *
	 * @param list
	 * @param searchList
	 * @return
	 */
	public static List<OnlineDevListDataVO> getNoSwapList(List<OnlineDevListDataVO> list, List<VisualColumnSearchVO> searchList) {
		List<OnlineDevListDataVO> resultList = new ArrayList<>();
		if (searchList == null) {
			return list;
		}
		for (OnlineDevListDataVO dataVo : list) {
			int i = 0;
			for (VisualColumnSearchVO vo : searchList) {
				Object dataModel = dataVo.getData().get(vo.getVModel());
				if (dataModel == null || ObjectUtil.isEmpty(dataModel)) {
					continue;
				}
				//多选框默认添加多选属性
				if (vo.getConfig().getKeyName().equals(ComponentKeyConsts.CHECKBOX) || ComponentKeyConsts.CASCADER.equals(vo.getConfig().getKeyName())) {
					vo.setMultiple(true);
				}
				if (vo.getSearchType().equals("1")) {
					//多选框筛选
					if (vo.getMultiple() != null && vo.getMultiple() == true) {
						List<String> asList;
						if (String.valueOf(dataModel).contains("[")) {
							asList = JsonUtil.getJsonToList(String.valueOf(dataModel), String.class);
						} else {
							String[] multipleList = String.valueOf(dataModel).split(",");
							asList = Arrays.asList(multipleList);
						}
						boolean b = asList.stream().anyMatch(t -> vo.getValue().toString().contains(t));
						if (b) {
							i++;
						}
					} else {
						if (String.valueOf(vo.getValue()).equals(String.valueOf(dataModel))) {
							i++;
						}
					}
				}
				if (vo.getSearchType().equals("2")) {
					if (String.valueOf(dataModel).contains(String.valueOf(vo.getValue()))) {
						i++;
					}
				}
				if (vo.getSearchType().equals("3")) {
					String key = vo.getConfig().getKeyName();
					switch (key) {
						case ComponentKeyConsts.MODIFYTIME:
						case ComponentKeyConsts.CREATETIME:
							JSONArray timeStampArray = (JSONArray) vo.getValue();
							Long o1 = (Long) timeStampArray.get(0);
							Long o2 = (Long) timeStampArray.get(1);

							//时间戳转string格式
							String startTime = DateUtil.daFormat(o1);
							String endTime = DateUtil.daFormat(o2);
							//处理时间查询条件范围
							endTime = endTime.substring(0, 10);
							String firstTimeDate = OnlineDatabaseUtils.getTimeFormat(startTime);
							String lastTimeDate = OnlineDatabaseUtils.getLastTimeFormat(endTime);

							String value = String.valueOf(dataModel);
							if (value.contains(".")) {
								value = value.substring(0, value.lastIndexOf("."));
							}
							//只判断到日期
							SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
							try {
								boolean b = DateUtil.isEffectiveDate(sdf.parse(value), sdf.parse(firstTimeDate), sdf.parse(lastTimeDate));
								if (b) {
									i++;
								}
							} catch (ParseException e) {
								e.printStackTrace();
							}
							break;
						case ComponentKeyConsts.NUM_INPUT:
						case ComponentKeyConsts.CALCULATE:
							Float firstValue = null;
							Float secondValue = null;
							JSONArray objects = (JSONArray) vo.getValue();
							for (int k = 0; k < objects.size(); k++) {
								Object n = objects.get(k);
								if (ObjectUtil.isNotEmpty(n)) {
									if (k == 0) {
										firstValue = Float.parseFloat(String.valueOf(n));
									} else {
										secondValue = Float.parseFloat(String.valueOf(n));
									}
								}
							}
							//数据
							Float numValue = Float.parseFloat(String.valueOf(dataModel));

							//条件1,2组合的情况
							if (firstValue != null && secondValue == null) {
								if (numValue >= firstValue) {
									i++;
								}
							}
							if (firstValue != null && secondValue != null) {
								if (numValue >= firstValue && numValue <= secondValue) {
									i++;
								}
							}
							if (firstValue == null && secondValue != null) {
								if (numValue <= secondValue) {
									i++;
								}
							}
							break;
						case ComponentKeyConsts.DATE:
							String starTimeDates;
							String endTimeDates;
							if (dataModel == null) {
								break;
							}
							//时间戳
							if (!String.valueOf(vo.getValue()).contains(":") && !String.valueOf(vo.getValue()).contains("-")) {
								JSONArray DateTimeStampArray = (JSONArray) vo.getValue();
								Long d1 = (Long) DateTimeStampArray.get(0);
								Long d2 = (Long) DateTimeStampArray.get(1);
								long d1FirstTime = Long.parseLong(String.valueOf(d1));
								long d2LastTime = Long.parseLong(String.valueOf(d2));

								//时间戳转string格式
								starTimeDates = DateUtil.daFormat(d1FirstTime);
								endTimeDates = DateUtil.daFormat(d2LastTime);

							} else {
								//时间字符串
								String[] keyArray = String.valueOf(vo.getValue()).split(",");
								starTimeDates = keyArray[0];
								endTimeDates = keyArray[1];
							}
							if (vo.getFormat() == null) {
								starTimeDates = starTimeDates.substring(0, 10);
								endTimeDates = endTimeDates.substring(0, 10);
							}
							starTimeDates = OnlineDatabaseUtils.getTimeFormat(starTimeDates);
							endTimeDates = OnlineDatabaseUtils.getLastTimeFormat(endTimeDates);

							String dateValue = dataModel.toString();
							if (!dateValue.contains(":") && !dateValue.contains("-")) {
								//时间戳
								Long timeResult = (Long) dataModel;
								dateValue = DateUtil.daFormat(timeResult);
							}
							if (dateValue.contains(".")) {
								dateValue = dateValue.substring(0, dateValue.lastIndexOf("."));
							}
							dateValue = OnlineDatabaseUtils.getTimeFormat(dateValue);
							//只判断到日期
							SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
							try {
								Boolean b = DateUtil.isEffectiveDate(sdfDate.parse(dateValue), sdfDate.parse(starTimeDates), sdfDate.parse(endTimeDates));
								if (b) {
									i++;
								}
							} catch (ParseException e) {
								e.printStackTrace();
							}
							break;
						case ComponentKeyConsts.TIME:
							JSONArray timeArray = (JSONArray) vo.getValue();
							String start = String.valueOf(timeArray.get(0));
							String end = String.valueOf(timeArray.get(1));
							start = OnlineDatabaseUtils.getTimeFormat(start);
							end = OnlineDatabaseUtils.getLastTimeFormat(end);
							String timeValue = OnlineDatabaseUtils.getTimeFormat(String.valueOf(dataModel));
							SimpleDateFormat timeSim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
							try {
								boolean b = DateUtil.isEffectiveDate(timeSim.parse(timeValue), timeSim.parse(start), timeSim.parse(end));
								if (b) {
									i++;
								}
							} catch (ParseException e) {
								e.printStackTrace();
							}
							break;
						default:
							break;
					}
				}
				if (i == searchList.size()) {
					resultList.add(dataVo);
				}
			}
		}
		return resultList;
	}


	/**
	 * 数据转换
	 *
	 * @param list
	 * @param swapDataVoList
	 * @return
	 */
	public static List<OnlineDevListDataVO> getSwapList(List<OnlineDevListDataVO> list, List<OnlineFieldsModel> swapDataVoList, String visualDevId) {
		if (list.isEmpty()) {
			return list;
		}
		init();
		//预装数据后直接放入localCache 避免重新取Redis数据大量数据转换耗时
		Map<String, Object> localCache = new HashMap<>();
		Set<String> userList = new HashSet<>();
		Set<String> orgList = new HashSet<>();
		Set<String> posList = new HashSet<>();
		Set<String> allOrgList = new HashSet<>();
		localCache.put("__user_list", userList);
		localCache.put("__org_list", orgList);
		localCache.put("__pos_list", posList);
		localCache.put("__allOrg_list", allOrgList);

		//装填部分数据(用户,组织,岗位)
		pageIdList(list, swapDataVoList, localCache);

		sysNeedSwapData(swapDataVoList, visualDevId, localCache);

		//redis key
		String dsName = Optional.ofNullable(DataSourceContextHolder.getDatasourceId()).orElse("");
		//组织
		Map<String, Object> orgMap = new HashMap<>(20);
		//组织需要递归显示
		Map<String, Object> allOrgMap = new HashMap<>(20);
		//岗位
		Map<String, Object> posMap = new HashMap<>(20);
		//人员
		Map<String, Object> userMap = new HashMap<>(20);
		//省市区
		Map<String, Object> proMap = (Map<String, Object>) localCache.get(dsName + CacheKeyEnum.PRO.getName());

		for (OnlineFieldsModel swapDataVo : swapDataVoList) {
			String keyName = swapDataVo.getConfig().getKeyName();
			String vModel = swapDataVo.getVModel();
			String dataType = String.valueOf(swapDataVo.getConfig().getDataType());
			Boolean isMultiple = Objects.nonNull(swapDataVo.getMultiple()) ? swapDataVo.getMultiple() : false;
			for (OnlineDevListDataVO listVo : list) {
				try {
					Map<String, Object> dataMap = listVo.getData();
					if (StringUtils.isEmpty(String.valueOf(dataMap.get(vModel))) || dataMap.get(vModel) == null) {
						continue;
					}
					if (String.valueOf(dataMap.get(vModel)).equals("[]") || String.valueOf(dataMap.get(vModel)).equals("null")) {
						dataMap.put(vModel, null);
					} else {
						switch (keyName) {
							//公司组件
							case ComponentKeyConsts.COMSELECT:
								//部门组件
							case ComponentKeyConsts.DEPSELECT:
								//所属部门
							case ComponentKeyConsts.CURRDEPT:
								//所属组织
							case ComponentKeyConsts.CURRORGANIZE:
								if (orgMap.size() == 0) {
									List<OrganizeEntity> organizeEntityList = organizeService.getOrgEntityList(orgList);
									organizeEntityList.stream().forEach(org -> {
										orgMap.put(org.getId(), org.getFullName());
									});
									//转成json存入redis
									String orgString = JsonUtil.getObjectToString(orgMap);
									redisUtil.insert(visualDevId + CacheKeyEnum.ORG.getName(), orgString, 60 * 5);
								}

								if ("all".equals(swapDataVo.getShowLevel())) {
									//多级组织
									if (allOrgMap.size() == 0) {
										//需要递归的组织控件放入缓存中
										for (String org : allOrgList) {
											String infoByOrgId = PermissionUtil.getLinkInfoByOrgId(org, organizeService, false);
											allOrgMap.put(org, infoByOrgId);
										}
										//转成json存入redis
										String allOrgString = JsonUtil.getObjectToString(allOrgMap);
										redisUtil.insert(visualDevId + CacheKeyEnum.AllORG.getName(), allOrgString, 60 * 5);
									}
									dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(allOrgMap, dataMap.get(vModel),isMultiple));
								} else {
									dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(orgMap, dataMap.get(vModel),isMultiple));
								}
								break;

							//岗位组件
							case ComponentKeyConsts.POSSELECT:
								//所属岗位
							case ComponentKeyConsts.CURRPOSITION:
								if (posMap.size() == 0) {
									List<PositionEntity> positionList = positionService.getPositionList(posList);
									positionList.stream().forEach(positionEntity -> posMap.put(positionEntity.getId(), positionEntity.getFullName()));
									//转成json存入redis
									String posString = JsonUtil.getObjectToString(posMap);
									redisUtil.insert(visualDevId + CacheKeyEnum.POS.getName(), posString, 60 * 5);
								}
								String posData = OnlinePublicUtils.getDataInMethod(posMap, dataMap.get(vModel),isMultiple);
								dataMap.put(vModel, posData);
								break;

							//用户组件
							case ComponentKeyConsts.USERSELECT:
								//创建用户
							case ComponentKeyConsts.CREATEUSER:
								//修改用户
							case ComponentKeyConsts.MODIFYUSER:
								if (userMap.size() == 0) {
									List<UserEntity> userEntityList = userService.getUserNameList(userList);
									userEntityList.stream().forEach(userEntity -> userMap.put(userEntity.getId(), userEntity.getRealName()));
									//转成json存入redis
									String userString = JsonUtil.getObjectToString(userMap);
									redisUtil.insert(visualDevId + CacheKeyEnum.USER.getName(), userString, 60 * 5);
								}
								String userData = OnlinePublicUtils.getDataInMethod(userMap, dataMap.get(vModel),isMultiple);
								dataMap.put(vModel, userData);
								break;

							//省市区联动
							case ComponentKeyConsts.ADDRESS:
								String addressValue = String.valueOf(dataMap.get(vModel));
								if (OnlinePublicUtils.getMultiple(addressValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar())) {
									String[][] data = JsonUtil.getJsonToBean(addressValue, String[][].class);
									List<String> addList = new ArrayList<>();
									for (String[] AddressData : data) {
										List<String> adList = new ArrayList<>();
										for (String s : AddressData) {
											adList.add(String.valueOf(proMap.get(s)));
										}
										addList.add(String.join("/", adList));
									}
									dataMap.put(vModel, String.join(";", addList));
								} else if (OnlinePublicUtils.getMultiple(addressValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar())) {
									List<String> proDataS = JsonUtil.getJsonToList(String.valueOf(dataMap.get(vModel)), String.class);
									proDataS = proDataS.stream().map(pro -> String.valueOf(proMap.get(pro))).collect(Collectors.toList());
									dataMap.put(vModel, String.join("/", proDataS));
								}
								break;
							//开关
							case ComponentKeyConsts.SWITCH:
								String switchValue = String.valueOf(dataMap.get(vModel)).equals("1") ? swapDataVo.getActiveTxt() : swapDataVo.getInactiveTxt();
								dataMap.put(vModel, switchValue);
								break;
							//级联
							case ComponentKeyConsts.CASCADER:
								String redisKey;
								if (OnlineDataTypeEnum.STATIC.getType().equals(dataType)) {
									redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
								} else if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
									redisKey = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getProps().getProps().getLabel(), swapDataVo.getProps().getProps().getValue(), swapDataVo.getProps().getProps().getChildren());
								} else {
									redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType());
								}
								Map<String, Object> cascaderMap;
								if(dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())){
									List<Map<String,Object>> checkBoxList = (List<Map<String,Object>>) localCache.get(redisKey);
									cascaderMap= OnlinePublicUtils.getDataMap(checkBoxList,swapDataVo);
								}else{
									cascaderMap=(Map<String, Object>) localCache.get(redisKey);
								}
								String s1 = OnlinePublicUtils.getDataInMethod(cascaderMap, dataMap.get(vModel),isMultiple);
								dataMap.put(vModel, s1);
								break;
							case ComponentKeyConsts.CHECKBOX:
								String checkBox;
								if (OnlineDataTypeEnum.STATIC.getType().equals(dataType)) {
									checkBox = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
								} else if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
									checkBox = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl());
								} else {
									checkBox = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType());
								}
								Map<String, Object> checkboxMap;
								if(dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())){
									List<Map<String,Object>> checkBoxList = (List<Map<String,Object>>) localCache.get(checkBox);
									checkboxMap= OnlinePublicUtils.getDataMap(checkBoxList,swapDataVo);
								}else{
									checkboxMap=(Map<String, Object>) localCache.get(checkBox);
								}
								String s2 = OnlinePublicUtils.getDataInMethod(checkboxMap, dataMap.get(vModel),isMultiple);
								dataMap.put(vModel, s2);
								break;
							case ComponentKeyConsts.RELATIONFORM:
								//取关联表单数据 按绑定功能加字段区分数据
								redisKey = String.format("%s-%s-%s-%s-%s", dsName, ComponentKeyConsts.RELATIONFORM, swapDataVo.getModelId(), swapDataVo.getRelationField(), dataMap.get(vModel));
								VisualdevModelDataInfoVO infoVO = null;
								if (localCache.containsKey(redisKey) || redisUtil.exists(redisKey)) {
									if (localCache.containsKey(redisKey)) {
										infoVO = (VisualdevModelDataInfoVO) localCache.get(redisKey);
									} else {
										infoVO = JSONObject.parseObject(String.valueOf(redisUtil.getString(redisKey)), VisualdevModelDataInfoVO.class);
										localCache.put(redisKey, infoVO);
									}
								} else {
									VisualdevEntity entity = visualdevService.getInfo(swapDataVo.getModelId());
									String keyId = String.valueOf(dataMap.get(vModel));
									if (!StringUtils.isEmpty(entity.getVisualTables()) && !OnlineDevData.TABLE_CONST.equals(entity.getVisualTables())) {
										infoVO = visualDevInfoService.getDetailsDataInfo(keyId, entity);
									} else {
										infoVO = visualdevModelDataService.infoDataChange(keyId, entity);
									}
									redisUtil.insert(redisKey, infoVO, 60 * 5);
									localCache.put(redisKey, infoVO);
								}
								if (infoVO != null) {
									Map<String, Object> formDataMap = JsonUtil.stringToMap(infoVO.getData());
									String relationField = swapDataVo.getRelationField();
									if (formDataMap.size() > 0) {
										dataMap.put(vModel + "_id", dataMap.get(vModel));
										dataMap.put(vModel, formDataMap.get(relationField));
									}
								}
								break;
							case ComponentKeyConsts.POPUPSELECT:
								redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getInterfaceId());
								ActionResult data;
								if (localCache.containsKey(redisKey) || redisUtil.exists(redisKey)) {
									if (localCache.containsKey(redisKey)) {
										data = (ActionResult) localCache.get(redisKey);
									} else {
										data = JSONObject.parseObject(String.valueOf(redisUtil.getString(redisKey)), ActionResult.class);
										localCache.put(redisKey, data);
									}
								} else {
									data = dataInterfaceService.infoToId(swapDataVo.getInterfaceId());
									redisUtil.insert(redisKey, JSONObject.toJSONString(data));
									localCache.put(redisKey, data);
								}

								if (data != null && data.getData() != null) {
									List<Map<String, Object>> mapList = new ArrayList<>();
									if (data.getData() instanceof DataInterfaceActionVo) {
										DataInterfaceActionVo actionVo = (DataInterfaceActionVo) data.getData();
										if (actionVo.getData() instanceof List) {
											mapList = (List<Map<String, Object>>) actionVo.getData();
										}
									} else if (data.getData() instanceof List) {
										mapList = (List<Map<String, Object>>) data.getData();
									}else if (data.getData() instanceof JSONObject) {
										Map<String, Object> map = JsonUtil.entityToMap(data.getData());
										mapList = JsonUtil.getJsonToListMap(String.valueOf(map.get("data")));
									}
									mapList.stream().filter(map ->
											map.get(swapDataVo.getPropsValue()).equals(dataMap.get(vModel))
									)
											.forEach(modelMap ->
													dataMap.put(vModel, modelMap.get(swapDataVo.getRelationField()))
											);
								}
								break;
							case ComponentKeyConsts.MODIFYTIME:
							case ComponentKeyConsts.CREATETIME:
							case ComponentKeyConsts.DATE:
								//判断是否为时间戳格式
								String format;
								String dateData = String.valueOf(dataMap.get(vModel));
								String dateSwapInfo = swapDataVo.getFormat() != null ? swapDataVo.getFormat() : swapDataVo.getType() != null && swapDataVo.getType().equals(ComponentKeyConsts.DATE) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
								if (!dateData.contains("-") && !dateData.contains(":") && dateData.length() > 10) {
									DateTimeFormatter ftf = DateTimeFormatter.ofPattern(dateSwapInfo);
									format = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long) dataMap.get(vModel)), ZoneId.of("+8")));
								} else {
									format = dateData;
								}
								if (format.contains(".")) {
									format = format.substring(0, format.lastIndexOf("."));
								}
								SimpleDateFormat sdf = new SimpleDateFormat(dateSwapInfo);
								Date date = sdf.parse(format);
								String outTime = sdf.format(sdf.parse(DateUtil.dateFormat(date)));
								dataMap.put(vModel, outTime);
								break;
							default:
								break;
						}
						//转换数据接口的数据
						if (dataType != null) {
							if (!keyName.equals(ComponentKeyConsts.CASCADER) && !keyName.equals(ComponentKeyConsts.CHECKBOX)) {
								//静态数据
								if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
									String redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
									Map<String, Object> staticMap = (Map<String, Object>) localCache.get(redisKey);
									String s = OnlinePublicUtils.getDataInMethod(staticMap, dataMap.get(vModel),isMultiple);
									dataMap.put(vModel, s);
									//远端数据
								} else if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
									//非级联属性把上一步缓存的接口数据Key的child字段删除
									String redisKey = String.format("%s-%s-%s-%s-%s-", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getConfig().getProps().getLabel(), swapDataVo.getConfig().getProps().getValue());
									if (keyName.equals(ComponentKeyConsts.TREESELECT)) {
										//树形缓存Key
										redisKey = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getProps().getProps().getLabel(), swapDataVo.getProps().getProps().getValue(), swapDataVo.getProps().getProps().getChildren());
									}
									Map<String, Object> dynamicMap = (Map<String, Object>) localCache.get(redisKey);
									String s = OnlinePublicUtils.getDataInMethod(dynamicMap, dataMap.get(vModel),isMultiple);
									dataMap.put(vModel, s);
									//数据字典
								} else if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
									String redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType());
									Object dicObj = localCache.get(redisKey);
									List<Map<String, Object>> dictionaryList;
									if (dicObj instanceof String) {
										dictionaryList = JsonUtil.getJsonToListMap(String.valueOf(localCache.get(redisKey)));
									} else {
										dictionaryList = (List<Map<String, Object>>) dicObj;
									}
									Map<String, Object> dataInterfaceMap = OnlinePublicUtils.getDataMap(dictionaryList, swapDataVo);
									String s = OnlinePublicUtils.getDataInMethod(dataInterfaceMap, dataMap.get(vModel),isMultiple);
									dataMap.put(vModel, s);
								}
							}
						}
					}
				} catch (Exception e) {
					log.error("在线开发转换数据错误:" + e.getMessage());
				}
			}
		}

		return list;
	}

	/**
	 * 取出列表所用到的 用户 组织 岗位的id
	 *
	 * @param list           数据
	 * @param swapDataVoList 控件
	 */
	public static void pageIdList(List<OnlineDevListDataVO> list, List<OnlineFieldsModel> swapDataVoList, Map<String, Object> localCache) {
		Set<String> userList = (Set<String>) localCache.get("__user_list");
		Set<String> orgList = (Set<String>) localCache.get("__org_list");
		Set<String> posList = (Set<String>) localCache.get("__pos_list");
		Set<String> AllOrgList = (Set<String>) localCache.get("__allOrg_list");
		for (OnlineFieldsModel swapDataVo : swapDataVoList) {
			String keyName = swapDataVo.getConfig().getKeyName();
			String vModel = swapDataVo.getVModel();
			for (OnlineDevListDataVO listVo : list) {
				Map<String, Object> dataMap = listVo.getData();
				if (StringUtils.isEmpty(String.valueOf(dataMap.get(vModel))) || dataMap.get(vModel) == null) {
					continue;
				}
				if (String.valueOf(dataMap.get(vModel)).equals("[]") || String.valueOf(dataMap.get(vModel)).equals("null")) {
					continue;
				} else {
					switch (keyName) {
						//公司组件
						case ComponentKeyConsts.COMSELECT:
							//部门组件
						case ComponentKeyConsts.DEPSELECT:
							//所属部门
						case ComponentKeyConsts.CURRDEPT:
							//所属公司
						case ComponentKeyConsts.CURRORGANIZE:
							if ("all".equals(swapDataVo.getShowLevel())) {
								getIdInMethod(AllOrgList, dataMap.get(vModel));
							} else {
								getIdInMethod(orgList, dataMap.get(vModel));
							}
							break;

						//岗位组件
						case ComponentKeyConsts.POSSELECT:
							//所属岗位
						case ComponentKeyConsts.CURRPOSITION:
							getIdInMethod(posList, dataMap.get(vModel));
							break;

						//用户组件
						case ComponentKeyConsts.USERSELECT:
							//创建用户
						case ComponentKeyConsts.CREATEUSER:
							//修改用户
						case ComponentKeyConsts.MODIFYUSER:
							getIdInMethod(userList, dataMap.get(vModel));
							break;
						default:
							break;
					}
				}
			}
		}
	}

	/**
	 * 存取对应id集合
	 *
	 * @param idList
	 * @param modelData
	 * @return
	 */
	public static Collection<String> getIdInMethod(Collection<String> idList, Object modelData) {
		if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar())) {
			String[][] data = JsonUtil.getJsonToBean(String.valueOf(modelData), String[][].class);
			for (String[] AddressData : data) {
				for (String s : AddressData) {
					idList.add(s);
				}
			}
		} else if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar())) {
			idList.addAll(JsonUtil.getJsonToList(String.valueOf(modelData), String.class));
		} else {
			String[] modelDatas = String.valueOf(modelData).split(",");
			for (int i = 0; i < modelDatas.length; i++) {
				idList.add(modelDatas[i]);
			}
		}
		return idList;
	}

	/**
	 * 保存需要转换的数据到redis(系统控件)
	 *
	 * @param swapDataVoList
	 */
	public static void sysNeedSwapData(List<OnlineFieldsModel> swapDataVoList, String visualDevId, Map<String, Object> localCache) {
		init();

		//公共数据
		String dsName = Optional.ofNullable(DataSourceContextHolder.getDatasourceId()).orElse("");

		String redisKey;
		try {
			for (OnlineFieldsModel swapDataVo : swapDataVoList) {
				String keyName = swapDataVo.getConfig().getKeyName();
				String dataType = swapDataVo.getConfig().getDataType();
				switch (keyName) {
					//省市区联动
					case ComponentKeyConsts.ADDRESS:
						redisKey = dsName + CacheKeyEnum.PRO.getName();
						if (!redisUtil.exists(dsName + CacheKeyEnum.PRO.getName())) {
							List<ProvinceEntity> provinceEntityList = provinceService.getAllProList();
							Map<String, String> provinceMap = new HashMap<>(16);
							provinceEntityList.stream().forEach(p -> provinceMap.put(p.getId(), p.getFullName()));
							redisUtil.insert(redisKey, provinceMap, RedisUtil.CAHCEWEEK);
						}
						if (!localCache.containsKey(redisKey)) {
							localCache.put(redisKey, redisUtil.getMap(redisKey));
						}
						break;
					default:
						break;
				}
				if (dataType != null) {
					//数据接口的数据存放
					String label;
					String value;
					String children = "";
					List<Map<String, Object>> options = new ArrayList<>();
					if (swapDataVo.getConfig().getKeyName().equals(ComponentKeyConsts.CASCADER) || swapDataVo.getConfig().getKeyName().equals(ComponentKeyConsts.TREESELECT)) {
						label = swapDataVo.getProps().getProps().getLabel();
						value = swapDataVo.getProps().getProps().getValue();
						children = swapDataVo.getProps().getProps().getChildren();
					} else {
						label = swapDataVo.getConfig().getProps().getLabel();
						value = swapDataVo.getConfig().getProps().getValue();
					}

					Map<String, String> dataInterfaceMap = new HashMap<>(16);

					//静态数据
					if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
						redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
						if (!redisUtil.exists(redisKey)) {
							if (swapDataVo.getOptions() != null) {
								options = JsonUtil.getJsonToListMap(swapDataVo.getOptions());
								String Children = swapDataVo.getProps().getProps().getChildren();
								JSONArray data = JsonUtil.getListToJsonArray(options);
								getOptions(label, value, Children, data, options);
							} else {
								options = swapDataVo.getSlot().getOptions();
							}
							options.stream().forEach(o -> {
								dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label)));
							});
							String staticData = JsonUtil.getObjectToString(dataInterfaceMap);
							redisUtil.insert(redisKey, staticData, 60 * 5);
							if (!localCache.containsKey(redisKey)) {
								localCache.put(redisKey, dataInterfaceMap);
							}
						} else {
							if (!localCache.containsKey(redisKey)) {
								String staticDataString = redisUtil.getString(redisKey).toString();
								localCache.put(redisKey, JsonUtil.stringToMap(staticDataString));
							}
						}
					}
					//远端数据
					if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
						redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl());
						String redisKey2 = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), label, value, children);
						if (!redisUtil.exists(redisKey2)) {
							ActionResult data = null;
							if (!redisUtil.exists(redisKey)) {
								data = dataInterfaceService.infoToId(swapDataVo.getConfig().getPropsUrl());
								//缓存接口全部数据
								redisUtil.insert(redisKey, JSONObject.toJSONString(data), 60 * 5);
							} else {
								data = JSONObject.parseObject(String.valueOf(redisUtil.getString(redisKey)), ActionResult.class);
							}
							if (!localCache.containsKey(redisKey)) {
								localCache.put(redisKey, data);
							}
							if (data != null && data.getData() != null) {
								List<Map<String, Object>> dataList = new ArrayList<>();
								if (data.getData() instanceof DataInterfaceActionVo) {
									DataInterfaceActionVo actionVo = (DataInterfaceActionVo) data.getData();
									if (actionVo.getData() instanceof List) {
										dataList = (List<Map<String, Object>>) actionVo.getData();
									}
								} else if (data.getData() instanceof List) {
									dataList = (List<Map<String, Object>>) data.getData();
								}
								JSONArray dataAll = JsonUtil.getListToJsonArray(dataList);
								treeToList(label, value, children, dataAll, options);
								options.stream().forEach(o -> {
									dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label)));
								});

								//缓存接口根据特定字段转换后的全部数据
								String dynamicData = JsonUtil.getObjectToString(dataInterfaceMap);
								redisUtil.insert(redisKey2, dynamicData, 60 * 5);
								localCache.put(redisKey2, dataInterfaceMap);
							}
						} else {
							if (!localCache.containsKey(redisKey)) {
								localCache.put(redisKey, JSONObject.parseObject(String.valueOf(redisUtil.getString(redisKey)), ActionResult.class));
							}
							if (!localCache.containsKey(redisKey2)) {
								//转成map格式
								String dynamicString = redisUtil.getString(redisKey2).toString();
								localCache.put(redisKey2, JsonUtil.stringToMap(dynamicString));
							}
						}
					}
					//数据字典
					if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
						redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType());
						if (!redisUtil.exists(redisKey)) {
							List<DictionaryDataEntity> list = dictionaryDataService.getDicList(swapDataVo.getConfig().getDictionaryType());
							options = list.stream().map(dic -> {
								Map<String, Object> dictionaryMap = new HashMap<>(16);
								dictionaryMap.put("id", dic.getId());
								dictionaryMap.put("enCode", dic.getEnCode());
								dictionaryMap.put("fullName", dic.getFullName());
								return dictionaryMap;
							}).collect(Collectors.toList());

							String dictionaryData = JsonUtil.getObjectToString(options);
							redisUtil.insert(redisKey, dictionaryData, 60 * 5);
							localCache.put(redisKey, options);
						} else {
							if (!localCache.containsKey(redisKey)) {
								String dictionaryStringData = redisUtil.getString(redisKey).toString();
								localCache.put(redisKey, JsonUtil.getJsonToListMap(dictionaryStringData));
							}
						}
					}
				}
			}
		} catch (Exception e) {
			log.error("在线开发转换数据异常:" + e.getMessage());
			e.printStackTrace();
		}


	}

	/**
	 * 递归查询
	 *
	 * @param label
	 * @param value
	 * @param Children
	 * @param data
	 * @param options
	 */
	public static void getOptions(String label, String value, String Children, JSONArray data, List<Map<String, Object>> options) {
		for (int i = 0; i < data.size(); i++) {
			JSONObject ob = data.getJSONObject(i);
			Map<String, Object> tree = new HashMap<>(16);
			tree.put(value, String.valueOf(ob.get(value)));
			tree.put(label, String.valueOf(ob.get(label)));
			options.add(tree);
			if (ob.get(Children) != null) {
				JSONArray childrenArray = ob.getJSONArray(Children);
				getOptions(label, value, Children, childrenArray, options);
			}
		}
	}

	/**
	 * 分组页面
	 *
	 * @param realList
	 * @param columnDataModel
	 * @return
	 */
	public static List<Map<String, Object>> groupData(List<Map<String, Object>> realList, ColumnDataModel columnDataModel) {
		List<Map<String, Object>> columnList = JsonUtil.getJsonToListMap(columnDataModel.getColumnList());
		String firstField;
		String groupField = columnDataModel.getGroupField();
		Map<String, Object> map = columnList.stream().filter(t -> !String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).findFirst().orElse(null);
		if (map == null) {
			map = columnList.stream().filter(t -> String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).findFirst().orElse(null);
		}
		firstField = String.valueOf(map.get("prop"));

		Map<String, List<Map<String, Object>>> twoMap = new HashMap<>(16);

		for (Map<String, Object> realMap : realList) {
			String value = String.valueOf(realMap.get(groupField));
			boolean isKey = twoMap.get(value) != null;
			if (isKey) {
				List<Map<String, Object>> maps = twoMap.get(value);
				maps.add(realMap);
				twoMap.put(value, maps);
			} else {
				List<Map<String, Object>> childrenList = new ArrayList<>();
				childrenList.add(realMap);
				twoMap.put(value, childrenList);
			}
		}

		List<Map<String, Object>> resultList = new ArrayList<>();
		for (String key : twoMap.keySet()) {
			Map<String, Object> thirdMap = new HashMap<>(16);
			thirdMap.put(firstField, !key.equals("null") ? key : "");
			thirdMap.put("top", true);
			thirdMap.put("id", RandomUtil.uuId());
			thirdMap.put("children", twoMap.get(key));
			resultList.add(thirdMap);
		}
		return resultList;
	}

	/**
	 * 级联递归
	 *
	 * @param value
	 * @param label
	 * @param children
	 * @param data
	 * @param result
	 */
	private static void treeToList(String value, String label, String children, JSONArray data, List<Map<String, Object>> result) {
		for (int i = 0; i < data.size(); i++) {
			JSONObject ob = data.getJSONObject(i);
			Map<String, Object> tree = new HashMap<>(16);
			tree.put(value, String.valueOf(ob.get(value)));
			tree.put(label, String.valueOf(ob.get(label)));
			result.add(tree);
			if (ob.get(children) != null) {
				JSONArray childArray = ob.getJSONArray(children);
				treeToList(value, label, children, childArray, result);
			}
		}
	}

}
