/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.portal.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.portal.entity.PortalEntity;
import com.bringspring.visualdev.portal.mapper.PortalMapper;
import com.bringspring.visualdev.portal.model.PortalPagination;
import com.bringspring.visualdev.portal.model.PortalSelectModel;
import com.bringspring.visualdev.portal.service.PortalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortalServiceImpl
extends ServiceImpl<PortalMapper, PortalEntity>
implements PortalService {
    @Autowired
    private PortalService portalService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RoleService roleService;

    @Override
    public List<PortalEntity> getList(PortalPagination portalPagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)portalPagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(PortalEntity::getFullName, (Object)portalPagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)portalPagination.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(PortalEntity::getCategory, (Object)portalPagination.getCategory());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PortalEntity::getSortCode)).orderByDesc(PortalEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PortalEntity::getLastModifyTime);
        }
        Page page = new Page(portalPagination.getCurrentPage(), portalPagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return portalPagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<PortalEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PortalEntity::getSortCode)).orderByDesc(PortalEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<PortalEntity> getListAll(String enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PortalEntity::getEnabledMark, (Object)Integer.parseInt(enabledMark));
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PortalEntity::getSortCode)).orderByDesc(PortalEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public PortalEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PortalEntity::getId, (Object)id);
        return (PortalEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(PortalEntity entity) {
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, PortalEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(PortalEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<PortalSelectModel> getList(String type) {
        List<PortalEntity> list = this.portalService.getListAll("1");
        UserInfo userInfo = this.userProvider.get();
        if ("1".equals(type) && userInfo != null && !userInfo.getIsAdministrator().booleanValue()) {
            List roleIds = CollectionUtil.list((boolean)false);
            List listByUserId = this.roleService.getListByUserId(userInfo.getUserId());
            if (CollectionUtil.isNotEmpty((Collection)listByUserId)) {
                roleIds = listByUserId.stream().map(PermissionEntityBase::getId).collect(Collectors.toList());
            }
            ArrayList<String> itemIds = new ArrayList<String>();
            HashSet<String> set = new HashSet<String>(16);
            ArrayList<PortalEntity> newPortalList = new ArrayList<PortalEntity>();
            for (String ids : roleIds) {
                List authorizeEntityList = this.authorizeService.getListByObjectId(ids, "portal");
                for (AuthorizeEntity authorizeEntity : authorizeEntityList) {
                    itemIds.add(authorizeEntity.getItemId());
                }
            }
            set.addAll(itemIds);
            for (PortalEntity entity : list) {
                for (String iid : set) {
                    if (!iid.equals(entity.getId())) continue;
                    newPortalList.add(entity);
                }
            }
            list = newPortalList;
        }
        List modelList = JsonUtil.getJsonToList(list, PortalSelectModel.class);
        List entityList = this.dictionaryDataService.getList(DictionaryDataEnum.VISUALDEV_PORTAL.getDictionaryTypeId());
        for (DictionaryDataEntity dataEntity : entityList) {
            List num = list.stream().filter(t -> dataEntity.getId().equals(t.getCategory())).collect(Collectors.toList());
            if (num.size() <= 0) continue;
            PortalSelectModel model = new PortalSelectModel();
            model.setId(dataEntity.getId());
            model.setFullName(dataEntity.getFullName());
            model.setParentId("0");
            model.setEnCode(dataEntity.getEnCode());
            if (modelList.contains((Object)model)) continue;
            modelList.add(model);
        }
        return modelList;
    }
}

