package com.bringspring.visualdev.onlinedev.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.FormMastTableModel;
import com.bringspring.common.model.FormModel;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.props.PropsBeanModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.util.VisualUtils;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataInfoVO;
import com.bringspring.visualdev.onlinedev.service.VisualDevInfoService;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevInfoUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import lombok.Cleanup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;


/**
 *
 *
 * @author RKKJ开发平台组
 * @version V3.2
 * @copyright 荣科科技股份有限公司
 * @date  2021/10/26
 */
@Service
public class VisualDevInfoServiceImpl implements VisualDevInfoService {

	@Autowired
	private DblinkService dblinkService;
	@Override
	public VisualdevModelDataInfoVO getEditDataInfo(String id, VisualdevEntity visualdevEntity) {

		Map<String,Object> allDataMap = new HashMap<>();
		FormDataModel formData = JsonUtil.getJsonToBean(visualdevEntity.getFormData(), FormDataModel.class);
		List<FieLdsModel> list = JsonUtil.getJsonToList(formData.getFields(), FieLdsModel.class);
		List<TableModel> tableModelList = JsonUtil.getJsonToList(visualdevEntity.getVisualTables(),TableModel.class);
		RecursionForm recursionForm =new RecursionForm();
		recursionForm.setList(list);
		recursionForm.setTableModelList(tableModelList);
		List<FormAllModel> formAllModel = new ArrayList<>();
		FormCloumnUtil.recursionForm(recursionForm, formAllModel);
		//form的属性
		List<FormAllModel> mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		List<FormAllModel> table = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		List<FormAllModel> mastTable = formAllModel.stream().filter(t-> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.toList());

		TableModel mainTable = tableModelList.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);

		DbLinkEntity linkEntity = dblinkService.getInfo(visualdevEntity.getDbLinkId());
		try {
			@Cleanup Connection conn = VisualUtils.getDataConn(linkEntity);
			//获取主键
			String pKeyName = VisualUtils.getpKey(conn, mainTable.getTable());
			//主表所有数据
			String mainAllTableSql = "select *" +  " from "+ mainTable.getTable() + " where " + pKeyName + "=?";
			Map<String, Object> mainAllMap = JdbcUtil.queryOne(new PreparedStatementDTO(conn,mainAllTableSql,id));
			//主表
			String mainTableFields = mast.stream().filter(m -> StringUtils.isNotEmpty(m.getFormColumnModel().getFieLdsModel().getVModel()))
					.map(s -> s.getFormColumnModel().getFieLdsModel().getVModel()).collect(Collectors.joining(","));
			String mainTableSql = "select " +mainTableFields+  " from "+ mainTable.getTable() + " where " + pKeyName + "=?";
			Map<String, Object> mainMap = JdbcUtil.queryOne(new PreparedStatementDTO(conn,mainTableSql,id));
			if (ObjectUtil.isNotEmpty(mainMap)){
				//转换主表里的数据
				List<FieLdsModel> mainFieldList = mast.stream().filter(m -> StringUtils.isNotEmpty(m.getFormColumnModel().getFieLdsModel().getVModel()))
						.map(t -> t.getFormColumnModel().getFieLdsModel()).collect(Collectors.toList());
				mainMap = OnlineDevInfoUtils.swapDataInfoType(mainFieldList, mainMap);
				allDataMap.putAll(mainMap);

			}

			//列表子表
			Map<String, List<FormMastTableModel>> groupByTableNames = mastTable.stream().map(mt -> mt.getFormMastTableModel()).collect(Collectors.groupingBy(ma -> ma.getTable()));
			Iterator<Map.Entry<String, List<FormMastTableModel>>> entryIterator = groupByTableNames.entrySet().iterator();
			while (entryIterator.hasNext()){
				Map.Entry<String, List<FormMastTableModel>> next = entryIterator.next();
				String childTableName =  next.getKey();
				List<FormMastTableModel> childMastTableList = next.getValue();
				TableModel childTableModel = tableModelList.stream().filter(t -> t.getTable().equals(childTableName)).findFirst().orElse(null);
				String childFields =childMastTableList.stream().filter(m-> StringUtils.isNotEmpty(m.getField())).map(m -> m.getField()).collect(Collectors.joining(","));
				String relationValue = String.valueOf(OnlinePublicUtils.mapKeyToLower(mainAllMap).get(childTableModel.getRelationField().toLowerCase()));
				String childSql = "select " +  childFields + " from "+ childTableName + " where " + childTableModel.getTableField() + "=?";
				Map<String, Object> soloDataMap =JdbcUtil.queryOne(new PreparedStatementDTO(conn,childSql,relationValue));
				if (ObjectUtil.isNotEmpty(soloDataMap)){
					Map<String, Object> renameKeyMap = new HashMap<>();
					for (Map.Entry entry : soloDataMap.entrySet()){
						FormMastTableModel model = childMastTableList.stream().filter(child -> child.getField().equalsIgnoreCase(String.valueOf(entry.getKey()))).findFirst().orElse(null);
						renameKeyMap.put(model.getVModel(),entry.getValue());
					}
					List<FieLdsModel> columnChildFields = childMastTableList.stream().map(cl -> cl.getMastTable().getFieLdsModel()).collect(Collectors.toList());
					renameKeyMap =OnlineDevInfoUtils.swapDataInfoType(columnChildFields,renameKeyMap);
					allDataMap.putAll(renameKeyMap);
				}
			}

			//设计子表
			table.stream().map(t->t.getChildList()).forEach(
					t1->{
						 String childTableName = t1.getTableName();
						TableModel tableModel = tableModelList.stream().filter(tm -> tm.getTable().equals(childTableName)).findFirst().orElse(null);
						String childFields = t1.getChildList().stream().filter(t2 -> StringUtils.isNotEmpty(t2.getFieLdsModel().getVModel()))
								.map(t2 -> t2.getFieLdsModel().getVModel()).collect(Collectors.joining(","));
						String relationValue = String.valueOf(OnlinePublicUtils.mapKeyToLower(mainAllMap).get(tableModel.getRelationField().toLowerCase()));
						String childSql = "select " +  childFields + " from "+ childTableName + " where " + tableModel.getTableField() + "=?";
						try {
							List<Map<String, Object>> childMapList = JdbcUtil.queryList(new PreparedStatementDTO(conn,childSql,relationValue));
							if (ObjectUtil.isNotEmpty(childMapList)){
								List<FieLdsModel> childFieldModels = t1.getChildList().stream().map(t2 -> t2.getFieLdsModel()).collect(Collectors.toList());
								childMapList=childMapList.stream().map(c1-> {
									try {
										return OnlineDevInfoUtils.swapDataInfoType(childFieldModels,c1);
									} catch (Exception e) {
										e.printStackTrace();
									}
									return c1;
								}).collect(Collectors.toList());
								Map<String, Object> childMap = new HashMap<>(1);
								childMap.put(t1.getTableModel(),childMapList);
								allDataMap.putAll(childMap);
							}
						} catch (DataException e) {
							e.printStackTrace();
						}
					}
			);
		} catch (SQLException | DataException  sqlException) {
			sqlException.printStackTrace();
		}
		VisualdevModelDataInfoVO vo = new VisualdevModelDataInfoVO();
		vo.setId(id);
		vo.setData(JsonUtilEx.getObjectToString(allDataMap));
		return vo;
	}

	@Override
	public VisualdevModelDataInfoVO getDetailsDataInfo(String id, VisualdevEntity visualdevEntity) {
		Map<String,Object> allDataMap = new HashMap<>();
		FormDataModel formData = JsonUtil.getJsonToBean(visualdevEntity.getFormData(), FormDataModel.class);
		List<FieLdsModel> list = JsonUtil.getJsonToList(formData.getFields(), FieLdsModel.class);
		List<TableModel> tableModelList = JsonUtil.getJsonToList(visualdevEntity.getVisualTables(),TableModel.class);
		RecursionForm recursionForm =new RecursionForm();
		recursionForm.setList(list);
		recursionForm.setTableModelList(tableModelList);
		List<FormAllModel> formAllModel = new ArrayList<>();
		FormCloumnUtil.recursionForm(recursionForm, formAllModel);
		//form的属性
		List<FormAllModel> mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		List<FormAllModel> table = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		List<FormAllModel> mastTable = formAllModel.stream().filter(t-> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		List<FormModel> codeList = formAllModel.stream().filter(t -> t.getKeyName().equals(FormEnum.BARCODE.getMessage())
																|| t.getKeyName().equals(FormEnum.QR_CODE.getMessage())).map(formModel -> formModel.getFormModel()).collect(Collectors.toList());

		TableModel mainTable = tableModelList.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);

		DbLinkEntity linkEntity = dblinkService.getInfo(visualdevEntity.getDbLinkId());
		try {
			@Cleanup Connection conn = VisualUtils.getDataConn(linkEntity);
			//获取主键
			String pKeyName = VisualUtils.getpKey(conn, mainTable.getTable());
			//主表所有数据
			String mainAllTableSql = "select *" +  " from "+ mainTable.getTable() + " where " + pKeyName + "= ?";
			Map<String, Object> mainAllMap = JdbcUtil.queryOne(new PreparedStatementDTO(conn,mainAllTableSql,id));
			//主表
			String mainTableFields = mast.stream().filter(m -> StringUtils.isNotEmpty(m.getFormColumnModel().getFieLdsModel().getVModel()))
					.map(s -> s.getFormColumnModel().getFieLdsModel().getVModel()).collect(Collectors.joining(","));
			String mainTableSql = "select " +mainTableFields+  " from "+ mainTable.getTable() + " where " + pKeyName + "= ?";
			Map<String, Object> mainMap = JdbcUtil.queryOne(new PreparedStatementDTO(conn,mainTableSql,id));
			//转换主表里的数据
			List<FieLdsModel> mainFieldList = mast.stream().filter(m -> StringUtils.isNotEmpty(m.getFormColumnModel().getFieLdsModel().getVModel()))
					.map(t -> t.getFormColumnModel().getFieLdsModel()).collect(Collectors.toList());
			mainFieldList=	mainFieldList.stream().map(fieLdsModel -> {
				if(ObjectUtil.isNotEmpty(fieLdsModel.getProps())){
					if (StringUtils.isNotEmpty(fieLdsModel.getProps().getProps())){
						PropsBeanModel propsBeanModel = JsonUtil.getJsonToBean(fieLdsModel.getProps().getProps(), PropsBeanModel.class);
						fieLdsModel.getProps().setPropsModel(propsBeanModel);
					}
				}
				return fieLdsModel;
			}).collect(Collectors.toList());
			if (ObjectUtil.isNotEmpty(mainMap)){
				mainMap=OnlineDevInfoUtils.swapTableDataInfo(mainFieldList,mainMap,visualdevEntity.getId(),codeList);
				allDataMap.putAll(mainMap);
			}

			//列表子表
			Map<String, List<FormMastTableModel>> groupByTableNames = mastTable.stream().map(mt -> mt.getFormMastTableModel()).collect(Collectors.groupingBy(ma -> ma.getTable()));
			Iterator<Map.Entry<String, List<FormMastTableModel>>> entryIterator = groupByTableNames.entrySet().iterator();
			while (entryIterator.hasNext()){
				Map.Entry<String, List<FormMastTableModel>> next = entryIterator.next();
				String childTableName =  next.getKey();
				List<FormMastTableModel> childMastTableList = next.getValue();
				TableModel childTableModel = tableModelList.stream().filter(t -> t.getTable().equals(childTableName)).findFirst().orElse(null);
				String childFields =childMastTableList.stream().filter(m -> StringUtils.isNotEmpty(m.getField())).map(m -> m.getField()).collect(Collectors.joining(","));
				String relationValue = String.valueOf(OnlinePublicUtils.mapKeyToLower(mainAllMap).get(childTableModel.getRelationField().toLowerCase()));
				String childSql = "select " +  childFields + " from "+ childTableName + " where " + childTableModel.getTableField() + "= ?";
				Map<String, Object> soloDataMap =JdbcUtil.queryOne(new PreparedStatementDTO(conn,childSql,relationValue));
				if (ObjectUtil.isNotEmpty(soloDataMap)){
					Map<String, Object> renameKeyMap = new HashMap<>();
					for (Map.Entry entry : soloDataMap.entrySet()){
						FormMastTableModel model = childMastTableList.stream().filter(child -> child.getField().equalsIgnoreCase(String.valueOf(entry.getKey()))).findFirst().orElse(null);
						renameKeyMap.put(model.getVModel(),entry.getValue());
					}
					List<FieLdsModel> columnChildFields = childMastTableList.stream().map(cl -> cl.getMastTable().getFieLdsModel()).collect(Collectors.toList());
					columnChildFields=	columnChildFields.stream().map(fieLdsModel -> {
						if(ObjectUtil.isNotEmpty(fieLdsModel.getProps())){
							if (StringUtils.isNotEmpty(fieLdsModel.getProps().getProps())){
								PropsBeanModel propsBeanModel = JsonUtil.getJsonToBean(fieLdsModel.getProps().getProps(), PropsBeanModel.class);
								fieLdsModel.getProps().setPropsModel(propsBeanModel);
							}
						}
						return fieLdsModel;
					}).collect(Collectors.toList());
					renameKeyMap=OnlineDevInfoUtils.swapChildTableDataInfo(columnChildFields,renameKeyMap,codeList);
					allDataMap.putAll(renameKeyMap);
				}
			}

			//设计子表
			table.stream().map(t->t.getChildList()).forEach(
					t1->{
						String childTableName = t1.getTableName();
						TableModel tableModel = tableModelList.stream().filter(tm -> tm.getTable().equals(childTableName)).findFirst().orElse(null);
						String childFields = t1.getChildList().stream().filter(t2-> StringUtils.isNotEmpty(t2.getFieLdsModel().getVModel())).map(t2 -> t2.getFieLdsModel().getVModel()).collect(Collectors.joining(","));
						String relationValue = String.valueOf(OnlinePublicUtils.mapKeyToLower(mainAllMap).get(tableModel.getRelationField().toLowerCase()));
						String childSql = "select " +  childFields + " from "+ childTableName + " where " + tableModel.getTableField() + "=?";
						try {
							List<Map<String, Object>> childMapList = JdbcUtil.queryList(new PreparedStatementDTO(conn,childSql,relationValue));
							if (ObjectUtil.isNotEmpty(childMapList)){
								List<FieLdsModel> childFieldModels = t1.getChildList().stream().map(t2 -> t2.getFieLdsModel()).collect(Collectors.toList());
								List<Map<String, Object>> finalChildMapList = new ArrayList<>();
								for (Map<String, Object> map :childMapList){
									finalChildMapList.add(OnlineDevInfoUtils.swapChildTableDataInfo(childFieldModels,map,codeList));
								}
								Map<String, Object> childMap = new HashMap<>(1);
								childMap.put(t1.getTableModel(),finalChildMapList);
								allDataMap.putAll(childMap);
							}
						} catch (DataException e) {
							e.printStackTrace();
						}
					}
			);
		} catch (SQLException | DataException  sqlException) {
			sqlException.printStackTrace();
		}
		VisualdevModelDataInfoVO vo = new VisualdevModelDataInfoVO();
		vo.setId(id);
		vo.setData(JsonUtilEx.getObjectToString(allDataMap));
		return vo;
	}
}
