package com.bringspring.visualdev.onlinedev.util;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.model.visiual.ComponentKeyConsts;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 处理自动生成字段
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-03-15
 */
public class AutoFeildsUtil {
    private static OrganizeService organizeService;
    private static UserService userService;
    private static PositionService positionService;


    //初始化
    public static void init() {
        userService = SpringContext.getBean(UserService.class);
        organizeService = SpringContext.getBean(OrganizeService.class);
        positionService=SpringContext.getBean(PositionService.class);
    }

    /**
     * 列表系统自动生成字段转换
     *
     * @return String
     */
    public static String autoFeilds(List<FieLdsModel> fieLdsModelList, String data) {
        init();
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            Map<String, Object> dataMap = JsonUtil.stringToMap(data);
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                if (fieLdsModel.getVModel().equals(entry.getKey())) {
                    String keyNameType = fieLdsModel.getConfig().getKeyName();
                    switch (keyNameType) {
                        case ComponentKeyConsts.CURRORGANIZE:
                        case ComponentKeyConsts.CURRDEPT:
                            List<OrganizeEntity> orgMapList = organizeService.getOrgRedisList();
                            for (OrganizeEntity organizeEntity : orgMapList) {
                                if (String.valueOf(entry.getValue()).equals(organizeEntity.getId())) {
                                    if("all".equals(fieLdsModel.getShowLevel())){
                                        entry.setValue(PermissionUtil.getLinkInfoByOrgId(organizeEntity.getId(), organizeService, false));
                                    }else {
                                        entry.setValue(organizeEntity.getFullName());
                                    }
                                }
                            }
                            break;
                        case ComponentKeyConsts.CREATEUSER:
                        case ComponentKeyConsts.MODIFYUSER:
                            UserEntity userCreEntity = userService.getInfo(String.valueOf(entry.getValue()));
                            if (userCreEntity != null) {
                                entry.setValue(userCreEntity.getRealName());
                            }
                            break;
                        case ComponentKeyConsts.CURRPOSITION:
                            String[] curPos = String.valueOf(entry.getValue()).split(",");
                            List<String> curPosList = new ArrayList<>();
                            for (String pos : curPos){
                                PositionEntity posEntity = positionService.getInfo(pos);
                                String posName = Objects.nonNull(posEntity) ? posEntity.getFullName() : "";
                                curPosList.add(posName);
                            }
                            entry.setValue(curPosList.stream().collect(Collectors.joining(",")));
                            break;
                        case ComponentKeyConsts.CREATETIME:
                        case ComponentKeyConsts.MODIFYTIME:
                            if (ObjectUtil.isNotEmpty(entry.getValue())){
                                String dateStr=String.valueOf(entry.getValue());
                                dateStr=dateStr.length()>19?dateStr.substring(0,19):dateStr;
                                entry.setValue(dateStr);
                            }else {
                                entry.setValue(null);
                            }
                            break;
                        default:
                    }
                }
            }
            data = JsonUtilEx.getObjectToString(dataMap);
        }
        return data;
    }


}
