package com.bringspring.visualdev.aop;

import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

/**
 * 可视化开发缓存数据处理
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 17:12
 */
@Slf4j
@Aspect
@Component
public class VisiualOpaAspect {
    @Autowired
    UserProvider userProvider;
    @Autowired
    private CacheUtil cacheUtil;

    @Pointcut("(execution(* com.bringspring.visualdev.onlinedev.controller.VisualdevModelDataController.*(..))) || " +
            "execution(* com.bringspring.visualdev.onlinedev.controller.VisualdevModelAppController.*(..)))" +
            "|| execution(* com.bringspring.visualdev.generater.controller.VisualdevGenController.*(..)))")
    public void visiualOpa() {

    }

    @After("visiualOpa()")
    public void doAroundService() {
        String method = ServletUtils.getRequest().getMethod().toLowerCase();
        if ("put".equals(method) || "delete".equals(method) || "post".equals(method)) {
            Set<String> allKey = new HashSet<>(16);
            allKey.addAll(cacheUtil.getAllVisiualKeys());
            for (String key : allKey) {
                cacheUtil.remove(key);
            }
        }
    }
}
