package com.bringspring.visualdev.generater.factory;

import com.bringspring.visualdev.generater.model.TemplateMethodEnum;
import com.bringspring.visualdev.generater.util.common.CodeGenerateUtil;
import com.bringspring.visualdev.generater.util.functionForm.FormListUtil;
import com.bringspring.visualdev.generater.util.functionForm.FormUtil;
import com.bringspring.visualdev.generater.util.functionForm.FunctionFlowUtil;
import org.springframework.stereotype.Component;

/**
 * 代码生成工厂类
 *
 * @author RKKJ开发平台组
 * @version V3.2
 * @copyright 荣科科技股份有限公司
 * @date  2021/10/8
 */
@Component
public class CodeGenerateFactory {

	/**
	 * 根据模板路径对应实体
	 * @param templateMethod
	 * @return
	 */
	public CodeGenerateUtil getGenerator(String templateMethod){
		if (templateMethod.equals(TemplateMethodEnum.T2.getMethod())){
			return  FormListUtil.getFormListUtil();
		}else if (templateMethod.equals(TemplateMethodEnum.T4.getMethod())){
			return  FormUtil.getFormUtil();
		}else if (templateMethod.equals(TemplateMethodEnum.T3.getMethod())){
			return  FunctionFlowUtil.getFunctionFlowUtil();
		}else {
			return null;
		}
	}
}
