package com.bringspring.visualdev.generater.util.common;

import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.model.visiual.DownloadCodeForm;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.visualdev.base.entity.VisualdevEntity;

import java.sql.SQLException;

/**
 * 代码生成实现接口
 *
 * @author RKKJ开发平台组
 * @version V3.2
 * @copyright 荣科科技股份有限公司
 * @date  2021/10/8
 */
public interface CodeGenerateUtil {
	/**
	 * 生成前端页面
	 *
	 * @param fileName
	 * @param entity
	 * @param downloadCodeForm
	 * @param model
	 * @param templatePath
	 * @param userInfo
	 * @param configValueUtil
	 * @param pKeyName
	 */
	 void htmlTemplates(String fileName, VisualdevEntity entity, DownloadCodeForm downloadCodeForm, FormDataModel model, String templatePath, UserInfo userInfo, ConfigValueUtil configValueUtil, String pKeyName) throws Exception;


	/**
	 * 生成后端代码
	 *
	 * @param entity
	 * @param dataSourceModel
	 * @param fileName
	 * @param templatePath
	 * @param downloadCodeForm
	 * @param userInfo
	 * @param configValueUtil
	 * @param linkEntity
	 * @throws SQLException
	 */
	 void generate(VisualdevEntity entity, DataSourceModel dataSourceModel, String fileName, String templatePath, DownloadCodeForm downloadCodeForm, UserInfo userInfo, ConfigValueUtil configValueUtil, DbLinkEntity linkEntity) throws SQLException ;


}
