package com.bringspring.visualdev.generater.util.common;

import com.bringspring.common.model.visiual.ComponentKeyConsts;
import com.google.common.base.Function;
import com.google.common.base.Predicate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 代码生成器数据处理工具类
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date  2021/8/26
 */
public class DataControlUtils {

	/**
	 * 将字符串的首字母转大写
	 * @param name 需要转换的字符串
	 * @return
	 */
	public static String captureName(String name) {
		char[] ch = name.toCharArray();
		for (int i = 0; i < ch.length; i++) {
			if (i == 0) {
				ch[0] = Character.toUpperCase(ch[0]);
			}
		}
		StringBuffer a = new StringBuffer();
		a.append(ch);
		return a.toString();

	}

	public static String initialLowercase(String name) {
		char[] ch = name.toCharArray();
		for (int i = 0; i < ch.length; i++) {
			if (i == 0) {
				ch[0] = Character.toLowerCase(ch[0]);
			}
		}
		StringBuffer a = new StringBuffer();
		a.append(ch);
		return a.toString();
	}

	 public static String getPlaceholder(String keyName){
			String placeholderName = "请选择";
			switch (keyName){
				case ComponentKeyConsts.BILLRULE:
				case ComponentKeyConsts.MODIFYUSER:
				case ComponentKeyConsts.CREATEUSER:
				case ComponentKeyConsts.COM_INPUT:
				case ComponentKeyConsts.TEXTAREA:
					placeholderName = "请输入";
					break;
				default:
					break;
			}
			return placeholderName;
	 }

	/**
	 * 去重
	 * @param keyExtractor
	 * @param <T>
	 * @return
	 */
	public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
		Map<Object,Boolean> seen = new ConcurrentHashMap<>();
		return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
	}
}
