package com.bringspring.visualdev.onlinedev.service;

import com.bringspring.common.base.UserInfo;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.model.PaginationModel;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *列表临时接口
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date  2021/7/28
 */
@Service
public interface VisualDevListService {


	/**
	 * 无表数据
	 * @param modelId
	 * @return
	 */
	 List<OnlineDevListDataVO> getWithoutTableData(String modelId);

	/**
	 * 有表查询
	 * @param visualdevEntity
	 * @param paginationModel
	 * @return
	 */
	List<OnlineDevListDataVO> getListWithTable(VisualdevEntity visualdevEntity, PaginationModel paginationModel, UserInfo userInfo, String moduleId, List<VisualColumnSearchVO> searchVOList);

	/**
	 * 列表数据
	 * @param visualdevEntity
	 * @param paginationModel
	 * @return
	 */
	List<Map<String,Object>>  getDataList(VisualdevEntity visualdevEntity, PaginationModel paginationModel);


	/**
	 * 无表数据处理
	 * @param list
	 * @param searchVOList
	 * @param paginationModel
	 * @return
	 */
	List<OnlineDevListDataVO> getList(List<OnlineDevListDataVO> list,	List<VisualColumnSearchVO> searchVOList,PaginationModel paginationModel);

	/**
	 * 关联表单列表数据
	 * @param entity
	 * @param paginationModel
	 * @return
	 */
	List<Map<String,Object>> getRelationFormList(VisualdevEntity entity, PaginationModel paginationModel);
}
