package com.bringspring.visualdev.onlinedev.service.impl;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormModel;
import com.bringspring.common.model.visiual.*;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.props.PropsBeanModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.model.VisualWebTypeEnum;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.base.util.VisualUtils;
import com.bringspring.visualdev.onlinedev.entity.VisualdevModelDataEntity;
import com.bringspring.visualdev.onlinedev.mapper.VisualdevModelDataMapper;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineFieldsModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.model.*;
import com.bringspring.visualdev.onlinedev.service.VisualDevListService;
import com.bringspring.visualdev.onlinedev.service.VisualdevModelDataService;
import com.bringspring.visualdev.onlinedev.util.OnlineDevDbUtil;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevInfoUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
@Service
public class VisualdevModelDataServiceImpl extends ServiceImpl<VisualdevModelDataMapper, VisualdevModelDataEntity> implements VisualdevModelDataService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualDevListService visualDevListService;


    @Override
    public List<VisualdevModelDataEntity> getList(String modelId) {
        QueryWrapper<VisualdevModelDataEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(VisualdevModelDataEntity::getVisualDevId, modelId);
        return this.list(queryWrapper);
    }

    @Override
    public List<FormDataField> fieldList(String id) {
        VisualdevEntity entity = visualdevService.getInfo(id);
        FormDataModel formData = JsonUtil.getJsonToBean(entity.getFormData(), FormDataModel.class);

        List<FieLdsModel> fieLdsModelList = JsonUtil.getJsonToList(formData.getFields(), FieLdsModel.class);
        List<FieLdsModel> childFieldModelList = new ArrayList<>();
        List<FieLdsModel> mainFieldModelList = new ArrayList<>();
        List<FormModel> models = new ArrayList<>();

        OnlinePublicUtils.recurseFiled(fieLdsModelList, mainFieldModelList,childFieldModelList,models);

        List<FormDataField> formDataFieldList = mainFieldModelList.stream().filter(fieLdsModel -> !"".equals(fieLdsModel.getVModel())
            && StringUtils.isNotEmpty(fieLdsModel.getVModel())
            && !ComponentKeyConsts.RELATIONFORM.equals(fieLdsModel.getConfig().getKeyName())).map(fieLdsModel -> {
            FormDataField formDataField = new FormDataField();
            formDataField.setLabel(fieLdsModel.getConfig().getLabel());
            formDataField.setVModel(fieLdsModel.getVModel());
            return formDataField;
        }).collect(Collectors.toList());

        return formDataFieldList;
    }

    @Override
    public List<Map<String, Object>> getPageList(VisualdevEntity entity, PaginationModel paginationModel) {
        String json = null;
        if (StringUtils.isNotEmpty(paginationModel.getKeyword())) {
            Map<String, Object> map = new HashMap<>();
            map.put(paginationModel.getRelationField(), paginationModel.getKeyword());
            json = JsonUtil.getObjectToString(map);
        }
        paginationModel.setQueryJson(json);
        List<Map<String, Object>> dataList = visualDevListService.getRelationFormList(entity, paginationModel);
        return dataList;
    }

    @Override
    public List<Map<String, Object>> exportData(String[] keys, PaginationModelExport paginationModelExport, VisualdevEntity visualdevEntity) {
        PaginationModel paginationModel =new PaginationModel();
        BeanUtil.copyProperties(paginationModelExport,paginationModel);

        List<OnlineDevListDataVO> noSwapDataList;
        ColumnDataModel columnDataModel = JsonUtil.getJsonToBean(visualdevEntity.getColumnData(),ColumnDataModel.class);
        List<VisualColumnSearchVO> searchVOList = new ArrayList<>();
        //封装查询条件
        if (StringUtils.isNotEmpty(paginationModel.getQueryJson())){
            Map<String, Object> keyJsonMap = JsonUtil.stringToMap(paginationModel.getQueryJson());
            searchVOList= JsonUtil.getJsonToList(columnDataModel.getSearchList(),VisualColumnSearchVO.class);
            searchVOList =	searchVOList.stream().map(searchVO->{
                searchVO.setValue(keyJsonMap.get(searchVO.getVModel()));
                return searchVO;
            }).filter(vo->vo.getValue()!=null && StringUtils.isNotEmpty(String.valueOf(vo.getValue()))).collect(Collectors.toList());
            //左侧树查询
            boolean b =false;
            if (columnDataModel.getTreeRelation()!=null){
                b = keyJsonMap.keySet().stream().anyMatch(t -> t.equalsIgnoreCase(String.valueOf(columnDataModel.getTreeRelation())));
            }
            if (b && keyJsonMap.size()>searchVOList.size()){
                String relation =String.valueOf(columnDataModel.getTreeRelation());
                VisualColumnSearchVO vo =new VisualColumnSearchVO();
                vo.setSearchType("1");
                vo.setVModel(relation);
                vo.setValue(keyJsonMap.get(relation));
                searchVOList.add(vo);
            }
        }
        //判断有无表
        if (OnlinePublicUtils.isUseTables(visualdevEntity.getVisualTables())){
            //当前用户信息
            UserInfo userInfo = userProvider.get();
            //菜单id
            String moduleId = paginationModel.getMenuId();
            String reg = "^[jsbos_]\\S*_jsbos\\S*";
            searchVOList.stream().filter(c-> c.getVModel().matches(reg)).forEach(
                cl->{
                    String s = cl.getVModel();
                    String s1 = s.substring(s.lastIndexOf("jsbos_")).replace("jsbos_","");
                    cl.setVModel(s1);
                }
            );
            noSwapDataList =visualDevListService.getListWithTable(visualdevEntity,paginationModel,userInfo,moduleId,searchVOList);
        }else{
            noSwapDataList =visualDevListService.getWithoutTableData(visualdevEntity.getId());
            noSwapDataList = visualDevListService.getList(noSwapDataList, searchVOList, paginationModel);
        }

        //数据转换
        FormDataModel formDataModel = JsonUtil.getJsonToBean(visualdevEntity.getFormData(), FormDataModel.class);
        List<OnlineFieldsModel> swapDataVoList = JsonUtil.getJsonToList(formDataModel.getFields(),OnlineFieldsModel.class);
        //递归处理控件
        List<OnlineFieldsModel> allFormDataModelList = new ArrayList<>();
        OnlinePublicUtils.recursionFields(swapDataVoList,allFormDataModelList);
        allFormDataModelList=allFormDataModelList.stream().filter(model->model.getConfig().getKeyName()!=null && StringUtils.isNotEmpty(model.getVModel())).collect(Collectors.toList());
        noSwapDataList = OnlineDevListUtils.getSwapList(noSwapDataList, allFormDataModelList,visualdevEntity.getId());

        List<Map<String, Object>> realList = noSwapDataList.stream().map(t->t.getData()).collect(Collectors.toList());
        realList= realList.stream().map(rl-> {
            Map<String,Object> map = new HashMap<>();
            for (String key : keys){
                map.put(key,rl.get(key));
            }
            return map;
        }).collect(Collectors.toList());
        return realList;
    }


    @Override
    public VisualdevModelDataEntity getInfo(String id) {
        QueryWrapper<VisualdevModelDataEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(VisualdevModelDataEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public VisualdevModelDataInfoVO infoDataChange(String id, VisualdevEntity visualdevEntity) throws IOException, ParseException, DataException, SQLException {
        FormDataModel formDataModel = JsonUtil.getJsonToBean(visualdevEntity.getFormData(), FormDataModel.class);
        List<FieLdsModel> modelList = JsonUtil.getJsonToList(formDataModel.getFields(), FieLdsModel.class);

        VisualdevModelDataEntity visualdevModelDataEntity = this.getInfo(id);

        List<FieLdsModel> childFieldModelList = new ArrayList<>();
        List<FieLdsModel> mainFieldModelList = new ArrayList<>();
        //二维码 条形码
        List<FormModel> models = new ArrayList<>();
        OnlinePublicUtils.recurseFiled(modelList, mainFieldModelList,childFieldModelList,models);
        mainFieldModelList=	mainFieldModelList.stream().map(fieLdsModel -> {
            if(ObjectUtil.isNotEmpty(fieLdsModel.getProps())){
                if (StringUtils.isNotEmpty(fieLdsModel.getProps().getProps())){
                    PropsBeanModel propsBeanModel = JsonUtil.getJsonToBean(fieLdsModel.getProps().getProps(), PropsBeanModel.class);
                    fieLdsModel.getProps().setPropsModel(propsBeanModel);
                }
            }
            return fieLdsModel;
        }).collect(Collectors.toList());

        if (visualdevModelDataEntity != null) {
            Map<String, Object>  DataMap = JsonUtil.stringToMap(visualdevModelDataEntity.getData());
            Map<String, Object> childTableMap = DataMap.entrySet().stream().filter(m -> m.getKey().contains("tableField"))
                .collect(Collectors.toMap((e) -> (String) e.getKey(),
                (e) -> ObjectUtil.isNotEmpty(e.getValue()) ? e.getValue() : ""));
            Map<String, Object> mainTableMap = DataMap.entrySet().stream().filter(m -> !m.getKey().contains("tableField"))
                .collect(Collectors.toMap((e) -> (String) e.getKey(),
                    (e) -> ObjectUtil.isNotEmpty(e.getValue()) ? e.getValue() : ""));
            mainTableMap = OnlineDevInfoUtils.swapTableDataInfo(mainFieldModelList, mainTableMap, visualdevEntity.getId(),models);

            for (Map.Entry<String,Object> entry : childTableMap.entrySet()){
                List<Map<String, Object>> listMap = JsonUtil.getJsonToListMap(String.valueOf(entry.getValue()));
                FieLdsModel fieLdsModel = childFieldModelList.stream().filter(child -> child.getVModel().equalsIgnoreCase(entry.getKey())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty(fieLdsModel)){
                    List<Map<String,Object>> tableValueList = new ArrayList<>();
                    if (Objects.nonNull(listMap)){
                        for (Map<String, Object> map : listMap){
                            Map<String,Object> childFieldMap  = OnlineDevInfoUtils.swapChildTableDataInfo(fieLdsModel.getConfig().getChildren(),map,models);
                            tableValueList.add(childFieldMap);
                        }
                    }
                    Map<String,Object> childFieldsMap = new HashMap<>();
                    childFieldsMap.put(entry.getKey(),tableValueList);
                    mainTableMap.putAll(childFieldsMap);
                }
            }
            String objectToString = JsonUtilEx.getObjectToString(mainTableMap);
            VisualdevModelDataInfoVO vo = new VisualdevModelDataInfoVO();
            vo.setData(objectToString);
            vo.setId(id);
            return vo;
        }
        return null;
    }

    @Override
    public ActionResult visualCreate(VisualdevEntity visualdevEntity, Map<String, Object> dataMap, VisualdevModelDataCrForm visualdevModelDataCrForm, String mainId) throws WorkFlowException {
            VisualdevModelDataEntity entity = new VisualdevModelDataEntity();
            entity.setData(JsonUtilEx.getObjectToString(dataMap));
            entity.setVisualDevId(visualdevEntity.getId());
            entity.setId(mainId);
            entity.setSortCode(RandomUtil.parses());
            entity.setCreatorTime(new Date());
            entity.setCreatorUserId(userProvider.get().getUserId());
            entity.setEnabledMark(1);
            this.save(entity);
            if (visualdevEntity.getWebType() != null && visualdevEntity.getWebType().equals(VisualWebTypeEnum.FLOW_FROM.getType())) {
                //流程提交
                if (visualdevModelDataCrForm.getStatus().equals(FlowTaskStatusEnum.Handle.getCode())) {
                    FlowUtil.saveOrSubmit(visualdevModelDataCrForm.getTaskId(),visualdevModelDataCrForm.getFlowId(),visualdevModelDataCrForm.getTemplateId(),mainId,dataMap,visualdevModelDataCrForm.getStatus());
                    return ActionResult.success(MsgCode.SU006.get());
                } else {
                    FlowUtil.saveOrSubmit(visualdevModelDataCrForm.getTaskId(),visualdevModelDataCrForm.getFlowId(),visualdevModelDataCrForm.getTemplateId(),mainId,dataMap,visualdevModelDataCrForm.getStatus());
                    return ActionResult.success(MsgCode.SU002.get());
                }
            } else {
                return ActionResult.success(MsgCode.SU001.get());
            }
    }

    @Override
    public ActionResult visualUpdate(String id, VisualdevEntity visualdevEntity, Map<String, Object> map, VisualdevModelDataUpForm visualdevModelDataUpForm) throws WorkFlowException {
        if (StringUtils.isEmpty(visualdevEntity.getVisualTables()) || OnlineDevData.TABLE_CONST.equals(visualdevEntity.getVisualTables())) {
            VisualdevModelDataEntity entity = new VisualdevModelDataEntity();
            entity.setData(JsonUtilEx.getObjectToString(map));
            entity.setVisualDevId(visualdevEntity.getId());
            entity.setId(id);
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(userProvider.get().getUserId());
            this.updateById(entity);
        }
        if (visualdevEntity.getWebType() != null && visualdevEntity.getWebType().equals(VisualWebTypeEnum.FLOW_FROM.getType())) {
            //流程提交
            if (visualdevModelDataUpForm.getStatus().equals(FlowTaskStatusEnum.Handle.getCode())) {
                FlowUtil.saveOrSubmit(visualdevModelDataUpForm.getTaskId(),visualdevModelDataUpForm.getFlowId(),visualdevModelDataUpForm.getTemplateId(),id,map,visualdevModelDataUpForm.getStatus());
                return ActionResult.success(MsgCode.SU006.get());
            } else {
                return ActionResult.success(MsgCode.SU002.get());
            }
        } else {
            return ActionResult.success(MsgCode.SU004.get());
        }
    }


    @Override
    @DSTransactional
    public void delete(VisualdevModelDataEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }

    @Override
    public boolean tableDelete(String id, VisualdevEntity visualdevEntity) throws DataException, SQLException {
        DbLinkEntity linkEntity = dblinkService.getInfo(visualdevEntity.getDbLinkId());
        return OnlineDevDbUtil.deleteTable(id, visualdevEntity, linkEntity);
    }

    @Override
    public ActionResult tableDeleteMore(List<String> ids, VisualdevEntity visualdevEntity) throws DataException, SQLException {
        DbLinkEntity linkEntity = dblinkService.getInfo(visualdevEntity.getDbLinkId());
        return OnlineDevDbUtil.deleteTables(ids, visualdevEntity, linkEntity);
    }


}
