package com.bringspring.visualdev.onlinedev.util.onlineDevUtil;

import com.bringspring.common.util.StringUtils;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *
 * 关联表单工具类
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date  2022/1/7
 */
public class RelationFormUtils {

	/**
	 * 转后后查询
	 * @param dataVOList
	 * @param searchVOList
	 * @return
	 */
	public static List<OnlineDevListDataVO> getRelationListByKeyword(List<OnlineDevListDataVO> dataVOList, List<VisualColumnSearchVO> searchVOList){
		List<OnlineDevListDataVO> passDataList = new ArrayList<>();
		for (OnlineDevListDataVO dataVO : dataVOList){
			int i =0;
			Map<String, Object> dataMap = dataVO.getData();
			for (VisualColumnSearchVO searchVO : searchVOList){
				String s = String.valueOf(dataMap.get(searchVO.getVModel()));
				if (s.contains(String.valueOf(searchVO.getValue()))){
					i++;
				}
			}
			if (i>0){
				passDataList.add(dataVO);
			}
		}
		return passDataList;
	}

	public static StringBuilder getRelationListByKeywordWithSql(StringBuilder sql, List<VisualColumnSearchVO> searchVOList, String mainTable){
		sql.append(" where");
		for (int k = 0; k < searchVOList.size(); k++) {
			VisualColumnSearchVO vo = searchVOList.get(k);
			String vModel = vo.getVModel();
			String value = String.valueOf(vo.getValue());
			String tableName = StringUtils.isNotEmpty(vo.getConfig().getTableName()) ? vo.getConfig().getTableName() : mainTable;
			sql.append(" " + tableName + "." + vModel + " like " + "'%" + value + "%'" +" OR" );
		}
		sql.delete(sql.length()-2,sql.length());
		return sql;
	}
}
