package com.bringspring.visualdev.portal.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 *
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @author RKKJ开发平台组
 * @date 2021/3/16
 */
@Data
@TableName("BASE_PORTAL")
public class PortalEntity {
    @TableId("ID")
    private String id;


    @TableField("DESCRIPTION")
    private String description;


    /**
     * 名称
     */
    @TableField("FULL_NAME")
    private String fullName;


    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;


    /**
     * 分类(数据字典维护)
     */
    @TableField("CATEGORY")
    private String category;

    /**
     * 表单配置JSON
     */
    @TableField("FORM_DATA")
    private String formData;

    /**
     * 类型(0-页面设计,1-自定义路径)
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 静态页面路径
     */
    @TableField("CUSTOM_URL")
    private String customUrl;

    /**
     * 类型(0-页面,1-外链)
     */
    @TableField("LINK_TYPE")
    private Integer linkType;

    @TableField("SORT_CODE")
    private Long sortCode;


    @TableField("ENABLED_MARK")
    private Integer enabledMark;


    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;


    @TableField("DELETE_MARK")
    private Integer deleteMark;


    @TableField("DELETE_TIME")
    private Date deleteTime;


    @TableField("DELETE_USER_ID")
    private String deleteUserId;


}
