/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.aop;

import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import java.util.HashSet;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class VisiualOpaAspect {
    private static final Logger log = LoggerFactory.getLogger(VisiualOpaAspect.class);
    @Autowired
    UserProvider userProvider;
    @Autowired
    private CacheUtil cacheUtil;

    @Pointcut(value="(execution(* com.bringspring.visualdev.onlinedev.controller.VisualdevModelDataController.*(..))) || execution(* com.bringspring.visualdev.onlinedev.controller.VisualdevModelAppController.*(..)))|| execution(* com.bringspring.visualdev.generater.controller.VisualdevGenController.*(..)))")
    public void visiualOpa() {
    }

    @After(value="visiualOpa()")
    public void doAroundService() {
        String method = ServletUtils.getRequest().getMethod().toLowerCase();
        if ("put".equals(method) || "delete".equals(method) || "post".equals(method)) {
            HashSet allKey = new HashSet(16);
            allKey.addAll(this.cacheUtil.getAllVisiualKeys());
            for (String key : allKey) {
                this.cacheUtil.remove(key);
            }
        }
    }
}

