/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.ColumnDataModel;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.OnlineDevData;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.enums.ExportModelTypeEnum;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.model.VisualWebTypeEnum;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.base.util.VisualUtils;
import com.bringspring.visualdev.onlinedev.entity.VisualdevModelDataEntity;
import com.bringspring.visualdev.onlinedev.model.BaseDevModelVO;
import com.bringspring.visualdev.onlinedev.model.BatchRemoveIdsVo;
import com.bringspring.visualdev.onlinedev.model.ColumnDataInfoVO;
import com.bringspring.visualdev.onlinedev.model.DataInfoVO;
import com.bringspring.visualdev.onlinedev.model.FlowTemplateInfoVo;
import com.bringspring.visualdev.onlinedev.model.FormDataInfoVO;
import com.bringspring.visualdev.onlinedev.model.PaginationModel;
import com.bringspring.visualdev.onlinedev.model.PaginationModelExport;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataCrForm;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataInfoVO;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataUpForm;
import com.bringspring.visualdev.onlinedev.service.VisualDevInfoService;
import com.bringspring.visualdev.onlinedev.service.VisualDevListService;
import com.bringspring.visualdev.onlinedev.service.VisualdevModelDataService;
import com.bringspring.visualdev.onlinedev.util.AutoFeildsUtil;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.model.DataModel;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"0\u4ee3\u7801\u65e0\u8868\u5f00\u53d1"}, value="OnlineDev")
@RestController
@RequestMapping(value={"/api/visualdev/OnlineDev"})
public class VisualdevModelDataController {
    private static final Logger log = LoggerFactory.getLogger(VisualdevModelDataController.class);
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private VisualDevListService visualDevListService;
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private FlowDataUtil flowDataUtil;
    @Autowired
    private VisualDevInfoService visualDevInfoService;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5217\u8868")
    @PostMapping(value={"/{modelId}/List"})
    public ActionResult list(@PathVariable(value="modelId") String modelId, @RequestBody PaginationModel paginationModel) {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        List<Object> realList = VisualWebTypeEnum.FORM.getType().equals(visualdevEntity.getWebType()) ? new ArrayList() : this.visualDevListService.getDataList(visualdevEntity, paginationModel);
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        if (OnlineDevData.TYPE_THREE_COLUMNDATA.equals(columnDataModel.getType())) {
            realList = OnlineDevListUtils.groupData(realList, columnDataModel);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationModel), PaginationVO.class);
        return ActionResult.page(realList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868\u8868\u5355\u914d\u7f6eJSON")
    @GetMapping(value={"/{modelId}/Config"})
    public ActionResult getData(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity entity = this.visualdevService.getInfo(modelId);
        if (entity == null) {
            return ActionResult.fail((String)"\u529f\u80fd\u4e0d\u5b58\u5728");
        }
        DataInfoVO vo = (DataInfoVO)JsonUtil.getJsonToBean((Object)entity, DataInfoVO.class);
        if (ObjectUtil.isNotEmpty((Object)entity.getWebType()) && entity.getWebType() != null && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            try {
                FlowEngineEntity engineEntity = this.flowEngineService.getInfo(entity.getFlowId());
                vo.setFlowEnCode(engineEntity.getEnCode());
                vo.setFlowId(entity.getFlowId());
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868\u914d\u7f6eJSON")
    @GetMapping(value={"/{modelId}/ColumnData"})
    public ActionResult getColumnData(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity entity = this.visualdevService.getInfo(modelId);
        FormDataInfoVO vo = (FormDataInfoVO)JsonUtil.getJsonToBean((Object)entity, FormDataInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u914d\u7f6eJSON")
    @GetMapping(value={"/{modelId}/FormData"})
    public ActionResult<ColumnDataInfoVO> getFormData(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity entity = this.visualdevService.getInfo(modelId);
        ColumnDataInfoVO vo = (ColumnDataInfoVO)JsonUtil.getJsonToBean((Object)entity, ColumnDataInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u6d41\u6a21\u677fJSON")
    @GetMapping(value={"/{modelId}/FlowTemplate"})
    public ActionResult getFlowTemplate(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity entity = this.visualdevService.getInfo(modelId);
        FlowTemplateInfoVo vo = (FlowTemplateInfoVo)JsonUtil.getJsonToBean((Object)entity, FlowTemplateInfoVo.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u4fe1\u606f")
    @GetMapping(value={"/{modelId}/{id}"})
    public ActionResult info(@PathVariable(value="id") String id, @PathVariable(value="modelId") String modelId) throws DataException, ParseException, SQLException, IOException {
        id = XSSEscape.escape((String)id);
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId = XSSEscape.escape((String)modelId));
        if (!StringUtils.isEmpty((String)visualdevEntity.getVisualTables()) && !"[]".equals(visualdevEntity.getVisualTables())) {
            VisualdevModelDataInfoVO editDataInfo = this.visualDevInfoService.getEditDataInfo(id, visualdevEntity);
            return ActionResult.success((Object)editDataInfo);
        }
        VisualdevModelDataEntity entity = this.visualdevModelDataService.getInfo(id);
        Map formData = JsonUtil.stringToMap((String)visualdevEntity.getFormData());
        List<FieLdsModel> modelList = JsonUtil.getJsonToList((String)formData.get("fields").toString(), FieLdsModel.class);
        modelList = VisualUtils.deleteMore(modelList);
        String data = AutoFeildsUtil.autoFeilds(modelList, entity.getData());
        entity.setData(data);
        VisualdevModelDataInfoVO vo = (VisualdevModelDataInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, VisualdevModelDataInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u4fe1\u606f(\u5e26\u8f6c\u6362\u6570\u636e)")
    @GetMapping(value={"/{modelId}/{id}/DataChange"})
    public ActionResult infoWithDataChange(@PathVariable(value="modelId") String modelId, @PathVariable(value="id") String id) throws DataException, ParseException, IOException, SQLException {
        modelId = XSSEscape.escape((String)modelId);
        id = XSSEscape.escape((String)id);
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        if (!StringUtils.isEmpty((String)visualdevEntity.getVisualTables()) && !"[]".equals(visualdevEntity.getVisualTables())) {
            VisualdevModelDataInfoVO vo = this.visualDevInfoService.getDetailsDataInfo(id, visualdevEntity);
            return ActionResult.success((Object)vo);
        }
        VisualdevModelDataInfoVO vo = this.visualdevModelDataService.infoDataChange(id, visualdevEntity);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6570\u636e")
    @PostMapping(value={"/{modelId}"})
    public ActionResult create(@PathVariable(value="modelId") String modelId, @RequestBody VisualdevModelDataCrForm visualdevModelDataCrForm) throws WorkFlowException {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        Map map = JsonUtil.stringToMap((String)visualdevModelDataCrForm.getData());
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        DbLinkEntity linkEntity = null;
        if (StringUtils.isNotEmpty((String)visualdevEntity.getDbLinkId())) {
            linkEntity = this.dblinkService.getInfo(visualdevEntity.getDbLinkId());
        }
        String mainId = RandomUtil.uuId();
        DataModel dataModel = DataModel.builder().dataNewMap(map).fieLdsModelList(list).tableModelList(tableModels).mainId(mainId).link(linkEntity).build();
        Map map1 = this.flowDataUtil.create(dataModel);
        return this.visualdevModelDataService.visualCreate(visualdevEntity, map1, visualdevModelDataCrForm, mainId);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping(value={"/{flowId}/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @PathVariable(value="flowId") String flowId, @RequestBody VisualdevModelDataUpForm visualdevModelDataUpForm) throws DataException, SQLException, WorkFlowException {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(flowId);
        Map map = JsonUtil.stringToMap((String)visualdevModelDataUpForm.getData());
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        DbLinkEntity linkEntity = null;
        if (StringUtils.isNotEmpty((String)visualdevEntity.getDbLinkId())) {
            linkEntity = this.dblinkService.getInfo(visualdevEntity.getDbLinkId());
        }
        DataModel dataModel = DataModel.builder().dataNewMap(map).fieLdsModelList(list).tableModelList(tableModels).mainId(id).link(linkEntity).build();
        Map map1 = this.flowDataUtil.update(dataModel);
        return this.visualdevModelDataService.visualUpdate(id, visualdevEntity, map1, visualdevModelDataUpForm);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping(value={"/{modelId}/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id, @PathVariable(value="modelId") String modelId) throws DataException, SQLException, WorkFlowException {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        if (ObjectUtil.isNotEmpty((Object)visualdevEntity.getWebType()) && visualdevEntity.getWebType() != null && VisualWebTypeEnum.FLOW_FROM.getType().equals(visualdevEntity.getWebType())) {
            if (StringUtils.isNotEmpty((String)visualdevEntity.getFlowId())) {
                FlowTaskEntity taskEntity = this.flowTaskService.getInfoSubmit(id, new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
                if (taskEntity != null) {
                    this.flowTaskService.delete(taskEntity);
                }
            } else {
                return ActionResult.fail((String)"\u672a\u5173\u8054\u6d41\u7a0b\u5f15\u64ce");
            }
        }
        if (!StringUtils.isEmpty((String)visualdevEntity.getVisualTables()) && !"[]".equals(visualdevEntity.getVisualTables())) {
            boolean result = this.visualdevModelDataService.tableDelete(id, visualdevEntity);
            if (result) {
                return ActionResult.success((String)MsgCode.SU003.get());
            }
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        VisualdevModelDataEntity entity = this.visualdevModelDataService.getInfo(id);
        if (entity != null) {
            this.visualdevModelDataService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e")
    @PostMapping(value={"/batchDelete/{modelId}"})
    public ActionResult beachDelete(@RequestBody BatchRemoveIdsVo idsVo, @PathVariable(value="modelId") String modelId) throws DataException, SQLException, WorkFlowException {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        List<Object> idsList = new ArrayList();
        List<String> idsVoList = Arrays.asList(idsVo.getIds());
        if (visualdevEntity.getWebType() != null && visualdevEntity.getWebType().equals(VisualWebTypeEnum.FLOW_FROM.getType())) {
            for (String id : idsVoList) {
                FlowTaskEntity taskEntity = this.flowTaskService.getInfoSubmit(id, new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
                if (taskEntity != null) {
                    if (!taskEntity.getStatus().equals(0) && !taskEntity.getStatus().equals(4)) continue;
                    idsList.add(id);
                    this.flowTaskService.delete(taskEntity);
                    continue;
                }
                idsList.add(id);
            }
        } else {
            idsList = idsVoList;
        }
        if (idsList.size() == 0) {
            return ActionResult.fail((String)"\u8be5\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (!StringUtils.isEmpty((String)visualdevEntity.getVisualTables()) && !"[]".equals(visualdevEntity.getVisualTables())) {
            ActionResult result = this.visualdevModelDataService.tableDeleteMore(idsList, visualdevEntity);
            return result;
        }
        if (this.visualdevModelDataService.removeByIds(idsList)) {
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        if (visualdevEntity.getWebType() != null && visualdevEntity.getWebType().equals(VisualWebTypeEnum.FLOW_FROM.getType()) && idsList.size() > 0) {
            return ActionResult.fail((String)"\u8be5\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/Model/{modelId}/Actions/Import"})
    public ActionResult imports(@PathVariable(value="modelId") String modelId) {
        VisualdevModelDataEntity entity = this.visualdevModelDataService.getInfo(modelId);
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().contains(".xlsx")) {
            String filePath = this.configValueUtil.getTemporaryFilePath();
            String fileName = RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file);
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
            return ActionResult.success((String)MsgCode.IMP001.get());
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/{modelId}/Actions/Export"})
    public ActionResult export(@PathVariable(value="modelId") String modelId, @RequestBody PaginationModelExport paginationModelExport) throws ParseException, IOException, SQLException, DataException {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        String[] keys = paginationModelExport.getSelectKey();
        List<Map<String, Object>> realList = this.visualdevModelDataService.exportData(keys, paginationModelExport, visualdevEntity);
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = VisualUtils.createModelExcel(visualdevEntity, this.configValueUtil.getTemporaryFilePath(), realList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u529f\u80fd\u5bfc\u51fa")
    @PostMapping(value={"/{modelId}/Actions/ExportData"})
    public ActionResult exportData(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((Object)visualdevEntity, BaseDevModelVO.class);
        vo.setModelType(ExportModelTypeEnum.Design.getMessage());
        DownloadVO downloadVO = this.fileExport.exportFile((Object)vo, this.configValueUtil.getTemporaryFilePath(), visualdevEntity.getFullName(), ModuleTypeEnum.VISUAL_DEV.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @ApiOperation(value="\u529f\u80fd\u5bfc\u5165")
    @PostMapping(value={"/Model/Actions/ImportData"}, consumes={"multipart/form-data"})
    public ActionResult ImportData(@RequestPart(value="file") MultipartFile multipartFile) throws WorkFlowException {
        VisualdevEntity entity;
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.VISUAL_DEV.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((String)fileContent, BaseDevModelVO.class);
        if (vo.getModelType() == null || !vo.getModelType().equals(ExportModelTypeEnum.Design.getMessage())) {
            return ActionResult.fail((String)"\u8bf7\u5bfc\u5165\u5bf9\u5e94\u529f\u80fd\u7684json\u6587\u4ef6");
        }
        VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)vo, VisualdevEntity.class);
        String modelId = visualdevEntity.getId();
        if (StringUtils.isNotEmpty((String)modelId) && (entity = this.visualdevService.getInfo(modelId)) != null) {
            return ActionResult.fail((String)"\u5df2\u5b58\u5728\u76f8\u540c\u529f\u80fd");
        }
        visualdevEntity.setCreatorTime(DateUtil.getNowDate());
        visualdevEntity.setLastModifyTime(null);
        this.visualdevService.create(visualdevEntity);
        return ActionResult.success((String)MsgCode.IMP001.get());
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> templateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }
}

