/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.database.model.JdbcPageMod;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.ColumnDataModel;
import com.bringspring.common.model.visiual.ColumnListField;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PageUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.model.VisualWebTypeEnum;
import com.bringspring.visualdev.base.util.VisualUtils;
import com.bringspring.visualdev.onlinedev.entity.VisualdevModelDataEntity;
import com.bringspring.visualdev.onlinedev.mapper.VisualdevModelDataMapper;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineColumnFieldModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineFieldsModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.model.PaginationModel;
import com.bringspring.visualdev.onlinedev.service.VisualDevListService;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineProductSqlUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.RelationFormUtils;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.service.FlowTaskService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualDevListServiceImpl
extends ServiceImpl<VisualdevModelDataMapper, VisualdevModelDataEntity>
implements VisualDevListService {
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<Map<String, Object>> getDataList(VisualdevEntity visualdevEntity, PaginationModel paginationModel) {
        List<OnlineDevListDataVO> noSwapDataList;
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List swapDataVoList = JsonUtil.getJsonToList((String)formDataModel.getFields(), OnlineFieldsModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        ArrayList<VisualColumnSearchVO> searchVOList = new ArrayList();
        if (StringUtils.isNotEmpty((String)paginationModel.getQueryJson())) {
            Map keyJsonMap = JsonUtil.stringToMap((String)paginationModel.getQueryJson());
            searchVOList = JsonUtil.getJsonToList((String)columnDataModel.getSearchList(), VisualColumnSearchVO.class);
            searchVOList = searchVOList.stream().map(searchVO -> {
                searchVO.setValue(keyJsonMap.get(searchVO.getVModel()));
                return searchVO;
            }).filter(vo -> vo.getValue() != null).collect(Collectors.toList());
            boolean b = false;
            if (columnDataModel.getTreeRelation() != null) {
                b = keyJsonMap.keySet().stream().anyMatch(t -> t.equalsIgnoreCase(String.valueOf(columnDataModel.getTreeRelation())));
            }
            if (b && keyJsonMap.size() > searchVOList.size()) {
                String relation = String.valueOf(columnDataModel.getTreeRelation());
                VisualColumnSearchVO vo2 = new VisualColumnSearchVO();
                FieLdsModel fieLdsModel = fieLdsModels.stream().filter(swap -> relation.equalsIgnoreCase(swap.getVModel())).findFirst().orElse(null);
                vo2.setConfig(Objects.nonNull(fieLdsModel) ? fieLdsModel.getConfig() : null);
                vo2.setSearchType("1");
                vo2.setVModel(relation);
                vo2.setValue(keyJsonMap.get(relation));
                searchVOList.add(vo2);
            }
        }
        if (OnlinePublicUtils.isUseTables(visualdevEntity.getVisualTables()).booleanValue()) {
            UserInfo userInfo = this.userProvider.get();
            String moduleId = paginationModel.getMenuId();
            String reg = "^[jsbos_]\\S*_jsbos\\S*";
            searchVOList.stream().filter(c -> c.getVModel().matches(reg)).forEach(cl -> {
                String s = cl.getVModel();
                String s1 = s.substring(s.lastIndexOf("jsbos_")).replace("jsbos_", "");
                cl.setVModel(s1);
            });
            noSwapDataList = this.getListWithTable(visualdevEntity, paginationModel, userInfo, moduleId, searchVOList);
        } else {
            noSwapDataList = this.getWithoutTableData(visualdevEntity.getId());
            noSwapDataList = this.getList(noSwapDataList, searchVOList, paginationModel);
        }
        List<Map<String, Object>> realList = new ArrayList<Map<String, Object>>();
        if (noSwapDataList.size() < 1) {
            return realList;
        }
        List<OnlineFieldsModel> allFormDataModelList = new ArrayList<OnlineFieldsModel>();
        OnlinePublicUtils.recursionFields(swapDataVoList, allFormDataModelList);
        allFormDataModelList = allFormDataModelList.stream().filter(model -> model.getConfig().getKeyName() != null && StringUtils.isNotEmpty((String)model.getVModel())).collect(Collectors.toList());
        noSwapDataList = OnlineDevListUtils.getSwapList(noSwapDataList, allFormDataModelList, visualdevEntity.getId());
        realList = noSwapDataList.stream().map(t -> {
            t.getData().put("id", t.getId());
            return t.getData();
        }).collect(Collectors.toList());
        if (visualdevEntity.getWebType() != null && visualdevEntity.getWebType().equals(VisualWebTypeEnum.FLOW_FROM.getType())) {
            List<String> ids = realList.stream().map(i -> i.get("id").toString()).collect(Collectors.toList());
            List tasks = this.flowTaskService.getInfosSubmit(ids.toArray(new String[0]), new SFunction[]{FlowTaskEntity::getStatus, FlowTaskEntity::getId, FlowTaskEntity::getProcessId});
            realList.stream().forEach(m -> {
                String id = m.get("id").toString();
                m.put("flowState", "");
                tasks.forEach(i -> {
                    if (i.getId().equals(id) || i.getProcessId().equals(id)) {
                        m.put("flowState", i.getStatus());
                    }
                });
            });
        }
        return realList;
    }

    @Override
    public List<OnlineDevListDataVO> getList(List<OnlineDevListDataVO> noSwapDataList, List<VisualColumnSearchVO> searchVOList, PaginationModel paginationModel) {
        if (searchVOList.size() > 0) {
            noSwapDataList = OnlineDevListUtils.getNoSwapList(noSwapDataList, searchVOList);
        }
        if (noSwapDataList.size() > 0) {
            if (StringUtils.isNotEmpty((String)paginationModel.getSidx())) {
                noSwapDataList.sort((o1, o2) -> {
                    Map<String, Object> i1 = o1.getData();
                    Map<String, Object> i2 = o2.getData();
                    String s1 = String.valueOf(i1.get(paginationModel.getSidx()));
                    String s2 = String.valueOf(i2.get(paginationModel.getSidx()));
                    if ("desc".equalsIgnoreCase(paginationModel.getSort())) {
                        return s2.compareTo(s1);
                    }
                    return s1.compareTo(s2);
                });
            }
            long total = noSwapDataList.size();
            noSwapDataList = PageUtil.getListPage((int)((int)paginationModel.getCurrentPage()), (int)((int)paginationModel.getPageSize()), noSwapDataList);
            noSwapDataList = paginationModel.setData(noSwapDataList, total);
        }
        return noSwapDataList;
    }

    @Override
    public List<OnlineDevListDataVO> getWithoutTableData(String modelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualdevModelDataEntity::getVisualDevId, (Object)modelId);
        List list = this.list((Wrapper)queryWrapper);
        List<OnlineDevListDataVO> dataVoList = list.parallelStream().map(t -> {
            OnlineDevListDataVO vo = new OnlineDevListDataVO();
            vo.setId(t.getId());
            vo.setData(JsonUtil.stringToMap((String)t.getData()));
            return vo;
        }).collect(Collectors.toList());
        return dataVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OnlineDevListDataVO> getListWithTable(VisualdevEntity visualdevEntity, PaginationModel paginationModel, UserInfo userInfo, String moduleId, List<VisualColumnSearchVO> searchVOList) {
        List<OnlineDevListDataVO> noSwapDataList = new ArrayList<OnlineDevListDataVO>();
        DbLinkEntity linkEntity = this.dblinkService.getInfo(visualdevEntity.getDbLinkId());
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getAppColumnData(), ColumnDataModel.class);
        String header = ServletUtils.getHeader((String)"jsbos-origin");
        if ("pc".equals(header)) {
            columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        }
        List tableModelList = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        TableModel mainTable = tableModelList.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);
        List modelList = JsonUtil.getJsonToList((String)columnDataModel.getColumnList(), ColumnListField.class);
        StringBuilder mainSql = new StringBuilder();
        List<String> collect = modelList.stream().map(mode -> mode.getProp()).collect(Collectors.toList());
        mainSql = OnlineProductSqlUtils.getColumnListSql(mainSql, tableModelList, collect, linkEntity);
        mainSql.append(" where (1=1)");
        if (columnDataModel.getUseDataPermission() != null && columnDataModel.getUseDataPermission().booleanValue()) {
            AuthorizeService authorizeService = (AuthorizeService)SpringContext.getBean(AuthorizeService.class);
            if (!userInfo.getIsAdministrator().booleanValue()) {
                String conditionSql = authorizeService.getConditionSql(userInfo, moduleId, mainTable.getTable());
                if (conditionSql.length() > 0) {
                    if (!conditionSql.equals("alldata")) {
                        mainSql.append(conditionSql);
                    }
                } else {
                    return new ArrayList<OnlineDevListDataVO>();
                }
            }
        }
        try {
            Connection connection = VisualUtils.getDataConn(linkEntity);
            try {
                List dataList;
                if (searchVOList.size() > 0) {
                    mainSql = OnlineProductSqlUtils.getConditionSql(mainSql, linkEntity, searchVOList, mainTable.getTable());
                }
                String pkeyId = VisualUtils.getpKey(connection, mainTable.getTable());
                String sort = StringUtils.isNotEmpty((String)paginationModel.getSort()) ? paginationModel.getSort() : "ASC";
                String sidx = pkeyId;
                if (StringUtils.isNotEmpty((String)paginationModel.getSidx())) {
                    sidx = paginationModel.getSidx();
                }
                String sortType = sidx + " " + sort;
                if ("1".equals(paginationModel.getDataType())) {
                    dataList = JdbcUtil.queryListAlias((PreparedStatementDTO)new PreparedStatementDTO(connection, mainSql.toString()));
                } else {
                    JdbcPageMod jdbcPageMod = JdbcUtil.queryPage((PreparedStatementDTO)new PreparedStatementDTO(connection, mainSql.toString()), (String)sortType, (Integer)((int)paginationModel.getCurrentPage()), (Integer)((int)paginationModel.getPageSize()));
                    dataList = jdbcPageMod.getDataList();
                    paginationModel.setTotal(jdbcPageMod.getTotalRecord().intValue());
                }
                List<OnlineColumnFieldModel> childValue = OnlineProductSqlUtils.getChildValue(collect);
                dataList = dataList.stream().map(map -> {
                    map = OnlinePublicUtils.mapKeyToLower(map);
                    HashMap<String, Object> realMap = new HashMap<String, Object>();
                    for (OnlineColumnFieldModel onlineColumnFieldModel : childValue) {
                        realMap.put(onlineColumnFieldModel.getOriginallyField(), map.get(onlineColumnFieldModel.getOtherName().toLowerCase()));
                    }
                    realMap.put(pkeyId.toLowerCase(), map.get(pkeyId.toLowerCase()));
                    return realMap;
                }).collect(Collectors.toList());
                noSwapDataList = dataList.stream().map(data -> {
                    OnlineDevListDataVO vo = new OnlineDevListDataVO();
                    vo.setId(String.valueOf(data.get(pkeyId.toLowerCase())));
                    vo.setData((Map<String, Object>)data);
                    return vo;
                }).collect(Collectors.toList());
            }
            finally {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.close();
                }
            }
        }
        catch (DataException | SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return noSwapDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getRelationFormList(VisualdevEntity entity, PaginationModel paginationModel) {
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List<String> collect = Arrays.asList(paginationModel.getColumnOptions().split(","));
        List fieLdsModelList = JsonUtil.getJsonToList((String)formData.getFields(), OnlineFieldsModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        ArrayList<OnlineFieldsModel> childFieldModelList = new ArrayList<OnlineFieldsModel>();
        List<OnlineFieldsModel> mainFieldModelList = new ArrayList<OnlineFieldsModel>();
        OnlinePublicUtils.recurseOnlineFiled(fieLdsModelList, mainFieldModelList, childFieldModelList);
        mainFieldModelList = mainFieldModelList.stream().filter(fieLdsModel -> !"".equals(fieLdsModel.getVModel()) && StringUtils.isNotEmpty((String)fieLdsModel.getVModel()) && !"relationForm".equals(fieLdsModel.getConfig().getKeyName())).collect(Collectors.toList());
        List<Object> noSwapDataList = new ArrayList();
        ArrayList<VisualColumnSearchVO> searchVOList = new ArrayList<VisualColumnSearchVO>();
        String keyword = paginationModel.getKeyword();
        if (OnlinePublicUtils.isUseTables(entity.getVisualTables()).booleanValue()) {
            try {
                List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
                TableModel mainTable = tableModelList.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);
                DbLinkEntity linkEntity = this.dblinkService.getInfo(entity.getDbLinkId());
                List<OnlineColumnFieldModel> childValue = OnlineProductSqlUtils.getChildValue(collect);
                StringBuilder sql = new StringBuilder();
                Boolean isPage = paginationModel.getPageSize() <= 500L;
                sql = OnlineProductSqlUtils.getColumnListSql(sql, tableModelList, collect, linkEntity);
                Connection connection = VisualUtils.getDataConn(linkEntity);
                try {
                    if (StringUtils.isNotEmpty((String)keyword) && isPage.booleanValue()) {
                        for (FieLdsModel fieldsModel : fieLdsModels) {
                            boolean b;
                            if (fieldsModel.getVModel() == null || !(b = collect.stream().anyMatch(c -> fieldsModel.getVModel().equalsIgnoreCase((String)c) && (fieldsModel.getConfig().getKeyName().equals("comInput") || fieldsModel.getConfig().getKeyName().equals("textarea"))))) continue;
                            VisualColumnSearchVO vo = new VisualColumnSearchVO();
                            vo.setSearchType("2");
                            vo.setVModel(fieldsModel.getVModel());
                            vo.setValue(keyword);
                            vo.setConfig(fieldsModel.getConfig());
                            Boolean multiple = fieldsModel.getMultiple();
                            vo.setMultiple(multiple);
                            searchVOList.add(vo);
                        }
                        if (searchVOList.size() > 0) {
                            sql = RelationFormUtils.getRelationListByKeywordWithSql(sql, searchVOList, mainTable.getTable());
                        }
                    }
                    String pkeyId = VisualUtils.getpKey(connection, mainTable.getTable());
                    String sort = StringUtils.isNotEmpty((String)paginationModel.getSort()) ? paginationModel.getSort() : "ASC";
                    String sidx = pkeyId;
                    if (StringUtils.isNotEmpty((String)paginationModel.getSidx())) {
                        sidx = paginationModel.getSidx();
                    }
                    String sortType = sidx + " " + sort;
                    JdbcPageMod jdbcPageMod = JdbcUtil.queryPage((PreparedStatementDTO)new PreparedStatementDTO(connection, sql.toString()), (String)sortType, (Integer)((int)paginationModel.getCurrentPage()), (Integer)((int)paginationModel.getPageSize()));
                    List dataList = jdbcPageMod.getDataList();
                    dataList = dataList.stream().map(map -> {
                        map = OnlinePublicUtils.mapKeyToLower(map);
                        HashMap<String, Object> realMap = new HashMap<String, Object>();
                        for (OnlineColumnFieldModel onlineColumnFieldModel : childValue) {
                            realMap.put(onlineColumnFieldModel.getOriginallyField(), map.get(onlineColumnFieldModel.getOtherName().toLowerCase()));
                        }
                        realMap.put(pkeyId.toLowerCase(), map.get(pkeyId.toLowerCase()));
                        return realMap;
                    }).collect(Collectors.toList());
                    paginationModel.setTotal(jdbcPageMod.getTotalRecord().intValue());
                    noSwapDataList = dataList.stream().map(data -> {
                        OnlineDevListDataVO vo = new OnlineDevListDataVO();
                        vo.setId(String.valueOf(data.get(pkeyId.toLowerCase())));
                        vo.setData((Map<String, Object>)data);
                        return vo;
                    }).collect(Collectors.toList());
                    if (StringUtils.isNotEmpty((String)keyword) && !isPage.booleanValue()) {
                        for (FieLdsModel fieldsModel : fieLdsModels) {
                            boolean b;
                            if (fieldsModel.getVModel() == null || !(b = collect.stream().anyMatch(c -> fieldsModel.getVModel().equalsIgnoreCase((String)c)))) continue;
                            VisualColumnSearchVO vo = new VisualColumnSearchVO();
                            vo.setSearchType("2");
                            vo.setVModel(fieldsModel.getVModel());
                            vo.setValue(keyword);
                            vo.setConfig(fieldsModel.getConfig());
                            Boolean multiple = fieldsModel.getMultiple();
                            vo.setMultiple(multiple);
                            searchVOList.add(vo);
                        }
                        noSwapDataList = OnlineDevListUtils.getSwapList(noSwapDataList, mainFieldModelList, entity.getId());
                        noSwapDataList = RelationFormUtils.getRelationListByKeyword(noSwapDataList, searchVOList);
                    } else {
                        noSwapDataList = OnlineDevListUtils.getSwapList(noSwapDataList, mainFieldModelList, entity.getId());
                    }
                }
                finally {
                    if (Collections.singletonList(connection).get(0) != null) {
                        connection.close();
                    }
                }
            }
            catch (DataException | SQLException sqlException) {
                sqlException.printStackTrace();
            }
        } else {
            if (StringUtils.isNotEmpty((String)keyword)) {
                for (FieLdsModel fieldsModel : fieLdsModels) {
                    boolean b;
                    if (fieldsModel.getVModel() == null || !(b = collect.stream().anyMatch(c -> fieldsModel.getVModel().equalsIgnoreCase((String)c)))) continue;
                    VisualColumnSearchVO vo = new VisualColumnSearchVO();
                    vo.setSearchType("2");
                    vo.setVModel(fieldsModel.getVModel());
                    vo.setValue(keyword);
                    vo.setConfig(fieldsModel.getConfig());
                    Boolean multiple = fieldsModel.getMultiple();
                    vo.setMultiple(multiple);
                    searchVOList.add(vo);
                }
            }
            noSwapDataList = this.getWithoutTableData(entity.getId());
            noSwapDataList = OnlineDevListUtils.getSwapList(noSwapDataList, mainFieldModelList, entity.getId());
            if (searchVOList.size() > 0) {
                noSwapDataList = RelationFormUtils.getRelationListByKeyword(noSwapDataList, searchVOList);
            }
        }
        if (noSwapDataList.size() < 1) {
            return new ArrayList<Map<String, Object>>();
        }
        return noSwapDataList.stream().map(t -> {
            Map<String, Object> data = t.getData();
            data.put("id", t.getId());
            return data;
        }).collect(Collectors.toList());
    }
}

