/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.model.FormModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.options.ColumnOptionModel;
import com.bringspring.common.model.visiual.fields.props.PropsBeanModel;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.model.dataInterface.DataInterfaceActionVo;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.CacheKeyEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.MultipleControlEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataInfoVO;
import com.bringspring.visualdev.onlinedev.service.VisualDevInfoService;
import com.bringspring.visualdev.onlinedev.service.VisualdevModelDataService;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineDevInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(OnlineDevInfoUtils.class);
    private static RedisUtil redisUtil;
    private static CacheUtil cacheUtil;
    private static DictionaryDataService dictionaryDataService;
    private static UserService userService;
    private static PositionService positionService;
    private static OrganizeService organizeService;
    private static VisualdevService visualdevService;
    private static VisualdevModelDataService visualdevModelDataService;
    private static DataInterfaceService dataInterfaceService;
    private static VisualDevInfoService visualDevInfoService;
    private static ProvinceService provinceService;

    public static void init() {
        visualdevModelDataService = (VisualdevModelDataService)SpringContext.getBean(VisualdevModelDataService.class);
        dictionaryDataService = (DictionaryDataService)SpringContext.getBean(DictionaryDataService.class);
        userService = (UserService)SpringContext.getBean(UserService.class);
        positionService = (PositionService)SpringContext.getBean(PositionService.class);
        redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
        cacheUtil = (CacheUtil)SpringContext.getBean(CacheUtil.class);
        organizeService = (OrganizeService)SpringContext.getBean(OrganizeService.class);
        visualdevService = (VisualdevService)SpringContext.getBean(VisualdevService.class);
        dataInterfaceService = (DataInterfaceService)SpringContext.getBean(DataInterfaceService.class);
        visualDevInfoService = (VisualDevInfoService)SpringContext.getBean(VisualDevInfoService.class);
        provinceService = (ProvinceService)SpringContext.getBean(ProvinceService.class);
    }

    public static Map<String, Object> swapTableDataInfo(List<FieLdsModel> modelList, Map<String, Object> dataMap, String visualDevId, List<FormModel> codeList) {
        OnlineDevInfoUtils.init();
        String dsName = Optional.ofNullable(DataSourceContextHolder.getDatasourceId()).orElse("");
        Object orgData = cacheUtil.query(visualDevId + CacheKeyEnum.ORG.getName());
        Map<String, Object> orgMap = Objects.nonNull(orgData) ? JsonUtil.stringToMap((String)orgData.toString()) : new HashMap(20);
        Object allOrgData = cacheUtil.query(visualDevId + CacheKeyEnum.AllORG.getName());
        Map<String, Object> allOrgMap = Objects.nonNull(allOrgData) ? JsonUtil.stringToMap((String)allOrgData.toString()) : new HashMap(20);
        Object posData = cacheUtil.query(visualDevId + CacheKeyEnum.POS.getName());
        Map<String, Object> posMap = Objects.nonNull(posData) ? JsonUtil.stringToMap((String)posData.toString()) : new HashMap(20);
        Object userData = cacheUtil.query(visualDevId + CacheKeyEnum.USER.getName());
        Map<String, Object> userMap = Objects.nonNull(userData) ? JsonUtil.stringToMap((String)userData.toString()) : new HashMap(20);
        Map proMap = cacheUtil.getMap(dsName + CacheKeyEnum.PRO.getName());
        HashMap<String, Object> dataCopyMap = new HashMap<String, Object>();
        dataCopyMap.putAll(dataMap);
        try {
            for (FieLdsModel swapDataVo : modelList) {
                Object dicObj;
                String redisKey;
                String keyName = swapDataVo.getConfig().getKeyName();
                String vModel = swapDataVo.getVModel();
                String dataType = String.valueOf(swapDataVo.getConfig().getDataType());
                Boolean isMultiple = swapDataVo.getMultiple();
                Object val = dataMap.get(vModel);
                if (StringUtils.isEmpty((String)String.valueOf(dataMap.get(vModel))) || val == null) continue;
                if (String.valueOf(dataMap.get(vModel)).equals("[]") || String.valueOf(dataMap.get(vModel)).equals("null")) {
                    dataMap.put(vModel, null);
                    continue;
                }
                switch (keyName) {
                    case "comSelect": 
                    case "depSelect": 
                    case "currDept": 
                    case "currOrganize": {
                        if ("all".equals(swapDataVo.getShowLevel())) {
                            if (allOrgMap.size() > 0) {
                                dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(allOrgMap, val, isMultiple));
                                break;
                            }
                            dataMap.put(vModel, PermissionUtil.getLinkInfoByOrgId((String)val.toString(), (OrganizeService)organizeService, (Boolean)false));
                            break;
                        }
                        if (orgMap.size() > 0) {
                            dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(orgMap, val, isMultiple));
                            break;
                        }
                        dataMap.put(vModel, OnlineDevInfoUtils.getOrgValue(String.valueOf(val)));
                        break;
                    }
                    case "posSelect": 
                    case "currPosition": {
                        if (posMap.size() > 0) {
                            dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(posMap, val, isMultiple));
                            break;
                        }
                        dataMap.put(vModel, OnlineDevInfoUtils.getPosValue(String.valueOf(val)));
                        break;
                    }
                    case "userSelect": 
                    case "createUser": 
                    case "modifyUser": {
                        if (userMap.size() > 0) {
                            dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(userMap, val, isMultiple));
                            break;
                        }
                        dataMap.put(vModel, OnlineDevInfoUtils.getUserValue(String.valueOf(val)));
                        break;
                    }
                    case "address": {
                        String adressValue = String.valueOf(dataMap.get(vModel));
                        if (OnlinePublicUtils.getMultiple(adressValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                            String[][] data = (String[][])JsonUtil.getJsonToBean((String)adressValue, String[][].class);
                            ArrayList<String> addList = new ArrayList<String>();
                            for (String[] AddressData : data) {
                                ArrayList<String> adList = new ArrayList<String>();
                                for (String s : AddressData) {
                                    adList.add(String.valueOf(proMap.get(s)));
                                }
                                addList.add(String.join((CharSequence)"/", adList));
                            }
                            dataMap.put(vModel, String.join((CharSequence)";", addList));
                            break;
                        }
                        List proDataS = JsonUtil.getJsonToList((String)adressValue, String.class);
                        proDataS = proDataS.stream().map(pro -> String.valueOf(proMap.get(pro))).collect(Collectors.toList());
                        dataMap.put(vModel, String.join((CharSequence)"/", proDataS));
                        break;
                    }
                    case "switch": {
                        String switchValue = String.valueOf(dataMap.get(vModel)).equals("1") ? swapDataVo.getActiveTxt() : swapDataVo.getInactiveTxt();
                        dataMap.put(vModel, switchValue);
                        break;
                    }
                    case "slider": {
                        dataMap.put(vModel, dataMap.get(vModel) != null ? Integer.valueOf(Integer.parseInt(String.valueOf(dataMap.get(vModel)))) : null);
                        break;
                    }
                    case "cascader": {
                        Map<String, Object> cascaderMap;
                        String redisKey2 = OnlineDataTypeEnum.STATIC.getType().equals(dataType) ? String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()) : (OnlineDataTypeEnum.DYNAMIC.getType().equals(dataType) ? String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getProps().getPropsModel().getLabel(), swapDataVo.getProps().getPropsModel().getValue(), swapDataVo.getProps().getPropsModel().getChildren()) : String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()));
                        Object cascaderDatas = cacheUtil.query(redisKey2);
                        if (!Objects.nonNull(cascaderDatas)) break;
                        if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
                            List options = JsonUtil.getJsonToListMap((String)cascaderDatas.toString());
                            cascaderMap = OnlinePublicUtils.getDataMap((List<Map<String, Object>>)options, swapDataVo);
                        } else {
                            cascaderMap = JsonUtil.stringToMap((String)String.valueOf(cascaderDatas));
                        }
                        String value = String.valueOf(dataMap.get(vModel));
                        if (isMultiple.booleanValue()) {
                            String[][] data = (String[][])JsonUtil.getJsonToBean((String)value, String[][].class);
                            String casDataS = "";
                            StringBuilder cascaderData = new StringBuilder();
                            String[][] stringArray = data;
                            int n = stringArray.length;
                            for (int s = 0; s < n; ++s) {
                                String[] casData;
                                for (String s2 : casData = stringArray[s]) {
                                    casDataS = String.valueOf(cascaderMap.get(s2));
                                    cascaderData.append(casDataS + ",");
                                }
                            }
                            cascaderData = cascaderData.deleteCharAt(cascaderData.length() - 1);
                            dataMap.put(vModel, cascaderData);
                            break;
                        }
                        dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(cascaderMap, dataMap.get(vModel), isMultiple));
                        break;
                    }
                    case "checkbox": {
                        Map<String, Object> checkboxMap;
                        String checkBox = OnlineDataTypeEnum.STATIC.getType().equals(dataType) ? String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()) : (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType()) ? String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl()) : String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()));
                        Object checkData = cacheUtil.query(checkBox);
                        if (!Objects.nonNull(checkData)) break;
                        if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
                            List options = JsonUtil.getJsonToListMap((String)checkData.toString());
                            checkboxMap = OnlinePublicUtils.getDataMap((List<Map<String, Object>>)options, swapDataVo);
                        } else {
                            checkboxMap = JsonUtil.entityToMap((Object)checkData);
                        }
                        dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(checkboxMap, dataMap.get(vModel), isMultiple));
                        break;
                    }
                    case "relationForm": {
                        VisualdevEntity entity = visualdevService.getInfo(swapDataVo.getModelId());
                        String keyId = String.valueOf(dataMap.get(vModel));
                        Map formDataMap = new HashMap(16);
                        VisualdevModelDataInfoVO infoVO = !StringUtils.isEmpty((String)entity.getVisualTables()) && !"[]".equals(entity.getVisualTables()) ? visualDevInfoService.getDetailsDataInfo(keyId, entity) : visualdevModelDataService.infoDataChange(keyId, entity);
                        formDataMap = JsonUtil.stringToMap((String)infoVO.getData());
                        String relationField = swapDataVo.getRelationField();
                        if (formDataMap.size() <= 0) break;
                        dataMap.put(vModel + "_id", dataMap.get(vModel));
                        dataMap.put(vModel, formDataMap.get(relationField));
                        break;
                    }
                    case "popupSelect": {
                        Map PopMap;
                        Object data = dataInterfaceService.infoToId(swapDataVo.getInterfaceId()).getData();
                        DataInterfaceActionVo actionVo = (DataInterfaceActionVo)data;
                        List mapList = new ArrayList();
                        if (actionVo.getData() instanceof List) {
                            mapList = (List)actionVo.getData();
                        }
                        if ((PopMap = (Map)mapList.stream().filter(map -> map.get(swapDataVo.getPropsValue()).equals(dataMap.get(vModel))).findFirst().orElse(null)).size() <= 0) break;
                        dataMap.put(vModel + "_id", dataMap.get(vModel));
                        dataMap.put(vModel, PopMap.get(swapDataVo.getRelationField()));
                        break;
                    }
                    case "modifyTime": 
                    case "createTime": 
                    case "date": {
                        String format;
                        String dateSwapInfo;
                        String dateData = String.valueOf(dataMap.get(vModel));
                        String string = swapDataVo.getFormat() != null ? swapDataVo.getFormat() : (dateSwapInfo = swapDataVo.getType() != null && swapDataVo.getType().equals("date") ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                        if (!dateData.contains("-") && !dateData.contains(":") && dateData.length() > 10) {
                            DateTimeFormatter ftf = DateTimeFormatter.ofPattern(dateSwapInfo);
                            format = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)dataMap.get(vModel)), ZoneId.of("+8")));
                        } else {
                            format = dateData;
                        }
                        if (format.contains(".")) {
                            format = format.substring(0, format.lastIndexOf("."));
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(dateSwapInfo);
                        Date date = sdf.parse(format);
                        String outTime = sdf.format(sdf.parse(DateUtil.dateFormat((Date)date)));
                        dataMap.put(vModel, outTime);
                        break;
                    }
                    case "uploadFz": 
                    case "uploadImg": {
                        List fileList = JsonUtil.getJsonToListMap((String)String.valueOf(dataMap.get(vModel)));
                        dataMap.put(vModel, fileList);
                        break;
                    }
                }
                if (dataType == null || keyName.equals("cascader") || keyName.equals("checkbox")) continue;
                if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
                    redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
                    Object staticData = cacheUtil.query(redisKey);
                    if (!Objects.nonNull(staticData)) continue;
                    Map staticMap = JsonUtil.stringToMap((String)staticData.toString());
                    dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(staticMap, dataMap.get(vModel), isMultiple));
                    continue;
                }
                if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                    Object dynamicData;
                    redisKey = String.format("%s-%s-%s-%s-%s-", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getConfig().getProps().getLabel(), swapDataVo.getConfig().getProps().getValue());
                    if (keyName.equals("treeSelect")) {
                        redisKey = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getProps().getPropsModel().getLabel(), swapDataVo.getProps().getPropsModel().getValue(), swapDataVo.getProps().getPropsModel().getChildren());
                    }
                    if (!Objects.nonNull(dynamicData = cacheUtil.query(redisKey))) continue;
                    Map dynamicMap = JsonUtil.stringToMap((String)String.valueOf(dynamicData));
                    dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(dynamicMap, dataMap.get(vModel), isMultiple));
                    continue;
                }
                if (!dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType()) || !Objects.nonNull(dicObj = cacheUtil.query(redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType())))) continue;
                List dicObjList = JsonUtil.getJsonToListMap((String)dicObj.toString());
                Map<String, Object> dictionaryMap = OnlinePublicUtils.getDataMap((List<Map<String, Object>>)dicObjList, swapDataVo);
                dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(dictionaryMap, dataMap.get(vModel), isMultiple));
            }
            OnlineDevInfoUtils.swapCodeDataInfo(codeList, dataMap, dataCopyMap);
        }
        catch (Exception e) {
            log.error("\u5728\u7ebf\u5f00\u53d1\u8f6c\u6362\u6570\u636e\u5f02\u5e38:" + e.getMessage());
        }
        return dataMap;
    }

    public static Map<String, Object> swapChildTableDataInfo(List<FieLdsModel> modelList, Map<String, Object> dataMap, List<FormModel> codeList) {
        OnlineDevInfoUtils.init();
        HashMap<String, Object> dataCopyMap = new HashMap<String, Object>();
        dataCopyMap.putAll(dataMap);
        HashMap<String, Map<String, Object>> dataDetailMap = new HashMap<String, Map<String, Object>>();
        try {
            for (FieLdsModel swapDataVo : modelList) {
                ActionResult data;
                String keyName = swapDataVo.getConfig().getKeyName();
                String dataType = swapDataVo.getConfig().getDataType();
                String vModel = swapDataVo.getVModel();
                Object val = dataMap.get(vModel);
                Boolean isMultiple = swapDataVo.getMultiple();
                String modelValue = String.valueOf(val);
                if (StringUtils.isEmpty((String)modelValue) || "null".equals(modelValue)) continue;
                if (dataType != null) {
                    String value;
                    String label;
                    PropsBeanModel propsBeanModel;
                    String Children = "";
                    ArrayList<Map<String, Object>> options = new ArrayList();
                    if (swapDataVo.getConfig().getKeyName().equals("cascader") || swapDataVo.getConfig().getKeyName().equals("treeSelect")) {
                        propsBeanModel = (PropsBeanModel)JsonUtil.getJsonToBean((String)swapDataVo.getProps().getProps(), PropsBeanModel.class);
                        label = propsBeanModel.getLabel();
                        value = propsBeanModel.getValue();
                        Children = propsBeanModel.getChildren();
                    } else {
                        label = swapDataVo.getConfig().getProps().getLabel();
                        value = swapDataVo.getConfig().getProps().getValue();
                    }
                    if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
                        if (StringUtils.isNotEmpty((String)swapDataVo.getOptions())) {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                            if (ObjectUtil.isNotEmpty((Object)swapDataVo.getProps().getPropsModel())) {
                                Children = swapDataVo.getProps().getPropsModel().getChildren();
                            } else {
                                propsBeanModel = (PropsBeanModel)JsonUtil.getJsonToBean((String)swapDataVo.getProps().getProps(), PropsBeanModel.class);
                                Children = propsBeanModel.getChildren();
                            }
                            data = JsonUtil.getListToJsonArray(options);
                            OnlineDevListUtils.getOptions(label, value, Children, (JSONArray)data, options);
                        } else {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getSlot().getOptions());
                        }
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                        data = dataInterfaceService.infoToId(swapDataVo.getConfig().getPropsUrl());
                        DataInterfaceActionVo actionVo = (DataInterfaceActionVo)data.getData();
                        ArrayList arrayList = new ArrayList();
                        if (actionVo.getData() instanceof List) {
                            List list = (List)actionVo.getData();
                            String[][] dataAll = JsonUtil.getListToJsonArray((List)list);
                            OnlineDevInfoUtils.treeToList(label, value, Children, (JSONArray)dataAll, options);
                        }
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
                        List list = dictionaryDataService.getDicList(swapDataVo.getConfig().getDictionaryType());
                        options = list.stream().map(dic -> {
                            HashMap<String, String> dictionaryMap = new HashMap<String, String>(16);
                            dictionaryMap.put("id", dic.getId());
                            dictionaryMap.put("enCode", dic.getEnCode());
                            dictionaryMap.put("fullName", dic.getFullName());
                            return dictionaryMap;
                        }).collect(Collectors.toList());
                    }
                    HashMap dataInterfaceMap = new HashMap(16);
                    options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label))));
                    List<String> valueList = new ArrayList<String>();
                    if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                        String[][] stringArray;
                        for (String[] casData : stringArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class)) {
                            for (String s : casData) {
                                valueList.add(s);
                            }
                        }
                    } else if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) {
                        valueList = JsonUtil.getJsonToList((String)modelValue, String.class);
                    } else {
                        valueList.add(modelValue);
                    }
                    String string = valueList.stream().map(va -> (String)dataInterfaceMap.get(va)).collect(Collectors.joining(","));
                    dataMap.put(vModel, string);
                    continue;
                }
                switch (keyName) {
                    case "comSelect": 
                    case "depSelect": 
                    case "currDept": {
                        dataMap.put(vModel, OnlineDevInfoUtils.getOrgValue(modelValue));
                        break;
                    }
                    case "currOrganize": {
                        boolean isAll = "all".equals(swapDataVo.getShowLevel());
                        if (isAll) {
                            dataMap.put(vModel, PermissionUtil.getLinkInfoByOrgId((String)modelValue, (OrganizeService)organizeService, (Boolean)false));
                            break;
                        }
                        OrganizeEntity organizeEntity = organizeService.getInfo(modelValue);
                        dataMap.put(vModel, Objects.nonNull(organizeEntity) ? organizeEntity.getFullName() : modelValue);
                        break;
                    }
                    case "posSelect": 
                    case "currPosition": {
                        dataMap.put(vModel, OnlineDevInfoUtils.getPosValue(modelValue));
                        break;
                    }
                    case "userSelect": 
                    case "createUser": 
                    case "modifyUser": {
                        dataMap.put(vModel, OnlineDevInfoUtils.getUserValue(modelValue));
                        break;
                    }
                    case "address": {
                        String value = String.valueOf(dataMap.get(vModel));
                        if (OnlinePublicUtils.getMultiple(value, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                            data = (ActionResult)JsonUtil.getJsonToBean((String)value, String[][].class);
                            ArrayList<String> addList = new ArrayList<String>();
                            for (String[] AddressData : data) {
                                ArrayList<String> adList = new ArrayList<String>();
                                for (String s : AddressData) {
                                    adList.add(s);
                                }
                                addList.add(String.join((CharSequence)"/", provinceService.getProList(adList).stream().map(pro -> pro.getFullName()).collect(Collectors.toList())));
                            }
                            dataMap.put(vModel, String.join((CharSequence)";", addList));
                            break;
                        }
                        List proDataS = JsonUtil.getJsonToList((String)value, String.class);
                        dataMap.put(vModel, String.join((CharSequence)",", provinceService.getProList(proDataS).stream().map(pro -> pro.getFullName()).collect(Collectors.toList())));
                        break;
                    }
                    case "relationForm": {
                        VisualdevEntity entity = visualdevService.getInfo(swapDataVo.getModelId());
                        String string = String.valueOf(dataMap.get(vModel));
                        Map formDataMap = new HashMap(16);
                        VisualdevModelDataInfoVO infoVO = !StringUtils.isEmpty((String)entity.getVisualTables()) && !"[]".equals(entity.getVisualTables()) ? visualDevInfoService.getDetailsDataInfo(string, entity) : visualdevModelDataService.infoDataChange(string, entity);
                        formDataMap = JsonUtil.stringToMap((String)infoVO.getData());
                        String relationField = swapDataVo.getRelationField();
                        if (formDataMap.size() <= 0) break;
                        dataMap.put(vModel + "_id", dataMap.get(vModel));
                        dataMap.put(vModel, formDataMap.get(relationField));
                        dataDetailMap.put(vModel, formDataMap);
                        break;
                    }
                    case "popupSelect": {
                        Map PopMap;
                        Object data3 = dataInterfaceService.infoToId(swapDataVo.getInterfaceId()).getData();
                        DataInterfaceActionVo actionVo = (DataInterfaceActionVo)data3;
                        List mapList = new ArrayList();
                        if (actionVo.getData() instanceof List) {
                            mapList = (List)actionVo.getData();
                        }
                        if ((PopMap = (Map)mapList.stream().filter(map -> map.get(swapDataVo.getPropsValue()).equals(dataMap.get(vModel))).findFirst().orElse(null)).size() <= 0) break;
                        dataMap.put(vModel + "_id", dataMap.get(vModel));
                        dataMap.put(vModel, PopMap.get(((ColumnOptionModel)swapDataVo.getColumnOptions().get(0)).getValue()));
                        dataDetailMap.put(vModel, PopMap);
                        break;
                    }
                    case "modifyTime": 
                    case "createTime": 
                    case "date": {
                        String format;
                        String dateSwapInfo;
                        String dateData = String.valueOf(dataMap.get(vModel));
                        String string = swapDataVo.getFormat() != null ? swapDataVo.getFormat() : (dateSwapInfo = swapDataVo.getType() != null && swapDataVo.getType().equals("date") ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                        if (!dateData.contains("-") && !dateData.contains(":") && dateData.length() > 10) {
                            DateTimeFormatter ftf = DateTimeFormatter.ofPattern(dateSwapInfo);
                            format = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)dataMap.get(vModel)), ZoneId.of("+8")));
                        } else {
                            format = dateData;
                        }
                        if (format.contains(".")) {
                            format = format.substring(0, format.lastIndexOf("."));
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(dateSwapInfo);
                        try {
                            Date date = sdf.parse(format);
                            String outTime = sdf.format(sdf.parse(DateUtil.dateFormat((Date)date)));
                            dataMap.put(vModel, outTime);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "switch": {
                        String switchValue = String.valueOf(dataMap.get(vModel)).equals("1") ? swapDataVo.getActiveTxt() : swapDataVo.getInactiveTxt();
                        dataMap.put(vModel, switchValue);
                        break;
                    }
                    case "slider": {
                        dataMap.put(vModel, dataMap.get(vModel) != null ? Integer.valueOf(Integer.parseInt(String.valueOf(dataMap.get(vModel)))) : null);
                        break;
                    }
                    case "uploadFz": 
                    case "uploadImg": {
                        List fileList = JsonUtil.getJsonToListMap((String)String.valueOf(dataMap.get(vModel)));
                        dataMap.put(vModel, fileList);
                        break;
                    }
                }
            }
            OnlineDevInfoUtils.swapCodeDataInfo(codeList, dataMap, dataCopyMap);
            if (dataDetailMap.size() > 0) {
                OnlineDevInfoUtils.getDataAttr(modelList, dataMap, dataDetailMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }

    public static Map<String, Object> swapDataInfoType(List<FieLdsModel> modelList, Map<String, Object> dataMap) {
        OnlineDevInfoUtils.init();
        block22: for (FieLdsModel swapDataVo : modelList) {
            String keyName = swapDataVo.getConfig().getKeyName();
            String vModel = swapDataVo.getVModel();
            Object value = dataMap.get(vModel);
            if (value == null || ObjectUtil.isEmpty((Object)value)) continue;
            switch (keyName) {
                case "uploadFz": 
                case "uploadImg": {
                    List fileList = JsonUtil.getJsonToListMap((String)String.valueOf(value));
                    dataMap.put(vModel, fileList);
                    continue block22;
                }
                case "date": {
                    String dateSwapInfo = swapDataVo.getFormat() != null ? swapDataVo.getFormat() : (swapDataVo.getType() != null && swapDataVo.getType().equals("date") ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat sdf = new SimpleDateFormat(dateSwapInfo);
                    String s1 = String.valueOf(value);
                    Long s = null;
                    try {
                        s = sdf.parse(s1).getTime();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    dataMap.put(vModel, s);
                    continue block22;
                }
                case "switch": 
                case "slider": {
                    dataMap.put(vModel, value != null ? Integer.valueOf(Integer.parseInt(String.valueOf(value))) : null);
                    continue block22;
                }
                case "currOrganize": 
                case "currDept": {
                    if ("all".equals(swapDataVo.getShowLevel())) {
                        String organizeName = PermissionUtil.getLinkInfoByOrgId((String)String.valueOf(value), (OrganizeService)organizeService, (Boolean)false);
                        dataMap.put(vModel, organizeName);
                        continue block22;
                    }
                    OrganizeEntity organizeEntity = organizeService.getInfo(String.valueOf(value));
                    dataMap.put(vModel, Objects.nonNull(organizeEntity) ? organizeEntity.getFullName() : value);
                    continue block22;
                }
                case "currPosition": {
                    PositionEntity positionEntity = positionService.getInfo(String.valueOf(value));
                    dataMap.put(vModel, Objects.nonNull(positionEntity) ? positionEntity.getFullName() : value);
                    continue block22;
                }
                case "createUser": 
                case "modifyUser": {
                    UserEntity userEntity = userService.getInfo(String.valueOf(value));
                    String userValue = String.valueOf(value).equalsIgnoreCase("admin") ? "\u7ba1\u7406\u5458" : (Objects.nonNull(userEntity) ? userEntity.getRealName() : String.valueOf(value));
                    dataMap.put(vModel, userValue);
                    continue block22;
                }
            }
            if (OnlinePublicUtils.getMultiple(String.valueOf(value), MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                String[][] data = (String[][])JsonUtil.getJsonToBean((String)String.valueOf(value), String[][].class);
                dataMap.put(vModel, data);
                continue;
            }
            if (OnlinePublicUtils.getMultiple(String.valueOf(value), MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) {
                List list = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
                dataMap.put(vModel, list);
                continue;
            }
            dataMap.put(vModel, value);
        }
        return dataMap;
    }

    public static void swapCodeDataInfo(List<FormModel> codeList, Map<String, Object> swapDataMap, Map<String, Object> dataMap) {
        for (FormModel formModel : codeList) {
            Object relationValue;
            String relationFiled;
            String keyName = formModel.getConfig().getKeyName();
            if (!keyName.equals("qrcode") && !keyName.equals("barcode")) continue;
            String codeDataType = formModel.getDataType();
            if (!OnlineDataTypeEnum.RELATION.getType().equals(codeDataType) || !StringUtils.isNotEmpty((String)(relationFiled = formModel.getRelationField())) || !ObjectUtil.isNotEmpty((Object)(relationValue = dataMap.get(relationFiled)))) continue;
            swapDataMap.put(relationFiled + "_id", relationValue);
        }
    }

    private static void treeToList(String value, String label, String children, JSONArray data, List<Map<String, Object>> result) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            result.add(tree);
            if (ob.get((Object)children) == null) continue;
            JSONArray childArray = ob.getJSONArray(children);
            OnlineDevInfoUtils.treeToList(value, label, children, childArray, result);
        }
    }

    private static void getDataAttr(List<FieLdsModel> fieLdsModelList, Map<String, Object> dataMap, Map<String, Map<String, Object>> dataDetailMap) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            String keyName = fieLdsModel.getConfig().getKeyName();
            if (!keyName.equals("relationFormAttr") && !keyName.equals("popupAttr")) continue;
            String relationField = fieLdsModel.getRelationField();
            String showField = fieLdsModel.getShowField();
            Map<String, Object> formDataMap = dataDetailMap.get(relationField);
            dataMap.put(relationField + "_" + showField, formDataMap.get(showField));
        }
    }

    private static String getOrgValue(String modelValue) {
        String orgValue;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s : prgData) {
                    OrganizeEntity info = organizeService.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getFullName() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            orgValue = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            orgValue = allValue = valueList.stream().map(va -> {
                OrganizeEntity organizeEntity = organizeService.getInfo(va);
                return Objects.nonNull(organizeEntity) ? organizeEntity.getFullName() : va;
            }).collect(Collectors.joining(","));
        }
        return orgValue;
    }

    private static String getPosValue(String modelValue) {
        String posValue;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s : prgData) {
                    PositionEntity info = positionService.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getFullName() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            posValue = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            posValue = allValue = valueList.stream().map(va -> {
                PositionEntity positionEntity = positionService.getInfo(va);
                return Objects.nonNull(positionEntity) ? positionEntity.getFullName() : va;
            }).collect(Collectors.joining(","));
        }
        return posValue;
    }

    private static String getUserValue(String modelValue) {
        String userValue;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s : prgData) {
                    UserEntity info = userService.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getRealName() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            userValue = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            userValue = allValue = valueList.stream().map(va -> {
                UserEntity userEntity = userService.getInfo(va);
                return Objects.nonNull(userEntity) ? userEntity.getRealName() : va;
            }).collect(Collectors.joining(","));
        }
        return userValue;
    }
}

