/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.portal.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.model.home.EmailVO;
import com.bringspring.common.model.home.FlowTodoCountVO;
import com.bringspring.common.model.home.FlowTodoVO;
import com.bringspring.common.model.home.NoticeVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.service.EmailReceiveService;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.message.service.MessagereceiveService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e3b\u9875\u63a7\u5236\u5668"}, value="Home")
@RestController
@RequestMapping(value={"api/visualdev/Dashboard"})
public class DashboardController {
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowDelegateService flowDelegateService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private EmailReceiveService emailReceiveService;
    @Autowired
    private MessagereceiveService messagereceiveService;

    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u5f85\u529e")
    @GetMapping(value={"/FlowTodoCount"})
    public ActionResult getFlowTodoCount() {
        FlowTodoCountVO vo = new FlowTodoCountVO();
        vo.setToBeReviewed(Integer.valueOf(this.flowTaskService.getWaitList().size()));
        vo.setEntrust(Integer.valueOf(this.flowDelegateService.getList().size()));
        vo.setFlowDone(Integer.valueOf(this.flowTaskService.getTrialList().size()));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u901a\u77e5\u516c\u544a")
    @GetMapping(value={"/Notice"})
    public ActionResult getNotice() {
        List list = JsonUtil.getJsonToList((Object)this.messageService.getDashboardNoticeList(), NoticeVO.class);
        ArrayList<NoticeVO> listNew = new ArrayList<NoticeVO>();
        for (NoticeVO noticeVO : list) {
            MessageReceiveEntity oneByMessageId = this.messagereceiveService.getOneByMessageId(noticeVO.getId());
            if (ObjectUtil.isNotEmpty((Object)oneByMessageId)) {
                noticeVO.setIsRead(oneByMessageId.getIsRead());
            }
            listNew.add(noticeVO);
        }
        ListVO voList = new ListVO();
        voList.setList(listNew);
        return ActionResult.success((Object)voList);
    }

    @ApiOperation(value="\u83b7\u53d6\u672a\u8bfb\u90ae\u4ef6")
    @GetMapping(value={"/Email"})
    public ActionResult getEmail() {
        List list = JsonUtil.getJsonToList((Object)this.emailReceiveService.getDashboardReceiveList(), EmailVO.class);
        ListVO voList = new ListVO();
        voList.setList(list);
        return ActionResult.success((Object)voList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u4e8b\u9879")
    @GetMapping(value={"/FlowTodo"})
    public ActionResult getFlowTodo() {
        PaginationFlowTask pagination = new PaginationFlowTask();
        List waitList = this.flowTaskService.getWaitList(pagination);
        List engineList = this.flowEngineService.getFlowList(waitList.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        LinkedList<FlowTodoVO> list = new LinkedList<FlowTodoVO>();
        for (FlowTaskListModel taskEntity : waitList) {
            FlowTodoVO vo = (FlowTodoVO)JsonUtil.getJsonToBean((Object)taskEntity, FlowTodoVO.class);
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (engine != null) {
                vo.setFormType(engine.getFormType());
                vo.setEnCode(engine.getEnCode());
            }
            vo.setTaskNodeId(taskEntity.getThisStepId());
            vo.setTaskOperatorId(taskEntity.getTaskOperatorId());
            vo.setType(Integer.valueOf(2));
            list.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }
}

