package com.bringspring.visualdev.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.ComponentKeyConsts;
import com.bringspring.common.util.StringUtils;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineColumnFieldModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;

import java.sql.Connection;
import java.util.*;
import java.util.stream.Collectors;

/**
 *
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date  2021/7/28
 */
public class OnlineDatabaseUtils {
	public static List<OnlineDevListDataVO> getTableDataList(Connection conn, String sql, String pKeyName, List<OnlineColumnFieldModel> childFieldList)  {
		List<OnlineDevListDataVO> list = new ArrayList<>();
		try {
			List<List<DbFieldMod>> fieldMods = JdbcUtil.queryIncludeFieldMods(new PreparedStatementDTO(conn, sql));
			List<Map<String,Object>> dataList = new ArrayList<>();

			for (List<DbFieldMod> dblist : fieldMods){
				Map<String,Object> dataMap =new HashMap<>();
				HashMap<String, String> collect = dblist.stream().collect(Collectors.toMap(s -> Optional.ofNullable(s.getColumnName()).orElse(""), s -> Optional.ofNullable(s.getColumnValue()).orElse(""), (a, b) -> b, HashMap::new));
				dataMap.putAll(collect);
				for (OnlineColumnFieldModel on : childFieldList){
					//需要替换的子表字段
					DbFieldMod fieldMod = dblist.stream()
							.filter(dbMod -> dbMod.getTableName().equalsIgnoreCase(on.getTableName())
									&& dbMod.getColumnName().equalsIgnoreCase(on.getField())).findFirst().orElse(null);
					//将数据转成map格式
					if (ObjectUtil.isNotEmpty(fieldMod)){
						dataMap.remove(fieldMod.getColumnName());
						dataMap.put(on.getOriginallyField(),fieldMod.getColumnValue());
					}
				}
				dataList.add(dataMap);
			}
			for (Map<String, Object> dataMap : dataList) {
				OnlineDevListDataVO dataVo = new OnlineDevListDataVO();
				dataMap = toLowerKey(dataMap);
				dataVo.setData(dataMap);
				if (dataMap.containsKey(pKeyName.toUpperCase())) {
					dataVo.setId(String.valueOf(dataMap.get(pKeyName.toUpperCase())));
				}
				list.add(dataVo);
			}
		} catch (DataException e) {
			e.printStackTrace();
		}
		return list;
	}

	public static Map<String, Object> toLowerKey(Map<String, Object> map) {
		Map<String, Object> resultMap = new HashMap<>(16);
		Set<String> sets = map.keySet();
		for (String key : sets) {
			resultMap.put(key.toLowerCase(), map.get(key));
		}
		return resultMap;
	}

	public static Boolean existKey(List<String> feilds, String pKeyName) {
		if (feilds.size() > 0) {
			for (String feild : feilds) {
				if (feild.equals(pKeyName)) {
					return true;
				}
			}
		}
		return false;
	}

	public static List<OnlineDevListDataVO> setDataId(String keyName, List<OnlineDevListDataVO> DevList) {
		keyName = keyName.toLowerCase();
		for (OnlineDevListDataVO dataVo : DevList) {
			Map<String, Object> dataMap = dataVo.getData();
			if (dataMap.get(keyName) != null) {
				dataVo.setId(String.valueOf(dataMap.get(keyName)));
			}
		}
		return DevList;
	}

	public static List<Object> getValueList(List<VisualColumnSearchVO> searchVOList){
		List<Object> valueList = new LinkedList<>();
		for (VisualColumnSearchVO vo : searchVOList){
			String keyName = vo.getConfig().getKeyName();
			String format;
			switch (keyName){
				case ComponentKeyConsts.MODIFYTIME:
				case ComponentKeyConsts.CREATETIME:
				case ComponentKeyConsts.DATE:
					JSONArray timeStampArray = (JSONArray) vo.getValue();
					Long o1 =(Long) timeStampArray.get(0);
					Long o2 = (Long) timeStampArray.get(1);
					format = StringUtils.isEmpty(vo.getFormat()) ? "yyyy-MM-dd HH:mm:ss" : vo.getFormat();
					//时间戳转string格式
					String startTime = OnlinePublicUtils.getDateByFormat(o1,format);
					String endTime = OnlinePublicUtils.getDateByFormat(o2,format);
					//处理时间查询条件范围
					endTime=endTime.substring(0,10);
					String firstTimeDate = OnlineDatabaseUtils.getTimeFormat(startTime);
					String lastTimeDate =  OnlineDatabaseUtils.getLastTimeFormat(endTime);
					valueList.add(firstTimeDate);
					valueList.add(lastTimeDate);
					break;
				case ComponentKeyConsts.TIME:
					JSONArray timeArray =(JSONArray)vo.getValue();
					String start = String.valueOf(timeArray.get(0));
					String end =String.valueOf(timeArray.get(1));
					valueList.add(start);
					valueList.add(end);
					break;
				case ComponentKeyConsts.NUM_INPUT:
				case ComponentKeyConsts.CALCULATE:
					List<String> searchArray = (List<String>)vo.getValue();
					Integer firstValue = null;
					Integer secondValue = null;
					for(int i=0;i<searchArray.size();i++){
						String name = searchArray.get(i);
						if(StringUtils.isNotEmpty(name)) {
							if (i == 0) {
								firstValue =Integer.valueOf(name);
							} else {
								secondValue =Integer.valueOf(name);
							}
						}
					}
					if (firstValue != null){
						valueList.add(firstValue);
					}
					if (secondValue != null){
						valueList.add(secondValue);
					}
					break;
				default:
					valueList.add(vo.getValue());
					break;
			}
		}
		return valueList;
	}

	/**
	 * 转换时间格式
	 * @param time
	 * @return
	 */
	public static String getTimeFormat(String time){
		String result;
		switch (time.length()){
			case 16:
				result=time+":00";
				break;
			case 19:
				result=time;
				break;
			case 21:
				result=time.substring(0,time.length()-2);
				break;
			case 10:
				result=time+" 00:00:00";
				break;
			case 8:
				result="2000-01-01 "+time;
				break;
			default:
				result="";
				break;
		}
		return result;
	}

	public static String getLastTimeFormat(String time){
		String result;
		switch (time.length()){
			case 16:
				result=time+":00";
				break;
			case 19:
				result=time;
				break;
			case 10:
				result=time+" 23:59:59";
				break;
			case 8:
				result="2000-01-01 "+time;
				break;
			default:
				result="";
				break;
		}
		return result;
	}

}
